% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_start_instance_refresh}
\alias{autoscaling_start_instance_refresh}
\title{Starts a new instance refresh operation}
\usage{
autoscaling_start_instance_refresh(
  AutoScalingGroupName,
  Strategy = NULL,
  DesiredConfiguration = NULL,
  Preferences = NULL
)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{Strategy}{The strategy to use for the instance refresh. The only valid value is
\code{Rolling}.

A rolling update helps you update your instances gradually. A rolling
update can fail due to failed health checks or if instances are on
standby or are protected from scale in. If the rolling update process
fails, any instances that are replaced are not rolled back to their
previous configuration.}

\item{DesiredConfiguration}{The desired configuration. For example, the desired configuration can
specify a new launch template or a new version of the current launch
template.

Once the instance refresh succeeds, Amazon EC2 Auto Scaling updates the
settings of the Auto Scaling group to reflect the new desired
configuration.

When you specify a new launch template or a new version of the current
launch template for your desired configuration, consider enabling the
\code{SkipMatching} property in preferences. If it's enabled, Amazon EC2 Auto
Scaling skips replacing instances that already use the specified launch
template and version. This can help you reduce the number of
replacements that are required to apply updates.}

\item{Preferences}{Set of preferences associated with the instance refresh request. If not
provided, the default values are used.}
}
\description{
Starts a new instance refresh operation. An instance refresh performs a rolling replacement of all or some instances in an Auto Scaling group. Each instance is terminated first and then replaced, which temporarily reduces the capacity available within your Auto Scaling group.

See \url{https://paws-r.github.io/docs/autoscaling/start_instance_refresh.html} for full documentation.
}
\keyword{internal}
