% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroupstaggingapi_operations.R
\name{resourcegroupstaggingapi_get_resources}
\alias{resourcegroupstaggingapi_get_resources}
\title{Returns all the tagged resources that are associated with the specified
tags (keys and values) located in the specified region for the AWS
account}
\usage{
resourcegroupstaggingapi_get_resources(PaginationToken, TagFilters,
  ResourcesPerPage, TagsPerPage, ResourceTypeFilters)
}
\arguments{
\item{PaginationToken}{A string that indicates that additional data is available. Leave this
value empty for your initial request. If the response includes a
\code{PaginationToken}, use that string for this value to request an
additional page of data.}

\item{TagFilters}{A list of tags (keys and values). A request can include up to 50 keys,
and each key can include up to 20 values.

If you specify multiple filters connected by an AND operator in a single
request, the response returns only those resources that are associated
with every specified filter.

If you specify multiple filters connected by an OR operator in a single
request, the response returns all resources that are associated with at
least one or possibly more of the specified filters.}

\item{ResourcesPerPage}{A limit that restricts the number of resources returned by GetResources
in paginated output. You can set ResourcesPerPage to a minimum of 1 item
and the maximum of 50 items.}

\item{TagsPerPage}{A limit that restricts the number of tags (key and value pairs) returned
by GetResources in paginated output. A resource with no tags is counted
as having one tag (one key and value pair).

\code{GetResources} does not split a resource and its associated tags across
pages. If the specified \code{TagsPerPage} would cause such a break, a
\code{PaginationToken} is returned in place of the affected resource and its
tags. Use that token in another request to get the remaining data. For
example, if you specify a \code{TagsPerPage} of \code{100} and the account has 22
resources with 10 tags each (meaning that each resource has 10 key and
value pairs), the output will consist of 3 pages, with the first page
displaying the first 10 resources, each with its 10 tags, the second
page displaying the next 10 resources each with its 10 tags, and the
third page displaying the remaining 2 resources, each with its 10 tags.

You can set \code{TagsPerPage} to a minimum of 100 items and the maximum of
500 items.}

\item{ResourceTypeFilters}{The constraints on the resources that you want returned. The format of
each resource type is \code{service\\[:resourceType\\]}. For example,
specifying a resource type of \code{ec2} returns all tagged Amazon EC2
resources (which includes tagged EC2 instances). Specifying a resource
type of \code{ec2:instance} returns only EC2 instances.

The string for each service name and resource type is the same as that
embedded in a resource's Amazon Resource Name (ARN). Consult the \emph{AWS
General Reference} for the following:
\itemize{
\item For a list of service name strings, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces}{AWS Service Namespaces}.
\item For resource type strings, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax}{Example ARNs}.
\item For more information about ARNs, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.
}}
}
\description{
Returns all the tagged resources that are associated with the specified
tags (keys and values) located in the specified region for the AWS
account. The tags and the resource types that you specify in the request
are known as \emph{filters}. The response includes all tags that are
associated with the requested resources. If no filter is provided, this
action returns a paginated resource list with the associated tags.
}
\section{Request syntax}{
\preformatted{svc$get_resources(
  PaginationToken = "string",
  TagFilters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  ResourcesPerPage = 123,
  TagsPerPage = 123,
  ResourceTypeFilters = list(
    "string"
  )
)
}
}

\keyword{internal}
