% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_stop_instance}
\alias{opsworks_stop_instance}
\title{Stops a specified instance}
\usage{
opsworks_stop_instance(InstanceId, Force)
}
\arguments{
\item{InstanceId}{[required] The instance ID.}

\item{Force}{Specifies whether to force an instance to stop.}
}
\description{
Stops a specified instance. When you stop a standard instance, the data
disappears and must be reinstalled when you restart the instance. You
can stop an Amazon EBS-backed instance without losing data. For more
information, see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html}{Starting, Stopping, and Rebooting Instances}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$stop_instance(
  InstanceId = "string",
  Force = TRUE|FALSE
)
}
}

\keyword{internal}
