% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_update_prompt}
\alias{bedrockagent_update_prompt}
\title{Modifies a prompt in your prompt library}
\usage{
bedrockagent_update_prompt(
  customerEncryptionKeyArn = NULL,
  defaultVariant = NULL,
  description = NULL,
  name,
  promptIdentifier,
  variants = NULL
)
}
\arguments{
\item{customerEncryptionKeyArn}{The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.}

\item{defaultVariant}{The name of the default variant for the prompt. This value must match
the \code{name} field in the relevant
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html}{PromptVariant}
object.}

\item{description}{A description for the prompt.}

\item{name}{[required] A name for the prompt.}

\item{promptIdentifier}{[required] The unique identifier of the prompt.}

\item{variants}{A list of objects, each containing details about a variant of the
prompt.}
}
\description{
Modifies a prompt in your prompt library. Include both fields that you want to keep and fields that you want to replace. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html}{Prompt management in Amazon Bedrock} and \href{https://docs.aws.amazon.com/bedrock/latest/userguide/#prompt-management-edit}{Edit prompts in your prompt library} in the Amazon Bedrock User Guide.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_update_prompt/} for full documentation.
}
\keyword{internal}
