% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_send_pipeline_execution_step_success}
\alias{sagemaker_send_pipeline_execution_step_success}
\title{Notifies the pipeline that the execution of a callback step succeeded
and provides a list of the step's output parameters}
\usage{
sagemaker_send_pipeline_execution_step_success(
  CallbackToken,
  OutputParameters = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{CallbackToken}{[required] The pipeline generated token from the Amazon SQS queue.}

\item{OutputParameters}{A list of the output parameters of the callback step.}

\item{ClientRequestToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the operation. An idempotent operation completes no more
than one time.}
}
\description{
Notifies the pipeline that the execution of a callback step succeeded and provides a list of the step's output parameters. When a callback step is run, the pipeline generates a callback token and includes the token in a message sent to Amazon Simple Queue Service (Amazon SQS).

See \url{https://www.paws-r-sdk.com/docs/sagemaker_send_pipeline_execution_step_success/} for full documentation.
}
\keyword{internal}
