% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_create_ml_model}
\alias{machinelearning_create_ml_model}
\title{Creates a new MLModel using the DataSource and the recipe as information
sources}
\usage{
machinelearning_create_ml_model(
  MLModelId,
  MLModelName = NULL,
  MLModelType,
  Parameters = NULL,
  TrainingDataSourceId,
  Recipe = NULL,
  RecipeUri = NULL
)
}
\arguments{
\item{MLModelId}{[required] A user-supplied ID that uniquely identifies the \code{MLModel}.}

\item{MLModelName}{A user-supplied name or description of the \code{MLModel}.}

\item{MLModelType}{[required] The category of supervised learning that this \code{MLModel} will address.
Choose from the following types:
\itemize{
\item Choose \code{REGRESSION} if the \code{MLModel} will be used to predict a
numeric value.
\item Choose \code{BINARY} if the \code{MLModel} result has two possible values.
\item Choose \code{MULTICLASS} if the \code{MLModel} result has a limited number of
values.
}

For more information, see the \href{https://docs.aws.amazon.com/machine-learning/latest/dg/}{Amazon Machine Learning Developer Guide}.}

\item{Parameters}{A list of the training parameters in the \code{MLModel}. The list is
implemented as a map of key-value pairs.

The following is the current set of training parameters:
\itemize{
\item \code{sgd.maxMLModelSizeInBytes} - The maximum allowed size of the model.
Depending on the input data, the size of the model might affect its
performance.

The value is an integer that ranges from \code{100000} to \code{2147483648}.
The default value is \code{33554432}.
\item \code{sgd.maxPasses} - The number of times that the training process
traverses the observations to build the \code{MLModel}. The value is an
integer that ranges from \code{1} to \code{10000}. The default value is \code{10}.
\item \code{sgd.shuffleType} - Whether Amazon ML shuffles the training data.
Shuffling the data improves a model's ability to find the optimal
solution for a variety of data types. The valid values are \code{auto}
and \code{none}. The default value is \code{none}. We strongly recommend that
you shuffle your data.
\item \code{sgd.l1RegularizationAmount} - The coefficient regularization L1
norm. It controls overfitting the data by penalizing large
coefficients. This tends to drive coefficients to zero, resulting in
a sparse feature set. If you use this parameter, start by specifying
a small value, such as \code{1.0E-08}.

The value is a double that ranges from \code{0} to \code{MAX_DOUBLE}. The
default is to not use L1 normalization. This parameter can't be used
when \code{L2} is specified. Use this parameter sparingly.
\item \code{sgd.l2RegularizationAmount} - The coefficient regularization L2
norm. It controls overfitting the data by penalizing large
coefficients. This tends to drive coefficients to small, nonzero
values. If you use this parameter, start by specifying a small
value, such as \code{1.0E-08}.

The value is a double that ranges from \code{0} to \code{MAX_DOUBLE}. The
default is to not use L2 normalization. This parameter can't be used
when \code{L1} is specified. Use this parameter sparingly.
}}

\item{TrainingDataSourceId}{[required] The \code{DataSource} that points to the training data.}

\item{Recipe}{The data recipe for creating the \code{MLModel}. You must specify either the
recipe or its URI. If you don't specify a recipe or its URI, Amazon ML
creates a default.}

\item{RecipeUri}{The Amazon Simple Storage Service (Amazon S3) location and file name
that contains the \code{MLModel} recipe. You must specify either the recipe
or its URI. If you don't specify a recipe or its URI, Amazon ML creates
a default.}
}
\description{
Creates a new \code{MLModel} using the \code{DataSource} and the recipe as information sources.

See \url{https://www.paws-r-sdk.com/docs/machinelearning_create_ml_model/} for full documentation.
}
\keyword{internal}
