# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemakergeospatialcapabilities_service.R
NULL

#' Use this operation to delete an Earth Observation job
#'
#' @description
#' Use this operation to delete an Earth Observation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_delete_earth_observation_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_delete_earth_observation_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Earth Observation job being
#' deleted.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_delete_earth_observation_job
sagemakergeospatialcapabilities_delete_earth_observation_job <- function(Arn) {
  op <- new_operation(
    name = "DeleteEarthObservationJob",
    http_method = "DELETE",
    http_path = "/earth-observation-jobs/{Arn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$delete_earth_observation_job_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$delete_earth_observation_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$delete_earth_observation_job <- sagemakergeospatialcapabilities_delete_earth_observation_job

#' Use this operation to delete a Vector Enrichment job
#'
#' @description
#' Use this operation to delete a Vector Enrichment job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_delete_vector_enrichment_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_delete_vector_enrichment_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Vector Enrichment job being
#' deleted.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_delete_vector_enrichment_job
sagemakergeospatialcapabilities_delete_vector_enrichment_job <- function(Arn) {
  op <- new_operation(
    name = "DeleteVectorEnrichmentJob",
    http_method = "DELETE",
    http_path = "/vector-enrichment-jobs/{Arn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$delete_vector_enrichment_job_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$delete_vector_enrichment_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$delete_vector_enrichment_job <- sagemakergeospatialcapabilities_delete_vector_enrichment_job

#' Use this operation to export results of an Earth Observation job and
#' optionally source images used as input to the EOJ to an Amazon S3
#' location
#'
#' @description
#' Use this operation to export results of an Earth Observation job and optionally source images used as input to the EOJ to an Amazon S3 location.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_export_earth_observation_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_export_earth_observation_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The input Amazon Resource Name (ARN) of the Earth Observation job being
#' exported.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that you specified for
#' the job.
#' @param ExportSourceImages The source images provided to the Earth Observation job being exported.
#' @param OutputConfig &#91;required&#93; An object containing information about the output file.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_export_earth_observation_job
sagemakergeospatialcapabilities_export_earth_observation_job <- function(Arn, ClientToken = NULL, ExecutionRoleArn, ExportSourceImages = NULL, OutputConfig) {
  op <- new_operation(
    name = "ExportEarthObservationJob",
    http_method = "POST",
    http_path = "/export-earth-observation-job",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$export_earth_observation_job_input(Arn = Arn, ClientToken = ClientToken, ExecutionRoleArn = ExecutionRoleArn, ExportSourceImages = ExportSourceImages, OutputConfig = OutputConfig)
  output <- .sagemakergeospatialcapabilities$export_earth_observation_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$export_earth_observation_job <- sagemakergeospatialcapabilities_export_earth_observation_job

#' Use this operation to copy results of a Vector Enrichment job to an
#' Amazon S3 location
#'
#' @description
#' Use this operation to copy results of a Vector Enrichment job to an Amazon S3 location.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_export_vector_enrichment_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_export_vector_enrichment_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Vector Enrichment job.
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM rolewith permission to upload
#' to the location in OutputConfig.
#' @param OutputConfig &#91;required&#93; Output location information for exporting Vector Enrichment Job results.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_export_vector_enrichment_job
sagemakergeospatialcapabilities_export_vector_enrichment_job <- function(Arn, ClientToken = NULL, ExecutionRoleArn, OutputConfig) {
  op <- new_operation(
    name = "ExportVectorEnrichmentJob",
    http_method = "POST",
    http_path = "/export-vector-enrichment-jobs",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$export_vector_enrichment_job_input(Arn = Arn, ClientToken = ClientToken, ExecutionRoleArn = ExecutionRoleArn, OutputConfig = OutputConfig)
  output <- .sagemakergeospatialcapabilities$export_vector_enrichment_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$export_vector_enrichment_job <- sagemakergeospatialcapabilities_export_vector_enrichment_job

#' Get the details for a previously initiated Earth Observation job
#'
#' @description
#' Get the details for a previously initiated Earth Observation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_earth_observation_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_earth_observation_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Earth Observation job.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_get_earth_observation_job
sagemakergeospatialcapabilities_get_earth_observation_job <- function(Arn) {
  op <- new_operation(
    name = "GetEarthObservationJob",
    http_method = "GET",
    http_path = "/earth-observation-jobs/{Arn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$get_earth_observation_job_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$get_earth_observation_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$get_earth_observation_job <- sagemakergeospatialcapabilities_get_earth_observation_job

#' Use this operation to get details of a specific raster data collection
#'
#' @description
#' Use this operation to get details of a specific raster data collection.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_raster_data_collection/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_raster_data_collection/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the raster data collection.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_get_raster_data_collection
sagemakergeospatialcapabilities_get_raster_data_collection <- function(Arn) {
  op <- new_operation(
    name = "GetRasterDataCollection",
    http_method = "GET",
    http_path = "/raster-data-collection/{Arn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$get_raster_data_collection_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$get_raster_data_collection_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$get_raster_data_collection <- sagemakergeospatialcapabilities_get_raster_data_collection

#' Gets a web mercator tile for the given Earth Observation job
#'
#' @description
#' Gets a web mercator tile for the given Earth Observation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_tile/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_tile/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the tile operation.
#' @param ExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role that you specify.
#' @param ImageAssets &#91;required&#93; The particular assets or bands to tile.
#' @param ImageMask Determines whether or not to return a valid data mask.
#' @param OutputDataType The output data type of the tile operation.
#' @param OutputFormat The data format of the output tile. The formats include .npy, .png and
#' .jpg.
#' @param PropertyFilters Property filters for the imagery to tile.
#' @param Target &#91;required&#93; Determines what part of the Earth Observation job to tile. 'INPUT' or
#' 'OUTPUT' are the valid options.
#' @param TimeRangeFilter Time range filter applied to imagery to find the images to tile.
#' @param x &#91;required&#93; The x coordinate of the tile input.
#' @param y &#91;required&#93; The y coordinate of the tile input.
#' @param z &#91;required&#93; The z coordinate of the tile input.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_get_tile
sagemakergeospatialcapabilities_get_tile <- function(Arn, ExecutionRoleArn = NULL, ImageAssets, ImageMask = NULL, OutputDataType = NULL, OutputFormat = NULL, PropertyFilters = NULL, Target, TimeRangeFilter = NULL, x, y, z) {
  op <- new_operation(
    name = "GetTile",
    http_method = "GET",
    http_path = "/tile/{z}/{x}/{y}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$get_tile_input(Arn = Arn, ExecutionRoleArn = ExecutionRoleArn, ImageAssets = ImageAssets, ImageMask = ImageMask, OutputDataType = OutputDataType, OutputFormat = OutputFormat, PropertyFilters = PropertyFilters, Target = Target, TimeRangeFilter = TimeRangeFilter, x = x, y = y, z = z)
  output <- .sagemakergeospatialcapabilities$get_tile_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$get_tile <- sagemakergeospatialcapabilities_get_tile

#' Retrieves details of a Vector Enrichment Job for a given job Amazon
#' Resource Name (ARN)
#'
#' @description
#' Retrieves details of a Vector Enrichment Job for a given job Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_vector_enrichment_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_get_vector_enrichment_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Vector Enrichment job.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_get_vector_enrichment_job
sagemakergeospatialcapabilities_get_vector_enrichment_job <- function(Arn) {
  op <- new_operation(
    name = "GetVectorEnrichmentJob",
    http_method = "GET",
    http_path = "/vector-enrichment-jobs/{Arn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$get_vector_enrichment_job_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$get_vector_enrichment_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$get_vector_enrichment_job <- sagemakergeospatialcapabilities_get_vector_enrichment_job

#' Use this operation to get a list of the Earth Observation jobs
#' associated with the calling Amazon Web Services account
#'
#' @description
#' Use this operation to get a list of the Earth Observation jobs associated with the calling Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_earth_observation_jobs/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_earth_observation_jobs/) for full documentation.
#'
#' @param MaxResults The total number of items to return.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#' @param SortBy The parameter by which to sort the results.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param StatusEquals A filter that retrieves only jobs with a specific status.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_list_earth_observation_jobs
sagemakergeospatialcapabilities_list_earth_observation_jobs <- function(MaxResults = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListEarthObservationJobs",
    http_method = "POST",
    http_path = "/list-earth-observation-jobs",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "EarthObservationJobSummaries")
  )
  input <- .sagemakergeospatialcapabilities$list_earth_observation_jobs_input(MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder, StatusEquals = StatusEquals)
  output <- .sagemakergeospatialcapabilities$list_earth_observation_jobs_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$list_earth_observation_jobs <- sagemakergeospatialcapabilities_list_earth_observation_jobs

#' Use this operation to get raster data collections
#'
#' @description
#' Use this operation to get raster data collections.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_raster_data_collections/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_raster_data_collections/) for full documentation.
#'
#' @param MaxResults The total number of items to return.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_list_raster_data_collections
sagemakergeospatialcapabilities_list_raster_data_collections <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRasterDataCollections",
    http_method = "GET",
    http_path = "/raster-data-collections",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RasterDataCollectionSummaries")
  )
  input <- .sagemakergeospatialcapabilities$list_raster_data_collections_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .sagemakergeospatialcapabilities$list_raster_data_collections_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$list_raster_data_collections <- sagemakergeospatialcapabilities_list_raster_data_collections

#' Lists the tags attached to the resource
#'
#' @description
#' Lists the tags attached to the resource.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to tag.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_list_tags_for_resource
sagemakergeospatialcapabilities_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .sagemakergeospatialcapabilities$list_tags_for_resource_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$list_tags_for_resource <- sagemakergeospatialcapabilities_list_tags_for_resource

#' Retrieves a list of vector enrichment jobs
#'
#' @description
#' Retrieves a list of vector enrichment jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_vector_enrichment_jobs/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_list_vector_enrichment_jobs/) for full documentation.
#'
#' @param MaxResults The maximum number of items to return.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#' @param SortBy The parameter by which to sort the results.
#' @param SortOrder An optional value that specifies whether you want the results sorted in
#' `Ascending` or `Descending` order.
#' @param StatusEquals A filter that retrieves only jobs with a specific status.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_list_vector_enrichment_jobs
sagemakergeospatialcapabilities_list_vector_enrichment_jobs <- function(MaxResults = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListVectorEnrichmentJobs",
    http_method = "POST",
    http_path = "/list-vector-enrichment-jobs",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VectorEnrichmentJobSummaries")
  )
  input <- .sagemakergeospatialcapabilities$list_vector_enrichment_jobs_input(MaxResults = MaxResults, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder, StatusEquals = StatusEquals)
  output <- .sagemakergeospatialcapabilities$list_vector_enrichment_jobs_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$list_vector_enrichment_jobs <- sagemakergeospatialcapabilities_list_vector_enrichment_jobs

#' Allows you run image query on a specific raster data collection to get a
#' list of the satellite imagery matching the selected filters
#'
#' @description
#' Allows you run image query on a specific raster data collection to get a list of the satellite imagery matching the selected filters.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_search_raster_data_collection/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_search_raster_data_collection/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the raster data collection.
#' @param NextToken If the previous response was truncated, you receive this token. Use it
#' in your next request to receive the next set of results.
#' @param RasterDataCollectionQuery &#91;required&#93; RasterDataCollectionQuery consisting of
#' [AreaOfInterest(AOI)](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_AreaOfInterest.html),
#' [PropertyFilters](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_PropertyFilter.html)
#' and
#' [TimeRangeFilterInput](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_geospatial_TimeRangeFilterInput.html)
#' used in
#' [`search_raster_data_collection`][sagemakergeospatialcapabilities_search_raster_data_collection].
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_sea_ras_dat_col
sagemakergeospatialcapabilities_search_raster_data_collection <- function(Arn, NextToken = NULL, RasterDataCollectionQuery) {
  op <- new_operation(
    name = "SearchRasterDataCollection",
    http_method = "POST",
    http_path = "/search-raster-data-collection",
    paginator = list(input_token = "NextToken", output_token = "NextToken")
  )
  input <- .sagemakergeospatialcapabilities$search_raster_data_collection_input(Arn = Arn, NextToken = NextToken, RasterDataCollectionQuery = RasterDataCollectionQuery)
  output <- .sagemakergeospatialcapabilities$search_raster_data_collection_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$search_raster_data_collection <- sagemakergeospatialcapabilities_search_raster_data_collection

#' Use this operation to create an Earth observation job
#'
#' @description
#' Use this operation to create an Earth observation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_start_earth_observation_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_start_earth_observation_job/) for full documentation.
#'
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that you specified for
#' the job.
#' @param InputConfig &#91;required&#93; Input configuration information for the Earth Observation job.
#' @param JobConfig &#91;required&#93; An object containing information about the job configuration.
#' @param KmsKeyId The Key Management Service key ID for server-side encryption.
#' @param Name &#91;required&#93; The name of the Earth Observation job.
#' @param Tags Each tag consists of a key and a value.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_start_earth_observation_job
sagemakergeospatialcapabilities_start_earth_observation_job <- function(ClientToken = NULL, ExecutionRoleArn, InputConfig, JobConfig, KmsKeyId = NULL, Name, Tags = NULL) {
  op <- new_operation(
    name = "StartEarthObservationJob",
    http_method = "POST",
    http_path = "/earth-observation-jobs",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$start_earth_observation_job_input(ClientToken = ClientToken, ExecutionRoleArn = ExecutionRoleArn, InputConfig = InputConfig, JobConfig = JobConfig, KmsKeyId = KmsKeyId, Name = Name, Tags = Tags)
  output <- .sagemakergeospatialcapabilities$start_earth_observation_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$start_earth_observation_job <- sagemakergeospatialcapabilities_start_earth_observation_job

#' Creates a Vector Enrichment job for the supplied job type
#'
#' @description
#' Creates a Vector Enrichment job for the supplied job type. Currently, there are two supported job types: reverse geocoding and map matching.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_start_vector_enrichment_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_start_vector_enrichment_job/) for full documentation.
#'
#' @param ClientToken A unique token that guarantees that the call to this API is idempotent.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that you specified for
#' the job.
#' @param InputConfig &#91;required&#93; Input configuration information for the Vector Enrichment job.
#' @param JobConfig &#91;required&#93; An object containing information about the job configuration.
#' @param KmsKeyId The Key Management Service key ID for server-side encryption.
#' @param Name &#91;required&#93; The name of the Vector Enrichment job.
#' @param Tags Each tag consists of a key and a value.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_start_vector_enrichment_job
sagemakergeospatialcapabilities_start_vector_enrichment_job <- function(ClientToken = NULL, ExecutionRoleArn, InputConfig, JobConfig, KmsKeyId = NULL, Name, Tags = NULL) {
  op <- new_operation(
    name = "StartVectorEnrichmentJob",
    http_method = "POST",
    http_path = "/vector-enrichment-jobs",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$start_vector_enrichment_job_input(ClientToken = ClientToken, ExecutionRoleArn = ExecutionRoleArn, InputConfig = InputConfig, JobConfig = JobConfig, KmsKeyId = KmsKeyId, Name = Name, Tags = Tags)
  output <- .sagemakergeospatialcapabilities$start_vector_enrichment_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$start_vector_enrichment_job <- sagemakergeospatialcapabilities_start_vector_enrichment_job

#' Use this operation to stop an existing earth observation job
#'
#' @description
#' Use this operation to stop an existing earth observation job.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_stop_earth_observation_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_stop_earth_observation_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Earth Observation job being
#' stopped.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_stop_earth_observation_job
sagemakergeospatialcapabilities_stop_earth_observation_job <- function(Arn) {
  op <- new_operation(
    name = "StopEarthObservationJob",
    http_method = "POST",
    http_path = "/earth-observation-jobs/stop",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$stop_earth_observation_job_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$stop_earth_observation_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$stop_earth_observation_job <- sagemakergeospatialcapabilities_stop_earth_observation_job

#' Stops the Vector Enrichment job for a given job ARN
#'
#' @description
#' Stops the Vector Enrichment job for a given job ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_stop_vector_enrichment_job/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_stop_vector_enrichment_job/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the Vector Enrichment job.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_stop_vector_enrichment_job
sagemakergeospatialcapabilities_stop_vector_enrichment_job <- function(Arn) {
  op <- new_operation(
    name = "StopVectorEnrichmentJob",
    http_method = "POST",
    http_path = "/vector-enrichment-jobs/stop",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$stop_vector_enrichment_job_input(Arn = Arn)
  output <- .sagemakergeospatialcapabilities$stop_vector_enrichment_job_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$stop_vector_enrichment_job <- sagemakergeospatialcapabilities_stop_vector_enrichment_job

#' The resource you want to tag
#'
#' @description
#' The resource you want to tag.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_tag_resource/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to tag.
#' @param Tags &#91;required&#93; Each tag consists of a key and a value.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_tag_resource
sagemakergeospatialcapabilities_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sagemakergeospatialcapabilities$tag_resource_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$tag_resource <- sagemakergeospatialcapabilities_tag_resource

#' The resource you want to untag
#'
#' @description
#' The resource you want to untag.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_untag_resource/](https://www.paws-r-sdk.com/docs/sagemakergeospatialcapabilities_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to untag.
#' @param TagKeys &#91;required&#93; Keys of the tags you want to remove.
#'
#' @keywords internal
#'
#' @rdname sagemakergeospatialcapabilities_untag_resource
sagemakergeospatialcapabilities_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .sagemakergeospatialcapabilities$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sagemakergeospatialcapabilities$untag_resource_output()
  config <- get_config()
  svc <- .sagemakergeospatialcapabilities$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakergeospatialcapabilities$operations$untag_resource <- sagemakergeospatialcapabilities_untag_resource
