% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_model_cards}
\alias{sagemaker_list_model_cards}
\title{List existing model cards}
\usage{
sagemaker_list_model_cards(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  MaxResults = NULL,
  NameContains = NULL,
  ModelCardStatus = NULL,
  NextToken = NULL,
  SortBy = NULL,
  SortOrder = NULL
)
}
\arguments{
\item{CreationTimeAfter}{Only list model cards that were created after the time specified.}

\item{CreationTimeBefore}{Only list model cards that were created before the time specified.}

\item{MaxResults}{The maximum number of model cards to list.}

\item{NameContains}{Only list model cards with names that contain the specified string.}

\item{ModelCardStatus}{Only list model cards with the specified approval status.}

\item{NextToken}{If the response to a previous
\code{\link[=sagemaker_list_model_cards]{list_model_cards}} request was truncated,
the response includes a \code{NextToken}. To retrieve the next set of model
cards, use the token in the next request.}

\item{SortBy}{Sort model cards by either name or creation time. Sorts by creation time
by default.}

\item{SortOrder}{Sort model cards by ascending or descending order.}
}
\description{
List existing model cards.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_model_cards/} for full documentation.
}
\keyword{internal}
