% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_auto_ml_job_v2}
\alias{sagemaker_create_auto_ml_job_v2}
\title{Creates an Amazon SageMaker AutoML job that uses non-tabular data such
as images or text for Computer Vision or Natural Language Processing
problems}
\usage{
sagemaker_create_auto_ml_job_v2(
  AutoMLJobName,
  AutoMLJobInputDataConfig,
  OutputDataConfig,
  AutoMLProblemTypeConfig,
  RoleArn,
  Tags = NULL,
  SecurityConfig = NULL,
  AutoMLJobObjective = NULL,
  ModelDeployConfig = NULL,
  DataSplitConfig = NULL
)
}
\arguments{
\item{AutoMLJobName}{[required] Identifies an Autopilot job. The name must be unique to your account and
is case insensitive.}

\item{AutoMLJobInputDataConfig}{[required] An array of channel objects describing the input data and their
location. Each channel is a named input source. Similar to
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html#sagemaker-CreateAutoMLJob-request-InputDataConfig}{InputDataConfig}
supported by \code{\link[=sagemaker_create_auto_ml_job]{create_auto_ml_job}}. The
supported formats depend on the problem type:
\itemize{
\item ImageClassification: S3Prefix, \code{ManifestFile},
\code{AugmentedManifestFile}
\item TextClassification: S3Prefix
}}

\item{OutputDataConfig}{[required] Provides information about encryption and the Amazon S3 output path
needed to store artifacts from an AutoML job.}

\item{AutoMLProblemTypeConfig}{[required] Defines the configuration settings of one of the supported problem
types.}

\item{RoleArn}{[required] The ARN of the role that is used to access the data.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your Amazon
Web Services resources in different ways, such as by purpose, owner, or
environment. For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web ServicesResources}.
Tag keys must be unique per resource.}

\item{SecurityConfig}{The security configuration for traffic encryption or Amazon VPC
settings.}

\item{AutoMLJobObjective}{Specifies a metric to minimize or maximize as the objective of a job.
For \code{\link[=sagemaker_create_auto_ml_job_v2]{create_auto_ml_job_v2}}, only
\code{Accuracy} is supported.}

\item{ModelDeployConfig}{Specifies how to generate the endpoint name for an automatic one-click
Autopilot model deployment.}

\item{DataSplitConfig}{This structure specifies how to split the data into train and validation
datasets.

If you are using the V1 API (for example
\code{\link[=sagemaker_create_auto_ml_job]{create_auto_ml_job}}) or the V2 API for
Natural Language Processing problems (for example
\code{\link[=sagemaker_create_auto_ml_job_v2]{create_auto_ml_job_v2}} with a
\code{TextClassificationJobConfig} problem type), the validation and training
datasets must contain the same headers. Also, for V1 API jobs, the
validation dataset must be less than 2 GB in size.}
}
\description{
Creates an Amazon SageMaker AutoML job that uses non-tabular data such as images or text for Computer Vision or Natural Language Processing problems.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_auto_ml_job_v2/} for full documentation.
}
\keyword{internal}
