% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_list_imports}
\alias{lexmodelsv2_list_imports}
\title{Lists the imports for a bot, bot locale, or custom vocabulary}
\usage{
lexmodelsv2_list_imports(
  botId = NULL,
  botVersion = NULL,
  sortBy = NULL,
  filters = NULL,
  maxResults = NULL,
  nextToken = NULL,
  localeId = NULL
)
}
\arguments{
\item{botId}{The unique identifier that Amazon Lex assigned to the bot.}

\item{botVersion}{The version of the bot to list imports for.}

\item{sortBy}{Determines the field that the list of imports is sorted by. You can sort
by the \code{LastUpdatedDateTime} field in ascending or descending order.}

\item{filters}{Provides the specification of a filter used to limit the bots in the
response to only those that match the filter specification. You can only
specify one filter and one string to filter on.}

\item{maxResults}{The maximum number of imports to return in each page of results. If
there are fewer results than the max page size, only the actual number
of results are returned.}

\item{nextToken}{If the response from the \code{\link[=lexmodelsv2_list_imports]{list_imports}}
operation contains more results than specified in the \code{maxResults}
parameter, a token is returned in the response.

Use the returned token in the \code{nextToken} parameter of a
\code{\link[=lexmodelsv2_list_imports]{list_imports}} request to return the next
page of results. For a complete set of results, call the
\code{\link[=lexmodelsv2_list_imports]{list_imports}} operation until the
\code{nextToken} returned in the response is null.}

\item{localeId}{Specifies the locale that should be present in the list. If you don't
specify a resource type in the \code{filters} parameter, the list contains
both bot locales and custom vocabularies.}
}
\description{
Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_list_imports/} for full documentation.
}
\keyword{internal}
