% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalizeruntime_operations.R
\name{personalizeruntime_get_recommendations}
\alias{personalizeruntime_get_recommendations}
\title{Returns a list of recommended items}
\usage{
personalizeruntime_get_recommendations(campaignArn, itemId, userId,
  numResults, context, filterArn)
}
\arguments{
\item{campaignArn}{[required] The Amazon Resource Name (ARN) of the campaign to use for getting
recommendations.}

\item{itemId}{The item ID to provide recommendations for.

Required for \code{RELATED_ITEMS} recipe type.}

\item{userId}{The user ID to provide recommendations for.

Required for \code{USER_PERSONALIZATION} recipe type.}

\item{numResults}{The number of results to return. The default is 25. The maximum is 500.}

\item{context}{The contextual metadata to use when getting recommendations. Contextual
metadata includes any interaction information that might be relevant
when getting a user\'s recommendations, such as the user\'s current
location or device type.}

\item{filterArn}{The ARN of the filter to apply to the returned recommendations. For more
information, see Using Filters with Amazon Personalize.}
}
\description{
Returns a list of recommended items. The required input depends on the
recipe type used to create the solution backing the campaign, as
follows:
}
\details{
\itemize{
\item RELATED\\_ITEMS - \code{itemId} required, \code{userId} not used
\item USER\\_PERSONALIZATION - \code{itemId} optional, \code{userId} required
}

Campaigns that are backed by a solution created using a recipe of type
PERSONALIZED\\_RANKING use the API.
}
\section{Request syntax}{
\preformatted{svc$get_recommendations(
  campaignArn = "string",
  itemId = "string",
  userId = "string",
  numResults = 123,
  context = list(
    "string"
  ),
  filterArn = "string"
)
}
}

\keyword{internal}
