# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Polly
#'
#' @description
#' Amazon Polly is a web service that makes it easy to synthesize speech
#' from text.
#' 
#' The Amazon Polly service provides API operations for synthesizing
#' high-quality speech from plain text and Speech Synthesis Markup Language
#' (SSML), along with managing pronunciations lexicons that enable you to
#' get the best results for your application domain.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- polly(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- polly()
#' # Deletes a specified pronunciation lexicon stored in an AWS Region.
#' svc$delete_lexicon(
#'   Name = "example"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=polly_delete_lexicon]{delete_lexicon} \tab Deletes the specified pronunciation lexicon stored in an AWS Region \cr
#'  \link[=polly_describe_voices]{describe_voices} \tab Returns the list of voices that are available for use when requesting speech synthesis \cr
#'  \link[=polly_get_lexicon]{get_lexicon} \tab Returns the content of the specified pronunciation lexicon stored in an AWS Region \cr
#'  \link[=polly_get_speech_synthesis_task]{get_speech_synthesis_task} \tab Retrieves a specific SpeechSynthesisTask object based on its TaskID \cr
#'  \link[=polly_list_lexicons]{list_lexicons} \tab Returns a list of pronunciation lexicons stored in an AWS Region \cr
#'  \link[=polly_list_speech_synthesis_tasks]{list_speech_synthesis_tasks} \tab Returns a list of SpeechSynthesisTask objects ordered by their creation date \cr
#'  \link[=polly_put_lexicon]{put_lexicon} \tab Stores a pronunciation lexicon in an AWS Region \cr
#'  \link[=polly_start_speech_synthesis_task]{start_speech_synthesis_task} \tab Allows the creation of an asynchronous synthesis task, by starting a new SpeechSynthesisTask\cr
#'  \link[=polly_synthesize_speech]{synthesize_speech} \tab Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes 
#' }
#'
#' @rdname polly
#' @export
polly <- function(config = list()) {
  svc <- .polly$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.polly <- list()

.polly$operations <- list()

.polly$metadata <- list(
  service_name = "polly",
  endpoints = list("*" = list(endpoint = "polly.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "polly.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "polly.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "polly.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Polly",
  api_version = "2016-06-10",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.polly$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.polly$metadata, handlers, config)
}
