% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_endpoint}
\alias{sagemaker_create_endpoint}
\title{Creates an endpoint using the endpoint configuration specified in the
request}
\usage{
sagemaker_create_endpoint(EndpointName, EndpointConfigName, Tags)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint. The name must be unique within an AWS Region
in your AWS account.}

\item{EndpointConfigName}{[required] The name of an endpoint configuration. For more information, see
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html}{CreateEndpointConfig}.}

\item{Tags}{An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}in
the \emph{AWS Billing and Cost Management User Guide}.}
}
\description{
Creates an endpoint using the endpoint configuration specified in the
request. Amazon SageMaker uses the endpoint to provision resources and
deploy models. You create the endpoint configuration with the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html}{CreateEndpointConfig}
API.
}
\details{
Use this API only for hosting models using Amazon SageMaker hosting
services.

You must not delete an \code{EndpointConfig} in use by an endpoint that is
live or while the \code{UpdateEndpoint} or \code{CreateEndpoint} operations are
being performed on the endpoint. To update an endpoint, you must create
a new \code{EndpointConfig}.

The endpoint name must be unique within an AWS Region in your AWS
account.

When it receives the request, Amazon SageMaker creates the endpoint,
launches the resources (ML compute instances), and deploys the model(s)
on them.

When Amazon SageMaker receives the request, it sets the endpoint status
to \code{Creating}. After it creates the endpoint, it sets the status to
\code{InService}. Amazon SageMaker can then process incoming requests for
inferences. To check the status of an endpoint, use the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html}{DescribeEndpoint}
API.

For an example, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/ex1.html}{Exercise 1: Using the K-Means Algorithm Provided by Amazon SageMaker}.

If any of the models hosted at this endpoint get model data from an
Amazon S3 location, Amazon SageMaker uses AWS Security Token Service to
download model artifacts from the S3 path you provided. AWS STS is
activated in your IAM user account by default. If you previously
deactivated AWS STS for a region, you need to reactivate AWS STS for
that region. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html}{Activating and Deactivating AWS STS in an AWS Region}
in the \emph{AWS Identity and Access Management User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_endpoint(
  EndpointName = "string",
  EndpointConfigName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
