# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lexruntimeservice_service.R
NULL

#' Sends user input (text or speech) to Amazon Lex
#'
#' Sends user input (text or speech) to Amazon Lex. Clients use this API to
#' send text and audio requests to Amazon Lex at runtime. Amazon Lex
#' interprets the user input using the machine learning model that it built
#' for the bot.
#' 
#' The `PostContent` operation supports audio input at 8kHz and 16kHz. You
#' can use 8kHz audio to achieve higher speech recognition accuracy in
#' telephone audio applications.
#' 
#' In response, Amazon Lex returns the next message to convey to the user.
#' Consider the following example messages:
#' 
#' -   For a user input \"I would like a pizza,\" Amazon Lex might return a
#'     response with a message eliciting slot data (for example,
#'     `PizzaSize`): \"What size pizza would you like?\".
#' 
#' -   After the user provides all of the pizza order information, Amazon
#'     Lex might return a response with a message to get user confirmation:
#'     \"Order the pizza?\".
#' 
#' -   After the user replies \"Yes\" to the confirmation prompt, Amazon
#'     Lex might return a conclusion statement: \"Thank you, your cheese
#'     pizza has been ordered.\".
#' 
#' Not all Amazon Lex messages require a response from the user. For
#' example, conclusion statements do not require a response. Some messages
#' require only a yes or no response. In addition to the `message`, Amazon
#' Lex provides additional context about the message in the response that
#' you can use to enhance client behavior, such as displaying the
#' appropriate client user interface. Consider the following examples:
#' 
#' -   If the message is to elicit slot data, Amazon Lex returns the
#'     following context information:
#' 
#'     -   `x-amz-lex-dialog-state` header set to `ElicitSlot`
#' 
#'     -   `x-amz-lex-intent-name` header set to the intent name in the
#'         current context
#' 
#'     -   `x-amz-lex-slot-to-elicit` header set to the slot name for which
#'         the `message` is eliciting information
#' 
#'     -   `x-amz-lex-slots` header set to a map of slots configured for
#'         the intent with their current values
#' 
#' -   If the message is a confirmation prompt, the
#'     `x-amz-lex-dialog-state` header is set to `Confirmation` and the
#'     `x-amz-lex-slot-to-elicit` header is omitted.
#' 
#' -   If the message is a clarification prompt configured for the intent,
#'     indicating that the user intent is not understood, the
#'     `x-amz-dialog-state` header is set to `ElicitIntent` and the
#'     `x-amz-slot-to-elicit` header is omitted.
#' 
#' In addition, Amazon Lex also returns your application-specific
#' `sessionAttributes`. For more information, see [Managing Conversation
#' Context](http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html).
#'
#' @usage
#' lexruntimeservice_post_content(botName, botAlias, userId,
#'   sessionAttributes, requestAttributes, contentType, accept, inputStream)
#'
#' @param botName &#91;required&#93; Name of the Amazon Lex bot.
#' @param botAlias &#91;required&#93; Alias of the Amazon Lex bot.
#' @param userId &#91;required&#93; The ID of the client application user. Amazon Lex uses this to identify
#' a user\'s conversation with your bot. At runtime, each request must
#' contain the `userID` field.
#' 
#' To decide the user ID to use for your application, consider the
#' following factors.
#' 
#' -   The `userID` field must not contain any personally identifiable
#'     information of the user, for example, name, personal identification
#'     numbers, or other end user personal information.
#' 
#' -   If you want a user to start a conversation on one device and
#'     continue on another device, use a user-specific identifier.
#' 
#' -   If you want the same user to be able to have two independent
#'     conversations on two different devices, choose a device-specific
#'     identifier.
#' 
#' -   A user can\'t have two independent conversations with two different
#'     versions of the same bot. For example, a user can\'t have a
#'     conversation with the PROD and BETA versions of the same bot. If you
#'     anticipate that a user will need to have conversation with two
#'     different versions, for example, while testing, include the bot
#'     alias in the user ID to separate the two conversations.
#' @param sessionAttributes You pass this value as the `x-amz-lex-session-attributes` HTTP header.
#' 
#' Application-specific information passed between Amazon Lex and a client
#' application. The value must be a JSON serialized and base64 encoded map
#' with string keys and values. The total size of the `sessionAttributes`
#' and `requestAttributes` headers is limited to 12 KB.
#' 
#' For more information, see [Setting Session
#' Attributes](http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
#' @param requestAttributes You pass this value as the `x-amz-lex-request-attributes` HTTP header.
#' 
#' Request-specific information passed between Amazon Lex and a client
#' application. The value must be a JSON serialized and base64 encoded map
#' with string keys and values. The total size of the `requestAttributes`
#' and `sessionAttributes` headers is limited to 12 KB.
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don\'t
#' create any request attributes with the prefix `x-amz-lex:`.
#' 
#' For more information, see [Setting Request
#' Attributes](http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
#' @param contentType &#91;required&#93; You pass this value as the `Content-Type` HTTP header.
#' 
#' Indicates the audio format or text. The header value must start with one
#' of the following prefixes:
#' 
#' -   PCM format, audio data must be in little-endian byte order.
#' 
#'     -   audio/l16; rate=16000; channels=1
#' 
#'     -   audio/x-l16; sample-rate=16000; channel-count=1
#' 
#'     -   audio/lpcm; sample-rate=8000; sample-size-bits=16;
#'         channel-count=1; is-big-endian=false
#' 
#' -   Opus format
#' 
#'     -   audio/x-cbr-opus-with-preamble; preamble-size=0;
#'         bit-rate=256000; frame-size-milliseconds=4
#' 
#' -   Text format
#' 
#'     -   text/plain; charset=utf-8
#' @param accept You pass this value as the `Accept` HTTP header.
#' 
#' The message Amazon Lex returns in the response can be either text or
#' speech based on the `Accept` HTTP header value in the request.
#' 
#' -   If the value is `text/plain; charset=utf-8`, Amazon Lex returns text
#'     in the response.
#' 
#' -   If the value begins with `audio/`, Amazon Lex returns speech in the
#'     response. Amazon Lex uses Amazon Polly to generate the speech (using
#'     the configuration you specified in the `Accept` header). For
#'     example, if you specify `audio/mpeg` as the value, Amazon Lex
#'     returns speech in the MPEG format.
#' 
#'     The following are the accepted values:
#' 
#'     -   audio/mpeg
#' 
#'     -   audio/ogg
#' 
#'     -   audio/pcm
#' 
#'     -   text/plain; charset=utf-8
#' 
#'     -   audio/\* (defaults to mpeg)
#' @param inputStream &#91;required&#93; User input in PCM or Opus audio format or text format as described in
#' the `Content-Type` HTTP header.
#' 
#' You can stream audio data to Amazon Lex or you can create a local buffer
#' that captures all of the audio data before sending. In general, you get
#' better performance if you stream audio data rather than buffering the
#' data locally.
#'
#' @section Request syntax:
#' ```
#' svc$post_content(
#'   botName = "string",
#'   botAlias = "string",
#'   userId = "string",
#'   sessionAttributes = "string",
#'   requestAttributes = "string",
#'   contentType = "string",
#'   accept = "string",
#'   inputStream = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_post_content
lexruntimeservice_post_content <- function(botName, botAlias, userId, sessionAttributes = NULL, requestAttributes = NULL, contentType, accept = NULL, inputStream) {
  op <- new_operation(
    name = "PostContent",
    http_method = "POST",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/content",
    paginator = list()
  )
  input <- .lexruntimeservice$post_content_input(botName = botName, botAlias = botAlias, userId = userId, sessionAttributes = sessionAttributes, requestAttributes = requestAttributes, contentType = contentType, accept = accept, inputStream = inputStream)
  output <- .lexruntimeservice$post_content_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$post_content <- lexruntimeservice_post_content

#' Sends user input (text-only) to Amazon Lex
#'
#' Sends user input (text-only) to Amazon Lex. Client applications can use
#' this API to send requests to Amazon Lex at runtime. Amazon Lex then
#' interprets the user input using the machine learning model it built for
#' the bot.
#' 
#' In response, Amazon Lex returns the next `message` to convey to the user
#' an optional `responseCard` to display. Consider the following example
#' messages:
#' 
#' -   For a user input \"I would like a pizza\", Amazon Lex might return a
#'     response with a message eliciting slot data (for example,
#'     PizzaSize): \"What size pizza would you like?\"
#' 
#' -   After the user provides all of the pizza order information, Amazon
#'     Lex might return a response with a message to obtain user
#'     confirmation \"Proceed with the pizza order?\".
#' 
#' -   After the user replies to a confirmation prompt with a \"yes\",
#'     Amazon Lex might return a conclusion statement: \"Thank you, your
#'     cheese pizza has been ordered.\".
#' 
#' Not all Amazon Lex messages require a user response. For example, a
#' conclusion statement does not require a response. Some messages require
#' only a \"yes\" or \"no\" user response. In addition to the `message`,
#' Amazon Lex provides additional context about the message in the response
#' that you might use to enhance client behavior, for example, to display
#' the appropriate client user interface. These are the `slotToElicit`,
#' `dialogState`, `intentName`, and `slots` fields in the response.
#' Consider the following examples:
#' 
#' -   If the message is to elicit slot data, Amazon Lex returns the
#'     following context information:
#' 
#'     -   `dialogState` set to ElicitSlot
#' 
#'     -   `intentName` set to the intent name in the current context
#' 
#'     -   `slotToElicit` set to the slot name for which the `message` is
#'         eliciting information
#' 
#'     -   `slots` set to a map of slots, configured for the intent, with
#'         currently known values
#' 
#' -   If the message is a confirmation prompt, the `dialogState` is set to
#'     ConfirmIntent and `SlotToElicit` is set to null.
#' 
#' -   If the message is a clarification prompt (configured for the intent)
#'     that indicates that user intent is not understood, the `dialogState`
#'     is set to ElicitIntent and `slotToElicit` is set to null.
#' 
#' In addition, Amazon Lex also returns your application-specific
#' `sessionAttributes`. For more information, see [Managing Conversation
#' Context](http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html).
#'
#' @usage
#' lexruntimeservice_post_text(botName, botAlias, userId,
#'   sessionAttributes, requestAttributes, inputText)
#'
#' @param botName &#91;required&#93; The name of the Amazon Lex bot.
#' @param botAlias &#91;required&#93; The alias of the Amazon Lex bot.
#' @param userId &#91;required&#93; The ID of the client application user. Amazon Lex uses this to identify
#' a user\'s conversation with your bot. At runtime, each request must
#' contain the `userID` field.
#' 
#' To decide the user ID to use for your application, consider the
#' following factors.
#' 
#' -   The `userID` field must not contain any personally identifiable
#'     information of the user, for example, name, personal identification
#'     numbers, or other end user personal information.
#' 
#' -   If you want a user to start a conversation on one device and
#'     continue on another device, use a user-specific identifier.
#' 
#' -   If you want the same user to be able to have two independent
#'     conversations on two different devices, choose a device-specific
#'     identifier.
#' 
#' -   A user can\'t have two independent conversations with two different
#'     versions of the same bot. For example, a user can\'t have a
#'     conversation with the PROD and BETA versions of the same bot. If you
#'     anticipate that a user will need to have conversation with two
#'     different versions, for example, while testing, include the bot
#'     alias in the user ID to separate the two conversations.
#' @param sessionAttributes Application-specific information passed between Amazon Lex and a client
#' application.
#' 
#' For more information, see [Setting Session
#' Attributes](http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
#' @param requestAttributes Request-specific information passed between Amazon Lex and a client
#' application.
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don\'t
#' create any request attributes with the prefix `x-amz-lex:`.
#' 
#' For more information, see [Setting Request
#' Attributes](http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
#' @param inputText &#91;required&#93; The text that the user entered (Amazon Lex interprets this text).
#'
#' @section Request syntax:
#' ```
#' svc$post_text(
#'   botName = "string",
#'   botAlias = "string",
#'   userId = "string",
#'   sessionAttributes = list(
#'     "string"
#'   ),
#'   requestAttributes = list(
#'     "string"
#'   ),
#'   inputText = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_post_text
lexruntimeservice_post_text <- function(botName, botAlias, userId, sessionAttributes = NULL, requestAttributes = NULL, inputText) {
  op <- new_operation(
    name = "PostText",
    http_method = "POST",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/text",
    paginator = list()
  )
  input <- .lexruntimeservice$post_text_input(botName = botName, botAlias = botAlias, userId = userId, sessionAttributes = sessionAttributes, requestAttributes = requestAttributes, inputText = inputText)
  output <- .lexruntimeservice$post_text_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$post_text <- lexruntimeservice_post_text
