% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_stop_hyper_parameter_tuning_job}
\alias{sagemaker_stop_hyper_parameter_tuning_job}
\title{Stops a running hyperparameter tuning job and all running training jobs
that the tuning job launched}
\usage{
sagemaker_stop_hyper_parameter_tuning_job(HyperParameterTuningJobName)
}
\arguments{
\item{HyperParameterTuningJobName}{[required] The name of the tuning job to stop.}
}
\value{
An empty list.
}
\description{
Stops a running hyperparameter tuning job and all running training jobs
that the tuning job launched.

All model artifacts output from the training jobs are stored in Amazon
Simple Storage Service (Amazon S3). All data that the training jobs
write to Amazon CloudWatch Logs are still available in CloudWatch. After
the tuning job moves to the \code{Stopped} state, it releases all reserved
resources for the tuning job.
}
\section{Request syntax}{
\preformatted{svc$stop_hyper_parameter_tuning_job(
  HyperParameterTuningJobName = "string"
)
}
}

\keyword{internal}
