% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalizeevents_service.R
\name{personalizeevents}
\alias{personalizeevents}
\title{Amazon Personalize Events}
\usage{
personalizeevents(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Personalize can consume real-time user event data, such as
\emph{stream} or \emph{click} data, and use it for model training either alone or
combined with historical data. For more information see
recording-events.
}
\section{Service syntax}{
\preformatted{svc <- personalizeevents(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=personalizeevents_put_events]{put_events} \tab Records user interaction event data\cr
\link[=personalizeevents_put_items]{put_items} \tab Adds one or more items to an Items dataset\cr
\link[=personalizeevents_put_users]{put_users} \tab Adds one or more users to a Users dataset
}
}

\examples{
\dontrun{
svc <- personalizeevents()
svc$put_events(
  Foo = 123
)
}

}
