% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_dataset_import_job}
\alias{personalize_create_dataset_import_job}
\title{Creates a job that imports training data from your data source (an
Amazon S3 bucket) to an Amazon Personalize dataset}
\usage{
personalize_create_dataset_import_job(jobName, datasetArn, dataSource,
  roleArn)
}
\arguments{
\item{jobName}{[required] The name for the dataset import job.}

\item{datasetArn}{[required] The ARN of the dataset that receives the imported data.}

\item{dataSource}{[required] The Amazon S3 bucket that contains the training data to import.}

\item{roleArn}{[required] The ARN of the IAM role that has permissions to read from the Amazon S3
data source.}
}
\value{
A list with the following syntax:\preformatted{list(
  datasetImportJobArn = "string"
)
}
}
\description{
Creates a job that imports training data from your data source (an
Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon
Personalize to import the training data, you must specify an AWS
Identity and Access Management (IAM) role that has permission to read
from the data source, as Amazon Personalize makes a copy of your data
and processes it in an internal AWS system.

The dataset import job replaces any previous data in the dataset.

\strong{Status}

A dataset import job can be in one of the following states:
\itemize{
\item CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE
FAILED
}

To get the status of the import job, call
\code{\link[=personalize_describe_dataset_import_job]{describe_dataset_import_job}},
providing the Amazon Resource Name (ARN) of the dataset import job. The
dataset import is complete when the status shows as ACTIVE. If the
status shows as CREATE FAILED, the response includes a \code{failureReason}
key, which describes why the job failed.

Importing takes time. You must wait until the status shows as ACTIVE
before training a model using the dataset.

\strong{Related APIs}
\itemize{
\item \code{\link[=personalize_list_dataset_import_jobs]{list_dataset_import_jobs}}
\item \code{\link[=personalize_describe_dataset_import_job]{describe_dataset_import_job}}
}
}
\section{Request syntax}{
\preformatted{svc$create_dataset_import_job(
  jobName = "string",
  datasetArn = "string",
  dataSource = list(
    dataLocation = "string"
  ),
  roleArn = "string"
)
}
}

\keyword{internal}
