% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_search_faces_by_image}
\alias{rekognition_search_faces_by_image}
\title{For a given input image, first detects the largest face in the image,
and then searches the specified collection for matching faces}
\usage{
rekognition_search_faces_by_image(CollectionId, Image, MaxFaces,
  FaceMatchThreshold, QualityFilter)
}
\arguments{
\item{CollectionId}{[required] ID of the collection to search.}

\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{MaxFaces}{Maximum number of faces to return. The operation returns the maximum
number of faces with the highest confidence in the match.}

\item{FaceMatchThreshold}{(Optional) Specifies the minimum confidence in the face match to return.
For example, don't return any matches where confidence in matches is
less than 70\%. The default value is 80\%.}

\item{QualityFilter}{A filter that specifies a quality bar for how much filtering is done to
identify faces. Filtered faces aren't searched for in the collection. If
you specify \code{AUTO}, Amazon Rekognition chooses the quality bar. If you
specify \code{LOW}, \code{MEDIUM}, or \code{HIGH}, filtering removes all faces that
don’t meet the chosen quality bar. The quality bar is based on a variety
of common use cases. Low-quality detections can occur for a number of
reasons. Some examples are an object that's misidentified as a face, a
face that's too blurry, or a face with a pose that's too extreme to use.
If you specify \code{NONE}, no filtering is performed. The default value is
\code{NONE}.

To use quality filtering, the collection you are using must be
associated with version 3 of the face model or higher.}
}
\description{
For a given input image, first detects the largest face in the image,
and then searches the specified collection for matching faces. The
operation compares the features of the input face with faces in the
specified collection.

To search for all faces in an input image, you might first call the
IndexFaces operation, and then use the face IDs returned in subsequent
calls to the SearchFaces operation.

You can also call the \code{DetectFaces} operation and use the bounding boxes
in the response to make face crops, which then you can pass in to the
\code{SearchFacesByImage} operation.

You pass the input image either as base64-encoded image bytes or as a
reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
call Amazon Rekognition operations, passing image bytes is not
supported. The image must be either a PNG or JPEG formatted file.

The response returns an array of faces that match, ordered by similarity
score with the highest similarity first. More specifically, it is an
array of metadata for each face match found. Along with the metadata,
the response also includes a \code{similarity} indicating how similar the
face is to the input face. In the response, the operation also returns
the bounding box (and a confidence level that the bounding box contains
a face) of the face that Amazon Rekognition used for the input image.

For an example, Searching for a Face Using an Image in the Amazon
Rekognition Developer Guide.

The \code{QualityFilter} input parameter allows you to filter out detected
faces that don’t meet a required quality bar. The quality bar is based
on a variety of common use cases. Use \code{QualityFilter} to set the quality
bar for filtering by specifying \code{LOW}, \code{MEDIUM}, or \code{HIGH}. If you do
not want to filter detected faces, specify \code{NONE}. The default value is
\code{NONE}.

To use quality filtering, you need a collection associated with version
3 of the face model or higher. To get the version of the face model
associated with a collection, call DescribeCollection.

This operation requires permissions to perform the
\code{rekognition:SearchFacesByImage} action.
}
\section{Request syntax}{
\preformatted{svc$search_faces_by_image(
  CollectionId = "string",
  Image = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  MaxFaces = 123,
  FaceMatchThreshold = 123.0,
  QualityFilter = "NONE"|"AUTO"|"LOW"|"MEDIUM"|"HIGH"
)
}
}

\examples{
\dontrun{
# This operation searches for faces in a Rekognition collection that match
# the largest face in an S3 bucket stored image.
svc$search_faces_by_image(
  CollectionId = "myphotos",
  FaceMatchThreshold = 95L,
  Image = list(
    S3Object = list(
      Bucket = "mybucket",
      Name = "myphoto"
    )
  ),
  MaxFaces = 5L
)
}

}
\keyword{internal}
