% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_endpoint_weights_and_capacities}
\alias{sagemaker_update_endpoint_weights_and_capacities}
\title{Updates variant weight of one or more variants associated with an
existing endpoint, or capacity of one variant associated with an
existing endpoint}
\usage{
sagemaker_update_endpoint_weights_and_capacities(EndpointName,
  DesiredWeightsAndCapacities)
}
\arguments{
\item{EndpointName}{[required] The name of an existing Amazon SageMaker endpoint.}

\item{DesiredWeightsAndCapacities}{[required] An object that provides new capacity and weight values for a variant.}
}
\description{
Updates variant weight of one or more variants associated with an
existing endpoint, or capacity of one variant associated with an
existing endpoint. When it receives the request, Amazon SageMaker sets
the endpoint status to \code{Updating}. After updating the endpoint, it sets
the status to \code{InService}. To check the status of an endpoint, use the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html}{DescribeEndpoint}
API.
}
\section{Request syntax}{
\preformatted{svc$update_endpoint_weights_and_capacities(
  EndpointName = "string",
  DesiredWeightsAndCapacities = list(
    list(
      VariantName = "string",
      DesiredWeight = 123.0,
      DesiredInstanceCount = 123
    )
  )
)
}
}

\keyword{internal}
