% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_backtrack_db_cluster}
\alias{rds_backtrack_db_cluster}
\title{Backtracks a DB cluster to a specific time, without creating a new DB
cluster}
\usage{
rds_backtrack_db_cluster(
  DBClusterIdentifier,
  BacktrackTo,
  Force = NULL,
  UseEarliestTimeOnPointInTimeUnavailable = NULL
)
}
\arguments{
\item{DBClusterIdentifier}{[required] The DB cluster identifier of the DB cluster to be backtracked. This
parameter is stored as a lowercase string.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{BacktrackTo}{[required] The timestamp of the time to backtrack the DB cluster to, specified in
ISO 8601 format. For more information about ISO 8601, see the \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

If the specified time isn't a consistent time for the DB cluster, Aurora
automatically chooses the nearest possible consistent time for the DB
cluster.

Constraints:
\itemize{
\item Must contain a valid ISO 8601 timestamp.
\item Can't contain a timestamp set in the future.
}

Example: \verb{2017-07-08T18:00Z}}

\item{Force}{Specifies whether to force the DB cluster to backtrack when binary
logging is enabled. Otherwise, an error occurs when binary logging is
enabled.}

\item{UseEarliestTimeOnPointInTimeUnavailable}{Specifies whether to backtrack the DB cluster to the earliest possible
backtrack time when \emph{BacktrackTo} is set to a timestamp earlier than the
earliest backtrack time. When this parameter is disabled and
\emph{BacktrackTo} is set to a timestamp earlier than the earliest backtrack
time, an error occurs.}
}
\description{
Backtracks a DB cluster to a specific time, without creating a new DB cluster.

See \url{https://www.paws-r-sdk.com/docs/rds_backtrack_db_cluster/} for full documentation.
}
\keyword{internal}
