% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_reserved_node_offerings}
\alias{redshift_describe_reserved_node_offerings}
\title{Returns a list of the available reserved node offerings by Amazon
Redshift with their descriptions including the node type, the fixed and
recurring costs of reserving the node and duration the node will be
reserved for you}
\usage{
redshift_describe_reserved_node_offerings(
  ReservedNodeOfferingId = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ReservedNodeOfferingId}{The unique identifier for the offering.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.

Default: \code{100}

Constraints: minimum 20, maximum 100.}

\item{Marker}{An optional parameter that specifies the starting point to return a set
of response records. When the results of a
\code{\link[=redshift_describe_reserved_node_offerings]{describe_reserved_node_offerings}}
request exceed the value specified in \code{MaxRecords}, Amazon Web Services
returns a value in the \code{Marker} field of the response. You can retrieve
the next set of response records by providing the returned marker value
in the \code{Marker} parameter and retrying the request.}
}
\description{
Returns a list of the available reserved node offerings by Amazon Redshift with their descriptions including the node type, the fixed and recurring costs of reserving the node and duration the node will be reserved for you. These descriptions help you determine which reserve node offering you want to purchase. You then use the unique offering ID in you call to \code{\link[=redshift_purchase_reserved_node_offering]{purchase_reserved_node_offering}} to reserve one or more nodes for your Amazon Redshift cluster.

See \url{https://www.paws-r-sdk.com/docs/redshift_describe_reserved_node_offerings/} for full documentation.
}
\keyword{internal}
