# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Redshift Serverless
#'
#' @description
#' This is an interface reference for Amazon Redshift Serverless. It
#' contains documentation for one of the programming or command line
#' interfaces you can use to manage Amazon Redshift Serverless.
#' 
#' Amazon Redshift Serverless automatically provisions data warehouse
#' capacity and intelligently scales the underlying resources based on
#' workload demands. Amazon Redshift Serverless adjusts capacity in seconds
#' to deliver consistently high performance and simplified operations for
#' even the most demanding and volatile workloads. Amazon Redshift
#' Serverless lets you focus on using your data to acquire new insights for
#' your business and customers.
#' 
#' To learn more about Amazon Redshift Serverless, see [What is Amazon
#' Redshift
#' Serverless](https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- redshiftserverless(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- redshiftserverless()
#' svc$convert_recovery_point_to_snapshot(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=redshiftserverless_convert_recovery_point_to_snapshot]{convert_recovery_point_to_snapshot} \tab Converts a recovery point to a snapshot\cr
#'  \link[=redshiftserverless_create_custom_domain_association]{create_custom_domain_association} \tab Creates a custom domain association for Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_create_endpoint_access]{create_endpoint_access} \tab Creates an Amazon Redshift Serverless managed VPC endpoint\cr
#'  \link[=redshiftserverless_create_namespace]{create_namespace} \tab Creates a namespace in Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_create_scheduled_action]{create_scheduled_action} \tab Creates a scheduled action\cr
#'  \link[=redshiftserverless_create_snapshot]{create_snapshot} \tab Creates a snapshot of all databases in a namespace\cr
#'  \link[=redshiftserverless_create_snapshot_copy_configuration]{create_snapshot_copy_configuration} \tab Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region\cr
#'  \link[=redshiftserverless_create_usage_limit]{create_usage_limit} \tab Creates a usage limit for a specified Amazon Redshift Serverless usage type\cr
#'  \link[=redshiftserverless_create_workgroup]{create_workgroup} \tab Creates an workgroup in Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_delete_custom_domain_association]{delete_custom_domain_association} \tab Deletes a custom domain association for Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_delete_endpoint_access]{delete_endpoint_access} \tab Deletes an Amazon Redshift Serverless managed VPC endpoint\cr
#'  \link[=redshiftserverless_delete_namespace]{delete_namespace} \tab Deletes a namespace from Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_delete_resource_policy]{delete_resource_policy} \tab Deletes the specified resource policy\cr
#'  \link[=redshiftserverless_delete_scheduled_action]{delete_scheduled_action} \tab Deletes a scheduled action\cr
#'  \link[=redshiftserverless_delete_snapshot]{delete_snapshot} \tab Deletes a snapshot from Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_delete_snapshot_copy_configuration]{delete_snapshot_copy_configuration} \tab Deletes a snapshot copy configuration\cr
#'  \link[=redshiftserverless_delete_usage_limit]{delete_usage_limit} \tab Deletes a usage limit from Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_delete_workgroup]{delete_workgroup} \tab Deletes a workgroup\cr
#'  \link[=redshiftserverless_get_credentials]{get_credentials} \tab Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_get_custom_domain_association]{get_custom_domain_association} \tab Gets information about a specific custom domain association\cr
#'  \link[=redshiftserverless_get_endpoint_access]{get_endpoint_access} \tab Returns information, such as the name, about a VPC endpoint\cr
#'  \link[=redshiftserverless_get_namespace]{get_namespace} \tab Returns information about a namespace in Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_get_recovery_point]{get_recovery_point} \tab Returns information about a recovery point\cr
#'  \link[=redshiftserverless_get_resource_policy]{get_resource_policy} \tab Returns a resource policy\cr
#'  \link[=redshiftserverless_get_scheduled_action]{get_scheduled_action} \tab Returns information about a scheduled action\cr
#'  \link[=redshiftserverless_get_snapshot]{get_snapshot} \tab Returns information about a specific snapshot\cr
#'  \link[=redshiftserverless_get_table_restore_status]{get_table_restore_status} \tab Returns information about a TableRestoreStatus object\cr
#'  \link[=redshiftserverless_get_usage_limit]{get_usage_limit} \tab Returns information about a usage limit\cr
#'  \link[=redshiftserverless_get_workgroup]{get_workgroup} \tab Returns information about a specific workgroup\cr
#'  \link[=redshiftserverless_list_custom_domain_associations]{list_custom_domain_associations} \tab Lists custom domain associations for Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_list_endpoint_access]{list_endpoint_access} \tab Returns an array of EndpointAccess objects and relevant information\cr
#'  \link[=redshiftserverless_list_namespaces]{list_namespaces} \tab Returns information about a list of specified namespaces\cr
#'  \link[=redshiftserverless_list_recovery_points]{list_recovery_points} \tab Returns an array of recovery points\cr
#'  \link[=redshiftserverless_list_scheduled_actions]{list_scheduled_actions} \tab Returns a list of scheduled actions\cr
#'  \link[=redshiftserverless_list_snapshot_copy_configurations]{list_snapshot_copy_configurations} \tab Returns a list of snapshot copy configurations\cr
#'  \link[=redshiftserverless_list_snapshots]{list_snapshots} \tab Returns a list of snapshots\cr
#'  \link[=redshiftserverless_list_table_restore_status]{list_table_restore_status} \tab Returns information about an array of TableRestoreStatus objects\cr
#'  \link[=redshiftserverless_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags assigned to a resource\cr
#'  \link[=redshiftserverless_list_usage_limits]{list_usage_limits} \tab Lists all usage limits within Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_list_workgroups]{list_workgroups} \tab Returns information about a list of specified workgroups\cr
#'  \link[=redshiftserverless_put_resource_policy]{put_resource_policy} \tab Creates or updates a resource policy\cr
#'  \link[=redshiftserverless_restore_from_recovery_point]{restore_from_recovery_point} \tab Restore the data from a recovery point\cr
#'  \link[=redshiftserverless_restore_from_snapshot]{restore_from_snapshot} \tab Restores a namespace from a snapshot\cr
#'  \link[=redshiftserverless_restore_table_from_recovery_point]{restore_table_from_recovery_point} \tab Restores a table from a recovery point to your Amazon Redshift Serverless instance\cr
#'  \link[=redshiftserverless_restore_table_from_snapshot]{restore_table_from_snapshot} \tab Restores a table from a snapshot to your Amazon Redshift Serverless instance\cr
#'  \link[=redshiftserverless_tag_resource]{tag_resource} \tab Assigns one or more tags to a resource\cr
#'  \link[=redshiftserverless_untag_resource]{untag_resource} \tab Removes a tag or set of tags from a resource\cr
#'  \link[=redshiftserverless_update_custom_domain_association]{update_custom_domain_association} \tab Updates an Amazon Redshift Serverless certificate associated with a custom domain\cr
#'  \link[=redshiftserverless_update_endpoint_access]{update_endpoint_access} \tab Updates an Amazon Redshift Serverless managed endpoint\cr
#'  \link[=redshiftserverless_update_namespace]{update_namespace} \tab Updates a namespace with the specified settings\cr
#'  \link[=redshiftserverless_update_scheduled_action]{update_scheduled_action} \tab Updates a scheduled action\cr
#'  \link[=redshiftserverless_update_snapshot]{update_snapshot} \tab Updates a snapshot\cr
#'  \link[=redshiftserverless_update_snapshot_copy_configuration]{update_snapshot_copy_configuration} \tab Updates a snapshot copy configuration\cr
#'  \link[=redshiftserverless_update_usage_limit]{update_usage_limit} \tab Update a usage limit in Amazon Redshift Serverless\cr
#'  \link[=redshiftserverless_update_workgroup]{update_workgroup} \tab Updates a workgroup with the specified configuration settings
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname redshiftserverless
#' @export
redshiftserverless <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .redshiftserverless$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.redshiftserverless <- list()

.redshiftserverless$operations <- list()

.redshiftserverless$metadata <- list(
  service_name = "redshiftserverless",
  endpoints = list("*" = list(endpoint = "redshift-serverless.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "redshift-serverless.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "redshift-serverless.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "redshift-serverless.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "redshift-serverless.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "redshift-serverless.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Redshift Serverless",
  api_version = "2021-04-21",
  signing_name = "redshift-serverless",
  json_version = "1.1",
  target_prefix = "RedshiftServerless"
)

.redshiftserverless$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.redshiftserverless$metadata, handlers, config)
}
