% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_cluster_parameter_group}
\alias{rds_modify_db_cluster_parameter_group}
\title{Modifies the parameters of a DB cluster parameter group}
\usage{
rds_modify_db_cluster_parameter_group(DBClusterParameterGroupName, Parameters)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group to modify.}

\item{Parameters}{[required] A list of parameters in the DB cluster parameter group to modify.

Valid Values (for the application method): \code{immediate | pending-reboot}

You can use the \code{immediate} value with dynamic parameters only. You can
use the \code{pending-reboot} value for both dynamic and static parameters.

When the application method is \code{immediate}, changes to dynamic
parameters are applied immediately to the DB clusters associated with
the parameter group. When the application method is \code{pending-reboot},
changes to dynamic and static parameters are applied after a reboot
without failover to the DB clusters associated with the parameter group.}
}
\description{
Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the following: \code{ParameterName}, \code{ParameterValue}, and \code{ApplyMethod}. A maximum of 20 parameters can be modified in a single request.

See \url{https://paws-r.github.io/docs/rds/modify_db_cluster_parameter_group.html} for full documentation.
}
\keyword{internal}
