% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_orderable_db_instance_options}
\alias{rds_describe_orderable_db_instance_options}
\title{Returns a list of orderable DB instance options for the specified DB
engine, DB engine version, and DB instance class}
\usage{
rds_describe_orderable_db_instance_options(
  Engine,
  EngineVersion = NULL,
  DBInstanceClass = NULL,
  LicenseModel = NULL,
  AvailabilityZoneGroup = NULL,
  Vpc = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{Engine}{[required] The name of the engine to retrieve DB instance options for.

Valid Values:
\itemize{
\item \code{aurora} (for MySQL 5.6-compatible Aurora)
\item \code{aurora-mysql} (for MySQL 5.7-compatible and MySQL 8.0-compatible
Aurora)
\item \code{aurora-postgresql}
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{EngineVersion}{The engine version filter value. Specify this parameter to show only the
available offerings matching the specified engine version.}

\item{DBInstanceClass}{The DB instance class filter value. Specify this parameter to show only
the available offerings matching the specified DB instance class.}

\item{LicenseModel}{The license model filter value. Specify this parameter to show only the
available offerings matching the specified license model.

RDS Custom supports only the BYOL licensing model.}

\item{AvailabilityZoneGroup}{The Availability Zone group associated with a Local Zone. Specify this
parameter to retrieve available offerings for the Local Zones in the
group.

Omit this parameter to show the available offerings in the specified
Amazon Web Services Region.

This setting doesn't apply to RDS Custom.}

\item{Vpc}{A value that indicates whether to show only VPC or non-VPC offerings.
RDS Custom supports only VPC offerings.

RDS Custom supports only VPC offerings. If you describe non-VPC
offerings for RDS Custom, the output shows VPC offerings.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 10000.}

\item{Marker}{An optional pagination token provided by a previous
DescribeOrderableDBInstanceOptions request. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance class.

See \url{https://paws-r.github.io/docs/rds/describe_orderable_db_instance_options.html} for full documentation.
}
\keyword{internal}
