% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_delete_replication_group}
\alias{elasticache_delete_replication_group}
\title{Deletes an existing replication group}
\usage{
elasticache_delete_replication_group(
  ReplicationGroupId,
  RetainPrimaryCluster = NULL,
  FinalSnapshotIdentifier = NULL
)
}
\arguments{
\item{ReplicationGroupId}{[required] The identifier for the cluster to be deleted. This parameter is not case
sensitive.}

\item{RetainPrimaryCluster}{If set to \code{true}, all of the read replicas are deleted, but the primary
node is retained.}

\item{FinalSnapshotIdentifier}{The name of a final node group (shard) snapshot. ElastiCache creates the
snapshot from the primary node in the cluster, rather than one of the
replicas; this is to ensure that it captures the freshest data. After
the final snapshot is taken, the replication group is immediately
deleted.}
}
\description{
Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting \code{RetainPrimaryCluster=true}.

See \url{https://paws-r.github.io/docs/elasticache/delete_replication_group.html} for full documentation.
}
\keyword{internal}
