% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodbstreams_operations.R
\name{dynamodbstreams_list_streams}
\alias{dynamodbstreams_list_streams}
\title{Returns an array of stream ARNs associated with the current account and
endpoint}
\usage{
dynamodbstreams_list_streams(TableName, Limit, ExclusiveStartStreamArn)
}
\arguments{
\item{TableName}{If this parameter is provided, then only the streams associated with
this table name are returned.}

\item{Limit}{The maximum number of streams to return. The upper limit is 100.}

\item{ExclusiveStartStreamArn}{The ARN (Amazon Resource Name) of the first item that this operation
will evaluate. Use the value that was returned for
\code{LastEvaluatedStreamArn} in the previous operation.}
}
\description{
Returns an array of stream ARNs associated with the current account and
endpoint. If the \code{TableName} parameter is present, then \code{ListStreams}
will return only the streams ARNs for that table.
}
\details{
You can call \code{ListStreams} at a maximum rate of 5 times per second.
}
\section{Request syntax}{
\preformatted{svc$list_streams(
  TableName = "string",
  Limit = 123,
  ExclusiveStartStreamArn = "string"
)
}
}

\examples{
# The following example lists all of the stream ARNs.
\dontrun{svc$list_streams()}

}
\keyword{internal}
