% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_delete_cluster}
\alias{redshift_delete_cluster}
\title{Deletes a previously provisioned cluster}
\usage{
redshift_delete_cluster(ClusterIdentifier, SkipFinalClusterSnapshot,
  FinalClusterSnapshotIdentifier, FinalClusterSnapshotRetentionPeriod)
}
\arguments{
\item{ClusterIdentifier}{[required] The identifier of the cluster to be deleted.

Constraints:
\itemize{
\item Must contain lowercase characters.
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{SkipFinalClusterSnapshot}{Determines whether a final snapshot of the cluster is created before
Amazon Redshift deletes the cluster. If \code{true}, a final cluster snapshot
is not created. If \code{false}, a final cluster snapshot is created before
the cluster is deleted.

The \emph{FinalClusterSnapshotIdentifier} parameter must be specified if
\emph{SkipFinalClusterSnapshot} is \code{false}.

Default: \code{false}}

\item{FinalClusterSnapshotIdentifier}{The identifier of the final snapshot that is to be created immediately
before deleting the cluster. If this parameter is provided,
\emph{SkipFinalClusterSnapshot} must be \code{false}.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}

\item{FinalClusterSnapshotRetentionPeriod}{The number of days that a manual snapshot is retained. If the value is
-1, the manual snapshot is retained indefinitely.

The value must be either -1 or an integer between 1 and 3,653.

The default value is -1.}
}
\description{
Deletes a previously provisioned cluster. A successful response from the
web service indicates that the request was received correctly. Use
DescribeClusters to monitor the status of the deletion. The delete
operation cannot be canceled or reverted once submitted. For more
information about managing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html}{Amazon Redshift Clusters}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\details{
If you want to shut down the cluster and retain it for future use, set
\emph{SkipFinalClusterSnapshot} to \code{false} and specify a name for
\emph{FinalClusterSnapshotIdentifier}. You can later restore this snapshot to
resume using the cluster. If a final cluster snapshot is requested, the
status of the cluster will be "final-snapshot" while the snapshot is
being taken, then it's "deleting" once Amazon Redshift begins
deleting the cluster.

For more information about managing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html}{Amazon Redshift Clusters}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_cluster(
  ClusterIdentifier = "string",
  SkipFinalClusterSnapshot = TRUE|FALSE,
  FinalClusterSnapshotIdentifier = "string",
  FinalClusterSnapshotRetentionPeriod = 123
)
}
}

\keyword{internal}
