% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_event_subscriptions}
\alias{rds_describe_event_subscriptions}
\title{Lists all the subscription descriptions for a customer account}
\usage{
rds_describe_event_subscriptions(SubscriptionName, Filters, MaxRecords,
  Marker)
}
\arguments{
\item{SubscriptionName}{The name of the RDS event notification subscription you want to
describe.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
DescribeOrderableDBInstanceOptions request. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords} .}
}
\value{
A list with the following syntax:\preformatted{list(
  Marker = "string",
  EventSubscriptionsList = list(
    list(
      CustomerAwsId = "string",
      CustSubscriptionId = "string",
      SnsTopicArn = "string",
      Status = "string",
      SubscriptionCreationTime = "string",
      SourceType = "string",
      SourceIdsList = list(
        "string"
      ),
      EventCategoriesList = list(
        "string"
      ),
      Enabled = TRUE|FALSE,
      EventSubscriptionArn = "string"
    )
  )
)
}
}
\description{
Lists all the subscription descriptions for a customer account. The
description for a subscription includes \code{SubscriptionName},
\code{SNSTopicARN}, \code{CustomerID}, \code{SourceType}, \code{SourceID}, \code{CreationTime},
and \code{Status}.

If you specify a \code{SubscriptionName}, lists the description for that
subscription.
}
\section{Request syntax}{
\preformatted{svc$describe_event_subscriptions(
  SubscriptionName = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
