# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include redshift_service.R
NULL

#' Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to
#' the configuration (term, payment type, or number of nodes) and no
#' additional costs
#'
#' @description
#' Exchanges a DC1 Reserved Node for a DC2 Reserved Node with no changes to
#' the configuration (term, payment type, or number of nodes) and no
#' additional costs.
#'
#' @usage
#' redshift_accept_reserved_node_exchange(ReservedNodeId,
#'   TargetReservedNodeOfferingId)
#'
#' @param ReservedNodeId &#91;required&#93; A string representing the node identifier of the DC1 Reserved Node to be
#' exchanged.
#' @param TargetReservedNodeOfferingId &#91;required&#93; The unique identifier of the DC2 Reserved Node offering to be used for
#' the exchange. You can obtain the value for the parameter by calling
#' GetReservedNodeExchangeOfferings
#'
#' @section Request syntax:
#' ```
#' svc$accept_reserved_node_exchange(
#'   ReservedNodeId = "string",
#'   TargetReservedNodeOfferingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_accept_reserved_node_exchange
redshift_accept_reserved_node_exchange <- function(ReservedNodeId, TargetReservedNodeOfferingId) {
  op <- new_operation(
    name = "AcceptReservedNodeExchange",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$accept_reserved_node_exchange_input(ReservedNodeId = ReservedNodeId, TargetReservedNodeOfferingId = TargetReservedNodeOfferingId)
  output <- .redshift$accept_reserved_node_exchange_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$accept_reserved_node_exchange <- redshift_accept_reserved_node_exchange

#' Adds an inbound (ingress) rule to an Amazon Redshift security group
#'
#' @description
#' Adds an inbound (ingress) rule to an Amazon Redshift security group.
#' Depending on whether the application accessing your cluster is running
#' on the Internet or an Amazon EC2 instance, you can authorize inbound
#' access to either a Classless Interdomain Routing (CIDR)/Internet
#' Protocol (IP) range or to an Amazon EC2 security group. You can add as
#' many as 20 ingress rules to an Amazon Redshift security group.
#' 
#' If you authorize access to an Amazon EC2 security group, specify
#' *EC2SecurityGroupName* and *EC2SecurityGroupOwnerId*. The Amazon EC2
#' security group and Amazon Redshift cluster must be in the same AWS
#' Region.
#' 
#' If you authorize access to a CIDR/IP address range, specify *CIDRIP*.
#' For an overview of CIDR blocks, see the Wikipedia article on [Classless
#' Inter-Domain
#' Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#' 
#' You must also associate the security group with a cluster so that
#' clients running on these IP addresses or the EC2 instance are authorized
#' to connect to the cluster. For information about managing security
#' groups, go to [Working with Security
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_authorize_cluster_security_group_ingress(
#'   ClusterSecurityGroupName, CIDRIP, EC2SecurityGroupName,
#'   EC2SecurityGroupOwnerId)
#'
#' @param ClusterSecurityGroupName &#91;required&#93; The name of the security group to which the ingress rule is added.
#' @param CIDRIP The IP range to be added the Amazon Redshift security group.
#' @param EC2SecurityGroupName The EC2 security group to be added the Amazon Redshift security group.
#' @param EC2SecurityGroupOwnerId The AWS account number of the owner of the security group specified by
#' the *EC2SecurityGroupName* parameter. The AWS Access Key ID is not an
#' acceptable value.
#' 
#' Example: `111122223333`
#'
#' @section Request syntax:
#' ```
#' svc$authorize_cluster_security_group_ingress(
#'   ClusterSecurityGroupName = "string",
#'   CIDRIP = "string",
#'   EC2SecurityGroupName = "string",
#'   EC2SecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_authorize_cluster_security_group_ingress
redshift_authorize_cluster_security_group_ingress <- function(ClusterSecurityGroupName, CIDRIP = NULL, EC2SecurityGroupName = NULL, EC2SecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "AuthorizeClusterSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$authorize_cluster_security_group_ingress_input(ClusterSecurityGroupName = ClusterSecurityGroupName, CIDRIP = CIDRIP, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .redshift$authorize_cluster_security_group_ingress_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$authorize_cluster_security_group_ingress <- redshift_authorize_cluster_security_group_ingress

#' Authorizes the specified AWS customer account to restore the specified
#' snapshot
#'
#' @description
#' Authorizes the specified AWS customer account to restore the specified
#' snapshot.
#' 
#' For more information about working with snapshots, go to [Amazon
#' Redshift
#' Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_authorize_snapshot_access(SnapshotIdentifier,
#'   SnapshotClusterIdentifier, AccountWithRestoreAccess)
#'
#' @param SnapshotIdentifier &#91;required&#93; The identifier of the snapshot the account is authorized to restore.
#' @param SnapshotClusterIdentifier The identifier of the cluster the snapshot was created from. This
#' parameter is required if your IAM user has a policy containing a
#' snapshot resource element that specifies anything other than * for the
#' cluster name.
#' @param AccountWithRestoreAccess &#91;required&#93; The identifier of the AWS customer account authorized to restore the
#' specified snapshot.
#' 
#' To share a snapshot with AWS support, specify amazon-redshift-support.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_snapshot_access(
#'   SnapshotIdentifier = "string",
#'   SnapshotClusterIdentifier = "string",
#'   AccountWithRestoreAccess = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_authorize_snapshot_access
redshift_authorize_snapshot_access <- function(SnapshotIdentifier, SnapshotClusterIdentifier = NULL, AccountWithRestoreAccess) {
  op <- new_operation(
    name = "AuthorizeSnapshotAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$authorize_snapshot_access_input(SnapshotIdentifier = SnapshotIdentifier, SnapshotClusterIdentifier = SnapshotClusterIdentifier, AccountWithRestoreAccess = AccountWithRestoreAccess)
  output <- .redshift$authorize_snapshot_access_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$authorize_snapshot_access <- redshift_authorize_snapshot_access

#' Deletes a set of cluster snapshots
#'
#' @description
#' Deletes a set of cluster snapshots.
#'
#' @usage
#' redshift_batch_delete_cluster_snapshots(Identifiers)
#'
#' @param Identifiers &#91;required&#93; A list of identifiers for the snapshots that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_cluster_snapshots(
#'   Identifiers = list(
#'     list(
#'       SnapshotIdentifier = "string",
#'       SnapshotClusterIdentifier = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_batch_delete_cluster_snapshots
redshift_batch_delete_cluster_snapshots <- function(Identifiers) {
  op <- new_operation(
    name = "BatchDeleteClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$batch_delete_cluster_snapshots_input(Identifiers = Identifiers)
  output <- .redshift$batch_delete_cluster_snapshots_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$batch_delete_cluster_snapshots <- redshift_batch_delete_cluster_snapshots

#' Modifies the settings for a set of cluster snapshots
#'
#' @description
#' Modifies the settings for a set of cluster snapshots.
#'
#' @usage
#' redshift_batch_modify_cluster_snapshots(SnapshotIdentifierList,
#'   ManualSnapshotRetentionPeriod, Force)
#'
#' @param SnapshotIdentifierList &#91;required&#93; A list of snapshot identifiers you want to modify.
#' @param ManualSnapshotRetentionPeriod The number of days that a manual snapshot is retained. If you specify
#' the value -1, the manual snapshot is retained indefinitely.
#' 
#' The number must be either -1 or an integer between 1 and 3,653.
#' 
#' If you decrease the manual snapshot retention period from its current
#' value, existing manual snapshots that fall outside of the new retention
#' period will return an error. If you want to suppress the errors and
#' delete the snapshots, use the force option.
#' @param Force A boolean value indicating whether to override an exception if the
#' retention period has passed.
#'
#' @section Request syntax:
#' ```
#' svc$batch_modify_cluster_snapshots(
#'   SnapshotIdentifierList = list(
#'     "string"
#'   ),
#'   ManualSnapshotRetentionPeriod = 123,
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_batch_modify_cluster_snapshots
redshift_batch_modify_cluster_snapshots <- function(SnapshotIdentifierList, ManualSnapshotRetentionPeriod = NULL, Force = NULL) {
  op <- new_operation(
    name = "BatchModifyClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$batch_modify_cluster_snapshots_input(SnapshotIdentifierList = SnapshotIdentifierList, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod, Force = Force)
  output <- .redshift$batch_modify_cluster_snapshots_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$batch_modify_cluster_snapshots <- redshift_batch_modify_cluster_snapshots

#' Cancels a resize operation for a cluster
#'
#' @description
#' Cancels a resize operation for a cluster.
#'
#' @usage
#' redshift_cancel_resize(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier for the cluster that you want to cancel a resize
#' operation for.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_resize(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_cancel_resize
redshift_cancel_resize <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "CancelResize",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$cancel_resize_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$cancel_resize_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$cancel_resize <- redshift_cancel_resize

#' Copies the specified automated cluster snapshot to a new manual cluster
#' snapshot
#'
#' @description
#' Copies the specified automated cluster snapshot to a new manual cluster
#' snapshot. The source must be an automated snapshot and it must be in the
#' available state.
#' 
#' When you delete a cluster, Amazon Redshift deletes any automated
#' snapshots of the cluster. Also, when the retention period of the
#' snapshot expires, Amazon Redshift automatically deletes it. If you want
#' to keep an automated snapshot for a longer period, you can make a manual
#' copy of the snapshot. Manual snapshots are retained until you delete
#' them.
#' 
#' For more information about working with snapshots, go to [Amazon
#' Redshift
#' Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_copy_cluster_snapshot(SourceSnapshotIdentifier,
#'   SourceSnapshotClusterIdentifier, TargetSnapshotIdentifier,
#'   ManualSnapshotRetentionPeriod)
#'
#' @param SourceSnapshotIdentifier &#91;required&#93; The identifier for the source snapshot.
#' 
#' Constraints:
#' 
#' -   Must be the identifier for a valid automated snapshot whose state is
#'     `available`.
#' @param SourceSnapshotClusterIdentifier The identifier of the cluster the source snapshot was created from. This
#' parameter is required if your IAM user has a policy containing a
#' snapshot resource element that specifies anything other than * for the
#' cluster name.
#' 
#' Constraints:
#' 
#' -   Must be the identifier for a valid cluster.
#' @param TargetSnapshotIdentifier &#91;required&#93; The identifier given to the new manual snapshot.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank.
#' 
#' -   Must contain from 1 to 255 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Must be unique for the AWS account that is making the request.
#' @param ManualSnapshotRetentionPeriod The number of days that a manual snapshot is retained. If the value is
#' -1, the manual snapshot is retained indefinitely.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' 
#' The default value is -1.
#'
#' @section Request syntax:
#' ```
#' svc$copy_cluster_snapshot(
#'   SourceSnapshotIdentifier = "string",
#'   SourceSnapshotClusterIdentifier = "string",
#'   TargetSnapshotIdentifier = "string",
#'   ManualSnapshotRetentionPeriod = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_copy_cluster_snapshot
redshift_copy_cluster_snapshot <- function(SourceSnapshotIdentifier, SourceSnapshotClusterIdentifier = NULL, TargetSnapshotIdentifier, ManualSnapshotRetentionPeriod = NULL) {
  op <- new_operation(
    name = "CopyClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$copy_cluster_snapshot_input(SourceSnapshotIdentifier = SourceSnapshotIdentifier, SourceSnapshotClusterIdentifier = SourceSnapshotClusterIdentifier, TargetSnapshotIdentifier = TargetSnapshotIdentifier, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod)
  output <- .redshift$copy_cluster_snapshot_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$copy_cluster_snapshot <- redshift_copy_cluster_snapshot

#' Creates a new cluster with the specified parameters
#'
#' @description
#' Creates a new cluster with the specified parameters.
#' 
#' To create a cluster in Virtual Private Cloud (VPC), you must provide a
#' cluster subnet group name. The cluster subnet group identifies the
#' subnets of your VPC that Amazon Redshift uses when creating the cluster.
#' For more information about managing clusters, go to [Amazon Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_create_cluster(DBName, ClusterIdentifier, ClusterType,
#'   NodeType, MasterUsername, MasterUserPassword, ClusterSecurityGroups,
#'   VpcSecurityGroupIds, ClusterSubnetGroupName, AvailabilityZone,
#'   PreferredMaintenanceWindow, ClusterParameterGroupName,
#'   AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod, Port,
#'   ClusterVersion, AllowVersionUpgrade, NumberOfNodes, PubliclyAccessible,
#'   Encrypted, HsmClientCertificateIdentifier, HsmConfigurationIdentifier,
#'   ElasticIp, Tags, KmsKeyId, EnhancedVpcRouting, AdditionalInfo, IamRoles,
#'   MaintenanceTrackName, SnapshotScheduleIdentifier,
#'   AvailabilityZoneRelocation)
#'
#' @param DBName The name of the first database to be created when the cluster is
#' created.
#' 
#' To create additional databases after the cluster is created, connect to
#' the cluster with a SQL client and use SQL commands to create a database.
#' For more information, go to [Create a
#' Database](https://docs.aws.amazon.com/redshift/latest/dg/t_creating_database.html)
#' in the Amazon Redshift Database Developer Guide.
#' 
#' Default: `dev`
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 alphanumeric characters.
#' 
#' -   Must contain only lowercase letters.
#' 
#' -   Cannot be a word that is reserved by the service. A list of reserved
#'     words can be found in [Reserved
#'     Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
#'     in the Amazon Redshift Database Developer Guide.
#' @param ClusterIdentifier &#91;required&#93; A unique identifier for the cluster. You use this identifier to refer to
#' the cluster for any subsequent cluster operations such as deleting or
#' modifying. The identifier also appears in the Amazon Redshift console.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   Alphabetic characters must be lowercase.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Must be unique for all clusters within an AWS account.
#' 
#' Example: `myexamplecluster`
#' @param ClusterType The type of the cluster. When cluster type is specified as
#' 
#' -   `single-node`, the **NumberOfNodes** parameter is not required.
#' 
#' -   `multi-node`, the **NumberOfNodes** parameter is required.
#' 
#' Valid Values: `multi-node` | `single-node`
#' 
#' Default: `multi-node`
#' @param NodeType &#91;required&#93; The node type to be provisioned for the cluster. For information about
#' node types, go to [Working with
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' Valid Values: `ds2.xlarge` | `ds2.8xlarge` | `dc1.large` | `dc1.8xlarge`
#' | `dc2.large` | `dc2.8xlarge` | `ra3.xlplus` | `ra3.4xlarge` |
#' `ra3.16xlarge`
#' @param MasterUsername &#91;required&#93; The user name associated with the master user account for the cluster
#' that is being created.
#' 
#' Constraints:
#' 
#' -   Must be 1 - 128 alphanumeric characters. The user name can't be
#'     `PUBLIC`.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot be a reserved word. A list of reserved words can be found in
#'     [Reserved
#'     Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
#'     in the Amazon Redshift Database Developer Guide.
#' @param MasterUserPassword &#91;required&#93; The password associated with the master user account for the cluster
#' that is being created.
#' 
#' Constraints:
#' 
#' -   Must be between 8 and 64 characters in length.
#' 
#' -   Must contain at least one uppercase letter.
#' 
#' -   Must contain at least one lowercase letter.
#' 
#' -   Must contain one number.
#' 
#' -   Can be any printable ASCII character (ASCII code 33 to 126) except '
#'     (single quote), " (double quote), \\, /, @@, or space.
#' @param ClusterSecurityGroups A list of security groups to be associated with this cluster.
#' 
#' Default: The default cluster security group for Amazon Redshift.
#' @param VpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated
#' with the cluster.
#' 
#' Default: The default VPC security group is associated with the cluster.
#' @param ClusterSubnetGroupName The name of a cluster subnet group to be associated with this cluster.
#' 
#' If this parameter is not provided the resulting cluster will be deployed
#' outside virtual private cloud (VPC).
#' @param AvailabilityZone The EC2 Availability Zone (AZ) in which you want Amazon Redshift to
#' provision the cluster. For example, if you have several EC2 instances
#' running in a specific Availability Zone, then you might want the cluster
#' to be provisioned in the same zone in order to decrease network latency.
#' 
#' Default: A random, system-chosen Availability Zone in the region that is
#' specified by the endpoint.
#' 
#' Example: `us-east-2d`
#' 
#' Constraint: The specified Availability Zone must be in the same region
#' as the current endpoint.
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster
#' maintenance can occur.
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' Default: A 30-minute window selected at random from an 8-hour block of
#' time per region, occurring on a random day of the week. For more
#' information about the time blocks for each region, see [Maintenance
#' Windows](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
#' in Amazon Redshift Cluster Management Guide.
#' 
#' Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param ClusterParameterGroupName The name of the parameter group to be associated with this cluster.
#' 
#' Default: The default Amazon Redshift cluster parameter group. For
#' information about the default parameter group, go to [Working with
#' Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param AutomatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. If the value
#' is 0, automated snapshots are disabled. Even if automated snapshots are
#' disabled, you can still create manual snapshots when you want with
#' CreateClusterSnapshot.
#' 
#' Default: `1`
#' 
#' Constraints: Must be a value from 0 to 35.
#' @param ManualSnapshotRetentionPeriod The default number of days to retain a manual snapshot. If the value is
#' -1, the snapshot is retained indefinitely. This setting doesn't change
#' the retention period of existing snapshots.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' @param Port The port number on which the cluster accepts incoming connections.
#' 
#' The cluster is accessible only via the JDBC and ODBC connection strings.
#' Part of the connection string requires the port on which the cluster
#' will listen for incoming connections.
#' 
#' Default: `5439`
#' 
#' Valid Values: `1150-65535`
#' @param ClusterVersion The version of the Amazon Redshift engine software that you want to
#' deploy on the cluster.
#' 
#' The version selected runs on all the nodes in the cluster.
#' 
#' Constraints: Only version 1.0 is currently available.
#' 
#' Example: `1.0`
#' @param AllowVersionUpgrade If `true`, major version upgrades can be applied during the maintenance
#' window to the Amazon Redshift engine that is running on the cluster.
#' 
#' When a new major version of the Amazon Redshift engine is released, you
#' can request that the service automatically apply upgrades during the
#' maintenance window to the Amazon Redshift engine that is running on your
#' cluster.
#' 
#' Default: `true`
#' @param NumberOfNodes The number of compute nodes in the cluster. This parameter is required
#' when the **ClusterType** parameter is specified as `multi-node`.
#' 
#' For information about determining how many nodes you need, go to
#' [Working with
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#how-many-nodes)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' If you don't specify this parameter, you get a single-node cluster. When
#' requesting a multi-node cluster, you must specify the number of nodes
#' that you want in the cluster.
#' 
#' Default: `1`
#' 
#' Constraints: Value must be at least 1 and no more than 100.
#' @param PubliclyAccessible If `true`, the cluster can be accessed from a public network.
#' @param Encrypted If `true`, the data in the cluster is encrypted at rest.
#' 
#' Default: false
#' @param HsmClientCertificateIdentifier Specifies the name of the HSM client certificate the Amazon Redshift
#' cluster uses to retrieve the data encryption keys stored in an HSM.
#' @param HsmConfigurationIdentifier Specifies the name of the HSM configuration that contains the
#' information the Amazon Redshift cluster can use to retrieve and store
#' keys in an HSM.
#' @param ElasticIp The Elastic IP (EIP) address for the cluster.
#' 
#' Constraints: The cluster must be provisioned in EC2-VPC and
#' publicly-accessible through an Internet gateway. For more information
#' about provisioning clusters in EC2-VPC, go to [Supported Platforms to
#' Launch Your
#' Cluster](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
#' in the Amazon Redshift Cluster Management Guide.
#' @param Tags A list of tag instances.
#' @param KmsKeyId The AWS Key Management Service (KMS) key ID of the encryption key that
#' you want to use to encrypt data in the cluster.
#' @param EnhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC
#' routing enabled. To create a cluster that uses enhanced VPC routing, the
#' cluster must be in a VPC. For more information, see [Enhanced VPC
#' Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
#' in the Amazon Redshift Cluster Management Guide.
#' 
#' If this option is `true`, enhanced VPC routing is enabled.
#' 
#' Default: false
#' @param AdditionalInfo Reserved.
#' @param IamRoles A list of AWS Identity and Access Management (IAM) roles that can be
#' used by the cluster to access other AWS services. You must supply the
#' IAM roles in their Amazon Resource Name (ARN) format. You can supply up
#' to 10 IAM roles in a single request.
#' 
#' A cluster can have up to 10 IAM roles associated with it at any time.
#' @param MaintenanceTrackName An optional parameter for the name of the maintenance track for the
#' cluster. If you don't provide a maintenance track name, the cluster is
#' assigned to the `current` track.
#' @param SnapshotScheduleIdentifier A unique identifier for the snapshot schedule.
#' @param AvailabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between
#' Availability Zones after the cluster is created.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster(
#'   DBName = "string",
#'   ClusterIdentifier = "string",
#'   ClusterType = "string",
#'   NodeType = "string",
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   ClusterSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   ClusterSubnetGroupName = "string",
#'   AvailabilityZone = "string",
#'   PreferredMaintenanceWindow = "string",
#'   ClusterParameterGroupName = "string",
#'   AutomatedSnapshotRetentionPeriod = 123,
#'   ManualSnapshotRetentionPeriod = 123,
#'   Port = 123,
#'   ClusterVersion = "string",
#'   AllowVersionUpgrade = TRUE|FALSE,
#'   NumberOfNodes = 123,
#'   PubliclyAccessible = TRUE|FALSE,
#'   Encrypted = TRUE|FALSE,
#'   HsmClientCertificateIdentifier = "string",
#'   HsmConfigurationIdentifier = "string",
#'   ElasticIp = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnhancedVpcRouting = TRUE|FALSE,
#'   AdditionalInfo = "string",
#'   IamRoles = list(
#'     "string"
#'   ),
#'   MaintenanceTrackName = "string",
#'   SnapshotScheduleIdentifier = "string",
#'   AvailabilityZoneRelocation = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_cluster
redshift_create_cluster <- function(DBName = NULL, ClusterIdentifier, ClusterType = NULL, NodeType, MasterUsername, MasterUserPassword, ClusterSecurityGroups = NULL, VpcSecurityGroupIds = NULL, ClusterSubnetGroupName = NULL, AvailabilityZone = NULL, PreferredMaintenanceWindow = NULL, ClusterParameterGroupName = NULL, AutomatedSnapshotRetentionPeriod = NULL, ManualSnapshotRetentionPeriod = NULL, Port = NULL, ClusterVersion = NULL, AllowVersionUpgrade = NULL, NumberOfNodes = NULL, PubliclyAccessible = NULL, Encrypted = NULL, HsmClientCertificateIdentifier = NULL, HsmConfigurationIdentifier = NULL, ElasticIp = NULL, Tags = NULL, KmsKeyId = NULL, EnhancedVpcRouting = NULL, AdditionalInfo = NULL, IamRoles = NULL, MaintenanceTrackName = NULL, SnapshotScheduleIdentifier = NULL, AvailabilityZoneRelocation = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_cluster_input(DBName = DBName, ClusterIdentifier = ClusterIdentifier, ClusterType = ClusterType, NodeType = NodeType, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, ClusterSecurityGroups = ClusterSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, ClusterSubnetGroupName = ClusterSubnetGroupName, AvailabilityZone = AvailabilityZone, PreferredMaintenanceWindow = PreferredMaintenanceWindow, ClusterParameterGroupName = ClusterParameterGroupName, AutomatedSnapshotRetentionPeriod = AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod, Port = Port, ClusterVersion = ClusterVersion, AllowVersionUpgrade = AllowVersionUpgrade, NumberOfNodes = NumberOfNodes, PubliclyAccessible = PubliclyAccessible, Encrypted = Encrypted, HsmClientCertificateIdentifier = HsmClientCertificateIdentifier, HsmConfigurationIdentifier = HsmConfigurationIdentifier, ElasticIp = ElasticIp, Tags = Tags, KmsKeyId = KmsKeyId, EnhancedVpcRouting = EnhancedVpcRouting, AdditionalInfo = AdditionalInfo, IamRoles = IamRoles, MaintenanceTrackName = MaintenanceTrackName, SnapshotScheduleIdentifier = SnapshotScheduleIdentifier, AvailabilityZoneRelocation = AvailabilityZoneRelocation)
  output <- .redshift$create_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_cluster <- redshift_create_cluster

#' Creates an Amazon Redshift parameter group
#'
#' @description
#' Creates an Amazon Redshift parameter group.
#' 
#' Creating parameter groups is independent of creating clusters. You can
#' associate a cluster with a parameter group when you create the cluster.
#' You can also associate an existing cluster with a parameter group after
#' the cluster is created by using ModifyCluster.
#' 
#' Parameters in the parameter group define specific behavior that applies
#' to the databases you create on the cluster. For more information about
#' parameters and parameter groups, go to [Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_create_cluster_parameter_group(ParameterGroupName,
#'   ParameterGroupFamily, Description, Tags)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters or hyphens
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Must be unique withing your AWS account.
#' 
#' This value is stored as a lower-case string.
#' @param ParameterGroupFamily &#91;required&#93; The Amazon Redshift engine version to which the cluster parameter group
#' applies. The cluster engine version determines the set of parameters.
#' 
#' To get a list of valid parameter group family names, you can call
#' DescribeClusterParameterGroups. By default, Amazon Redshift returns a
#' list of all the parameter groups that are owned by your AWS account,
#' including the default parameter groups for each Amazon Redshift engine
#' version. The parameter group family names associated with the default
#' parameter groups provide you the valid values. For example, a valid
#' family name is "redshift-1.0".
#' @param Description &#91;required&#93; A description of the parameter group.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster_parameter_group(
#'   ParameterGroupName = "string",
#'   ParameterGroupFamily = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_cluster_parameter_group
redshift_create_cluster_parameter_group <- function(ParameterGroupName, ParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_cluster_parameter_group_input(ParameterGroupName = ParameterGroupName, ParameterGroupFamily = ParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .redshift$create_cluster_parameter_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_cluster_parameter_group <- redshift_create_cluster_parameter_group

#' Creates a new Amazon Redshift security group
#'
#' @description
#' Creates a new Amazon Redshift security group. You use security groups to
#' control access to non-VPC clusters.
#' 
#' For information about managing security groups, go to [Amazon Redshift
#' Cluster Security
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_create_cluster_security_group(ClusterSecurityGroupName,
#'   Description, Tags)
#'
#' @param ClusterSecurityGroupName &#91;required&#93; The name for the security group. Amazon Redshift stores the value as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain no more than 255 alphanumeric characters or hyphens.
#' 
#' -   Must not be "Default".
#' 
#' -   Must be unique for all security groups that are created by your AWS
#'     account.
#' 
#' Example: `examplesecuritygroup`
#' @param Description &#91;required&#93; A description for the security group.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster_security_group(
#'   ClusterSecurityGroupName = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_cluster_security_group
redshift_create_cluster_security_group <- function(ClusterSecurityGroupName, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateClusterSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_cluster_security_group_input(ClusterSecurityGroupName = ClusterSecurityGroupName, Description = Description, Tags = Tags)
  output <- .redshift$create_cluster_security_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_cluster_security_group <- redshift_create_cluster_security_group

#' Creates a manual snapshot of the specified cluster
#'
#' @description
#' Creates a manual snapshot of the specified cluster. The cluster must be
#' in the `available` state.
#' 
#' For more information about working with snapshots, go to [Amazon
#' Redshift
#' Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_create_cluster_snapshot(SnapshotIdentifier, ClusterIdentifier,
#'   ManualSnapshotRetentionPeriod, Tags)
#'
#' @param SnapshotIdentifier &#91;required&#93; A unique identifier for the snapshot that you are requesting. This
#' identifier must be unique for all snapshots within the AWS account.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 alphanumeric characters or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param ClusterIdentifier &#91;required&#93; The cluster identifier for which you want a snapshot.
#' @param ManualSnapshotRetentionPeriod The number of days that a manual snapshot is retained. If the value is
#' -1, the manual snapshot is retained indefinitely.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' 
#' The default value is -1.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster_snapshot(
#'   SnapshotIdentifier = "string",
#'   ClusterIdentifier = "string",
#'   ManualSnapshotRetentionPeriod = 123,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_cluster_snapshot
redshift_create_cluster_snapshot <- function(SnapshotIdentifier, ClusterIdentifier, ManualSnapshotRetentionPeriod = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_cluster_snapshot_input(SnapshotIdentifier = SnapshotIdentifier, ClusterIdentifier = ClusterIdentifier, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod, Tags = Tags)
  output <- .redshift$create_cluster_snapshot_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_cluster_snapshot <- redshift_create_cluster_snapshot

#' Creates a new Amazon Redshift subnet group
#'
#' @description
#' Creates a new Amazon Redshift subnet group. You must provide a list of
#' one or more subnets in your existing Amazon Virtual Private Cloud
#' (Amazon VPC) when creating Amazon Redshift subnet group.
#' 
#' For information about subnet groups, go to [Amazon Redshift Cluster
#' Subnet
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-cluster-subnet-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_create_cluster_subnet_group(ClusterSubnetGroupName,
#'   Description, SubnetIds, Tags)
#'
#' @param ClusterSubnetGroupName &#91;required&#93; The name for the subnet group. Amazon Redshift stores the value as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain no more than 255 alphanumeric characters or hyphens.
#' 
#' -   Must not be "Default".
#' 
#' -   Must be unique for all subnet groups that are created by your AWS
#'     account.
#' 
#' Example: `examplesubnetgroup`
#' @param Description &#91;required&#93; A description for the subnet group.
#' @param SubnetIds &#91;required&#93; An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
#' single request.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster_subnet_group(
#'   ClusterSubnetGroupName = "string",
#'   Description = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_cluster_subnet_group
redshift_create_cluster_subnet_group <- function(ClusterSubnetGroupName, Description, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateClusterSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_cluster_subnet_group_input(ClusterSubnetGroupName = ClusterSubnetGroupName, Description = Description, SubnetIds = SubnetIds, Tags = Tags)
  output <- .redshift$create_cluster_subnet_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_cluster_subnet_group <- redshift_create_cluster_subnet_group

#' Creates an Amazon Redshift event notification subscription
#'
#' @description
#' Creates an Amazon Redshift event notification subscription. This action
#' requires an ARN (Amazon Resource Name) of an Amazon SNS topic created by
#' either the Amazon Redshift console, the Amazon SNS console, or the
#' Amazon SNS API. To obtain an ARN with Amazon SNS, you must create a
#' topic in Amazon SNS and subscribe to the topic. The ARN is displayed in
#' the SNS console.
#' 
#' You can specify the source type, and lists of Amazon Redshift source
#' IDs, event categories, and event severities. Notifications will be sent
#' for all events you want that match those criteria. For example, you can
#' specify source type = cluster, source ID = my-cluster-1 and mycluster2,
#' event categories = Availability, Backup, and severity = ERROR. The
#' subscription will only send notifications for those ERROR events in the
#' Availability and Backup categories for the specified clusters.
#' 
#' If you specify both the source type and source IDs, such as source type
#' = cluster and source identifier = my-cluster-1, notifications will be
#' sent for all the cluster events for my-cluster-1. If you specify a
#' source type but do not specify a source identifier, you will receive
#' notice of the events for the objects of that type in your AWS account.
#' If you do not specify either the SourceType nor the SourceIdentifier,
#' you will be notified of events generated from all Amazon Redshift
#' sources belonging to your AWS account. You must specify a source type if
#' you specify a source ID.
#'
#' @usage
#' redshift_create_event_subscription(SubscriptionName, SnsTopicArn,
#'   SourceType, SourceIds, EventCategories, Severity, Enabled, Tags)
#'
#' @param SubscriptionName &#91;required&#93; The name of the event subscription to be created.
#' 
#' Constraints:
#' 
#' -   Cannot be null, empty, or blank.
#' 
#' -   Must contain from 1 to 255 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon SNS topic used to transmit
#' the event notifications. The ARN is created by Amazon SNS when you
#' create a topic and subscribe to it.
#' @param SourceType The type of source that will be generating the events. For example, if
#' you want to be notified of events generated by a cluster, you would set
#' this parameter to cluster. If this value is not specified, events are
#' returned for all Amazon Redshift objects in your AWS account. You must
#' specify a source type in order to specify source IDs.
#' 
#' Valid values: cluster, cluster-parameter-group, cluster-security-group,
#' cluster-snapshot, and scheduled-action.
#' @param SourceIds A list of one or more identifiers of Amazon Redshift source objects. All
#' of the objects must be of the same type as was specified in the source
#' type parameter. The event subscription will return only events generated
#' by the specified objects. If not specified, then events are returned for
#' all objects within the source type specified.
#' 
#' Example: my-cluster-1, my-cluster-2
#' 
#' Example: my-snapshot-20131010
#' @param EventCategories Specifies the Amazon Redshift event categories to be published by the
#' event notification subscription.
#' 
#' Values: configuration, management, monitoring, security
#' @param Severity Specifies the Amazon Redshift event severity to be published by the
#' event notification subscription.
#' 
#' Values: ERROR, INFO
#' @param Enabled A boolean value; set to `true` to activate the subscription, and set to
#' `false` to create the subscription but not activate it.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_event_subscription(
#'   SubscriptionName = "string",
#'   SnsTopicArn = "string",
#'   SourceType = "string",
#'   SourceIds = list(
#'     "string"
#'   ),
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Severity = "string",
#'   Enabled = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_event_subscription
redshift_create_event_subscription <- function(SubscriptionName, SnsTopicArn, SourceType = NULL, SourceIds = NULL, EventCategories = NULL, Severity = NULL, Enabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, SourceIds = SourceIds, EventCategories = EventCategories, Severity = Severity, Enabled = Enabled, Tags = Tags)
  output <- .redshift$create_event_subscription_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_event_subscription <- redshift_create_event_subscription

#' Creates an HSM client certificate that an Amazon Redshift cluster will
#' use to connect to the client's HSM in order to store and retrieve the
#' keys used to encrypt the cluster databases
#'
#' @description
#' Creates an HSM client certificate that an Amazon Redshift cluster will
#' use to connect to the client's HSM in order to store and retrieve the
#' keys used to encrypt the cluster databases.
#' 
#' The command returns a public key, which you must store in the HSM. In
#' addition to creating the HSM certificate, you must create an Amazon
#' Redshift HSM configuration that provides a cluster the information
#' needed to store and use encryption keys in the HSM. For more
#' information, go to [Hardware Security
#' Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/) in the
#' Amazon Redshift Cluster Management Guide.
#'
#' @usage
#' redshift_create_hsm_client_certificate(HsmClientCertificateIdentifier,
#'   Tags)
#'
#' @param HsmClientCertificateIdentifier &#91;required&#93; The identifier to be assigned to the new HSM client certificate that the
#' cluster will use to connect to the HSM to use the database encryption
#' keys.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_hsm_client_certificate(
#'   HsmClientCertificateIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_hsm_client_certificate
redshift_create_hsm_client_certificate <- function(HsmClientCertificateIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateHsmClientCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_hsm_client_certificate_input(HsmClientCertificateIdentifier = HsmClientCertificateIdentifier, Tags = Tags)
  output <- .redshift$create_hsm_client_certificate_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_hsm_client_certificate <- redshift_create_hsm_client_certificate

#' Creates an HSM configuration that contains the information required by
#' an Amazon Redshift cluster to store and use database encryption keys in
#' a Hardware Security Module (HSM)
#'
#' @description
#' Creates an HSM configuration that contains the information required by
#' an Amazon Redshift cluster to store and use database encryption keys in
#' a Hardware Security Module (HSM). After creating the HSM configuration,
#' you can specify it as a parameter when creating a cluster. The cluster
#' will then store its encryption keys in the HSM.
#' 
#' In addition to creating an HSM configuration, you must also create an
#' HSM client certificate. For more information, go to [Hardware Security
#' Modules](https://docs.aws.amazon.com/redshift/latest/mgmt/) in the
#' Amazon Redshift Cluster Management Guide.
#'
#' @usage
#' redshift_create_hsm_configuration(HsmConfigurationIdentifier,
#'   Description, HsmIpAddress, HsmPartitionName, HsmPartitionPassword,
#'   HsmServerPublicCertificate, Tags)
#'
#' @param HsmConfigurationIdentifier &#91;required&#93; The identifier to be assigned to the new Amazon Redshift HSM
#' configuration.
#' @param Description &#91;required&#93; A text description of the HSM configuration to be created.
#' @param HsmIpAddress &#91;required&#93; The IP address that the Amazon Redshift cluster must use to access the
#' HSM.
#' @param HsmPartitionName &#91;required&#93; The name of the partition in the HSM where the Amazon Redshift clusters
#' will store their database encryption keys.
#' @param HsmPartitionPassword &#91;required&#93; The password required to access the HSM partition.
#' @param HsmServerPublicCertificate &#91;required&#93; The HSMs public certificate file. When using Cloud HSM, the file name is
#' server.pem.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_hsm_configuration(
#'   HsmConfigurationIdentifier = "string",
#'   Description = "string",
#'   HsmIpAddress = "string",
#'   HsmPartitionName = "string",
#'   HsmPartitionPassword = "string",
#'   HsmServerPublicCertificate = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_hsm_configuration
redshift_create_hsm_configuration <- function(HsmConfigurationIdentifier, Description, HsmIpAddress, HsmPartitionName, HsmPartitionPassword, HsmServerPublicCertificate, Tags = NULL) {
  op <- new_operation(
    name = "CreateHsmConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_hsm_configuration_input(HsmConfigurationIdentifier = HsmConfigurationIdentifier, Description = Description, HsmIpAddress = HsmIpAddress, HsmPartitionName = HsmPartitionName, HsmPartitionPassword = HsmPartitionPassword, HsmServerPublicCertificate = HsmServerPublicCertificate, Tags = Tags)
  output <- .redshift$create_hsm_configuration_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_hsm_configuration <- redshift_create_hsm_configuration

#' Creates a scheduled action
#'
#' @description
#' Creates a scheduled action. A scheduled action contains a schedule and
#' an Amazon Redshift API action. For example, you can create a schedule of
#' when to run the `ResizeCluster` API operation.
#'
#' @usage
#' redshift_create_scheduled_action(ScheduledActionName, TargetAction,
#'   Schedule, IamRole, ScheduledActionDescription, StartTime, EndTime,
#'   Enable)
#'
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action. The name must be unique within an
#' account. For more information about this parameter, see ScheduledAction.
#' @param TargetAction &#91;required&#93; A JSON format string of the Amazon Redshift API operation with input
#' parameters. For more information about this parameter, see
#' ScheduledAction.
#' @param Schedule &#91;required&#93; The schedule in `at( )` or `cron( )` format. For more information about
#' this parameter, see ScheduledAction.
#' @param IamRole &#91;required&#93; The IAM role to assume to run the target action. For more information
#' about this parameter, see ScheduledAction.
#' @param ScheduledActionDescription The description of the scheduled action.
#' @param StartTime The start time in UTC of the scheduled action. Before this time, the
#' scheduled action does not trigger. For more information about this
#' parameter, see ScheduledAction.
#' @param EndTime The end time in UTC of the scheduled action. After this time, the
#' scheduled action does not trigger. For more information about this
#' parameter, see ScheduledAction.
#' @param Enable If true, the schedule is enabled. If false, the scheduled action does
#' not trigger. For more information about `state` of the scheduled action,
#' see ScheduledAction.
#'
#' @section Request syntax:
#' ```
#' svc$create_scheduled_action(
#'   ScheduledActionName = "string",
#'   TargetAction = list(
#'     ResizeCluster = list(
#'       ClusterIdentifier = "string",
#'       ClusterType = "string",
#'       NodeType = "string",
#'       NumberOfNodes = 123,
#'       Classic = TRUE|FALSE
#'     ),
#'     PauseCluster = list(
#'       ClusterIdentifier = "string"
#'     ),
#'     ResumeCluster = list(
#'       ClusterIdentifier = "string"
#'     )
#'   ),
#'   Schedule = "string",
#'   IamRole = "string",
#'   ScheduledActionDescription = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Enable = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_scheduled_action
redshift_create_scheduled_action <- function(ScheduledActionName, TargetAction, Schedule, IamRole, ScheduledActionDescription = NULL, StartTime = NULL, EndTime = NULL, Enable = NULL) {
  op <- new_operation(
    name = "CreateScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_scheduled_action_input(ScheduledActionName = ScheduledActionName, TargetAction = TargetAction, Schedule = Schedule, IamRole = IamRole, ScheduledActionDescription = ScheduledActionDescription, StartTime = StartTime, EndTime = EndTime, Enable = Enable)
  output <- .redshift$create_scheduled_action_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_scheduled_action <- redshift_create_scheduled_action

#' Creates a snapshot copy grant that permits Amazon Redshift to use a
#' customer master key (CMK) from AWS Key Management Service (AWS KMS) to
#' encrypt copied snapshots in a destination region
#'
#' @description
#' Creates a snapshot copy grant that permits Amazon Redshift to use a
#' customer master key (CMK) from AWS Key Management Service (AWS KMS) to
#' encrypt copied snapshots in a destination region.
#' 
#' For more information about managing snapshot copy grants, go to [Amazon
#' Redshift Database
#' Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_create_snapshot_copy_grant(SnapshotCopyGrantName, KmsKeyId,
#'   Tags)
#'
#' @param SnapshotCopyGrantName &#91;required&#93; The name of the snapshot copy grant. This name must be unique in the
#' region for the AWS account.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   Alphabetic characters must be lowercase.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Must be unique for all clusters within an AWS account.
#' @param KmsKeyId The unique identifier of the customer master key (CMK) to which to grant
#' Amazon Redshift permission. If no key is specified, the default key is
#' used.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot_copy_grant(
#'   SnapshotCopyGrantName = "string",
#'   KmsKeyId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_snapshot_copy_grant
redshift_create_snapshot_copy_grant <- function(SnapshotCopyGrantName, KmsKeyId = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSnapshotCopyGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_snapshot_copy_grant_input(SnapshotCopyGrantName = SnapshotCopyGrantName, KmsKeyId = KmsKeyId, Tags = Tags)
  output <- .redshift$create_snapshot_copy_grant_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_snapshot_copy_grant <- redshift_create_snapshot_copy_grant

#' Create a snapshot schedule that can be associated to a cluster and which
#' overrides the default system backup schedule
#'
#' @description
#' Create a snapshot schedule that can be associated to a cluster and which
#' overrides the default system backup schedule.
#'
#' @usage
#' redshift_create_snapshot_schedule(ScheduleDefinitions,
#'   ScheduleIdentifier, ScheduleDescription, Tags, DryRun, NextInvocations)
#'
#' @param ScheduleDefinitions The definition of the snapshot schedule. The definition is made up of
#' schedule expressions, for example "cron(30 12 *)" or "rate(12 hours)".
#' @param ScheduleIdentifier A unique identifier for a snapshot schedule. Only alphanumeric
#' characters are allowed for the identifier.
#' @param ScheduleDescription The description of the snapshot schedule.
#' @param Tags An optional set of tags you can use to search for the schedule.
#' @param DryRun 
#' @param NextInvocations 
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot_schedule(
#'   ScheduleDefinitions = list(
#'     "string"
#'   ),
#'   ScheduleIdentifier = "string",
#'   ScheduleDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NextInvocations = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_snapshot_schedule
redshift_create_snapshot_schedule <- function(ScheduleDefinitions = NULL, ScheduleIdentifier = NULL, ScheduleDescription = NULL, Tags = NULL, DryRun = NULL, NextInvocations = NULL) {
  op <- new_operation(
    name = "CreateSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_snapshot_schedule_input(ScheduleDefinitions = ScheduleDefinitions, ScheduleIdentifier = ScheduleIdentifier, ScheduleDescription = ScheduleDescription, Tags = Tags, DryRun = DryRun, NextInvocations = NextInvocations)
  output <- .redshift$create_snapshot_schedule_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_snapshot_schedule <- redshift_create_snapshot_schedule

#' Adds tags to a cluster
#'
#' @description
#' Adds tags to a cluster.
#' 
#' A resource can have up to 50 tags. If you try to create more than 50
#' tags for a resource, you will receive an error and the attempt will
#' fail.
#' 
#' If you specify a key that already exists for the resource, the value for
#' that key will be updated with the new value.
#'
#' @usage
#' redshift_create_tags(ResourceName, Tags)
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) to which you want to add the tag or tags.
#' For example, `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
#' @param Tags &#91;required&#93; One or more name/value pairs to add as tags to the specified resource.
#' Each tag name is passed in with the parameter `Key` and the
#' corresponding value is passed in with the parameter `Value`. The `Key`
#' and `Value` parameters are separated by a comma (,). Separate multiple
#' tags with a space. For example,
#' `--tags "Key"="owner","Value"="admin" "Key"="environment","Value"="test" "Key"="version","Value"="1.0"`.
#'
#' @section Request syntax:
#' ```
#' svc$create_tags(
#'   ResourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_tags
redshift_create_tags <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_tags_input(ResourceName = ResourceName, Tags = Tags)
  output <- .redshift$create_tags_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_tags <- redshift_create_tags

#' Creates a usage limit for a specified Amazon Redshift feature on a
#' cluster
#'
#' @description
#' Creates a usage limit for a specified Amazon Redshift feature on a
#' cluster. The usage limit is identified by the returned usage limit
#' identifier.
#'
#' @usage
#' redshift_create_usage_limit(ClusterIdentifier, FeatureType, LimitType,
#'   Amount, Period, BreachAction, Tags)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster that you want to limit usage.
#' @param FeatureType &#91;required&#93; The Amazon Redshift feature that you want to limit.
#' @param LimitType &#91;required&#93; The type of limit. Depending on the feature type, this can be based on a
#' time duration or data size. If `FeatureType` is `spectrum`, then
#' `LimitType` must be `data-scanned`. If `FeatureType` is
#' `concurrency-scaling`, then `LimitType` must be `time`.
#' @param Amount &#91;required&#93; The limit amount. If time-based, this amount is in minutes. If
#' data-based, this amount is in terabytes (TB). The value must be a
#' positive number.
#' @param Period The time period that the amount applies to. A `weekly` period begins on
#' Sunday. The default is `monthly`.
#' @param BreachAction The action that Amazon Redshift takes when the limit is reached. The
#' default is log. For more information about this parameter, see
#' UsageLimit.
#' @param Tags A list of tag instances.
#'
#' @section Request syntax:
#' ```
#' svc$create_usage_limit(
#'   ClusterIdentifier = "string",
#'   FeatureType = "spectrum"|"concurrency-scaling",
#'   LimitType = "time"|"data-scanned",
#'   Amount = 123,
#'   Period = "daily"|"weekly"|"monthly",
#'   BreachAction = "log"|"emit-metric"|"disable",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_create_usage_limit
redshift_create_usage_limit <- function(ClusterIdentifier, FeatureType, LimitType, Amount, Period = NULL, BreachAction = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$create_usage_limit_input(ClusterIdentifier = ClusterIdentifier, FeatureType = FeatureType, LimitType = LimitType, Amount = Amount, Period = Period, BreachAction = BreachAction, Tags = Tags)
  output <- .redshift$create_usage_limit_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$create_usage_limit <- redshift_create_usage_limit

#' Deletes a previously provisioned cluster without its final snapshot
#' being created
#'
#' @description
#' Deletes a previously provisioned cluster without its final snapshot
#' being created. A successful response from the web service indicates that
#' the request was received correctly. Use DescribeClusters to monitor the
#' status of the deletion. The delete operation cannot be canceled or
#' reverted once submitted. For more information about managing clusters,
#' go to [Amazon Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' If you want to shut down the cluster and retain it for future use, set
#' *SkipFinalClusterSnapshot* to `false` and specify a name for
#' *FinalClusterSnapshotIdentifier*. You can later restore this snapshot to
#' resume using the cluster. If a final cluster snapshot is requested, the
#' status of the cluster will be "final-snapshot" while the snapshot is
#' being taken, then it's "deleting" once Amazon Redshift begins deleting
#' the cluster.
#' 
#' For more information about managing clusters, go to [Amazon Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_delete_cluster(ClusterIdentifier, SkipFinalClusterSnapshot,
#'   FinalClusterSnapshotIdentifier, FinalClusterSnapshotRetentionPeriod)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster to be deleted.
#' 
#' Constraints:
#' 
#' -   Must contain lowercase characters.
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param SkipFinalClusterSnapshot Determines whether a final snapshot of the cluster is created before
#' Amazon Redshift deletes the cluster. If `true`, a final cluster snapshot
#' is not created. If `false`, a final cluster snapshot is created before
#' the cluster is deleted.
#' 
#' The *FinalClusterSnapshotIdentifier* parameter must be specified if
#' *SkipFinalClusterSnapshot* is `false`.
#' 
#' Default: `false`
#' @param FinalClusterSnapshotIdentifier The identifier of the final snapshot that is to be created immediately
#' before deleting the cluster. If this parameter is provided,
#' *SkipFinalClusterSnapshot* must be `false`.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param FinalClusterSnapshotRetentionPeriod The number of days that a manual snapshot is retained. If the value is
#' -1, the manual snapshot is retained indefinitely.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' 
#' The default value is -1.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster(
#'   ClusterIdentifier = "string",
#'   SkipFinalClusterSnapshot = TRUE|FALSE,
#'   FinalClusterSnapshotIdentifier = "string",
#'   FinalClusterSnapshotRetentionPeriod = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_cluster
redshift_delete_cluster <- function(ClusterIdentifier, SkipFinalClusterSnapshot = NULL, FinalClusterSnapshotIdentifier = NULL, FinalClusterSnapshotRetentionPeriod = NULL) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_cluster_input(ClusterIdentifier = ClusterIdentifier, SkipFinalClusterSnapshot = SkipFinalClusterSnapshot, FinalClusterSnapshotIdentifier = FinalClusterSnapshotIdentifier, FinalClusterSnapshotRetentionPeriod = FinalClusterSnapshotRetentionPeriod)
  output <- .redshift$delete_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_cluster <- redshift_delete_cluster

#' Deletes a specified Amazon Redshift parameter group
#'
#' @description
#' Deletes a specified Amazon Redshift parameter group.
#' 
#' You cannot delete a parameter group if it is associated with a cluster.
#'
#' @usage
#' redshift_delete_cluster_parameter_group(ParameterGroupName)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to be deleted.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing cluster parameter group.
#' 
#' -   Cannot delete a default cluster parameter group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster_parameter_group(
#'   ParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_cluster_parameter_group
redshift_delete_cluster_parameter_group <- function(ParameterGroupName) {
  op <- new_operation(
    name = "DeleteClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_cluster_parameter_group_input(ParameterGroupName = ParameterGroupName)
  output <- .redshift$delete_cluster_parameter_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_cluster_parameter_group <- redshift_delete_cluster_parameter_group

#' Deletes an Amazon Redshift security group
#'
#' @description
#' Deletes an Amazon Redshift security group.
#' 
#' You cannot delete a security group that is associated with any clusters.
#' You cannot delete the default security group.
#' 
#' For information about managing security groups, go to [Amazon Redshift
#' Cluster Security
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_delete_cluster_security_group(ClusterSecurityGroupName)
#'
#' @param ClusterSecurityGroupName &#91;required&#93; The name of the cluster security group to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster_security_group(
#'   ClusterSecurityGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_cluster_security_group
redshift_delete_cluster_security_group <- function(ClusterSecurityGroupName) {
  op <- new_operation(
    name = "DeleteClusterSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_cluster_security_group_input(ClusterSecurityGroupName = ClusterSecurityGroupName)
  output <- .redshift$delete_cluster_security_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_cluster_security_group <- redshift_delete_cluster_security_group

#' Deletes the specified manual snapshot
#'
#' @description
#' Deletes the specified manual snapshot. The snapshot must be in the
#' `available` state, with no other users authorized to access the
#' snapshot.
#' 
#' Unlike automated snapshots, manual snapshots are retained even after you
#' delete your cluster. Amazon Redshift does not delete your manual
#' snapshots. You must delete manual snapshot explicitly to avoid getting
#' charged. If other accounts are authorized to access the snapshot, you
#' must revoke all of the authorizations before you can delete the
#' snapshot.
#'
#' @usage
#' redshift_delete_cluster_snapshot(SnapshotIdentifier,
#'   SnapshotClusterIdentifier)
#'
#' @param SnapshotIdentifier &#91;required&#93; The unique identifier of the manual snapshot to be deleted.
#' 
#' Constraints: Must be the name of an existing snapshot that is in the
#' `available`, `failed`, or `cancelled` state.
#' @param SnapshotClusterIdentifier The unique identifier of the cluster the snapshot was created from. This
#' parameter is required if your IAM user has a policy containing a
#' snapshot resource element that specifies anything other than * for the
#' cluster name.
#' 
#' Constraints: Must be the name of valid cluster.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster_snapshot(
#'   SnapshotIdentifier = "string",
#'   SnapshotClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_cluster_snapshot
redshift_delete_cluster_snapshot <- function(SnapshotIdentifier, SnapshotClusterIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_cluster_snapshot_input(SnapshotIdentifier = SnapshotIdentifier, SnapshotClusterIdentifier = SnapshotClusterIdentifier)
  output <- .redshift$delete_cluster_snapshot_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_cluster_snapshot <- redshift_delete_cluster_snapshot

#' Deletes the specified cluster subnet group
#'
#' @description
#' Deletes the specified cluster subnet group.
#'
#' @usage
#' redshift_delete_cluster_subnet_group(ClusterSubnetGroupName)
#'
#' @param ClusterSubnetGroupName &#91;required&#93; The name of the cluster subnet group name to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster_subnet_group(
#'   ClusterSubnetGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_cluster_subnet_group
redshift_delete_cluster_subnet_group <- function(ClusterSubnetGroupName) {
  op <- new_operation(
    name = "DeleteClusterSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_cluster_subnet_group_input(ClusterSubnetGroupName = ClusterSubnetGroupName)
  output <- .redshift$delete_cluster_subnet_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_cluster_subnet_group <- redshift_delete_cluster_subnet_group

#' Deletes an Amazon Redshift event notification subscription
#'
#' @description
#' Deletes an Amazon Redshift event notification subscription.
#'
#' @usage
#' redshift_delete_event_subscription(SubscriptionName)
#'
#' @param SubscriptionName &#91;required&#93; The name of the Amazon Redshift event notification subscription to be
#' deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_subscription(
#'   SubscriptionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_event_subscription
redshift_delete_event_subscription <- function(SubscriptionName) {
  op <- new_operation(
    name = "DeleteEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_event_subscription_input(SubscriptionName = SubscriptionName)
  output <- .redshift$delete_event_subscription_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_event_subscription <- redshift_delete_event_subscription

#' Deletes the specified HSM client certificate
#'
#' @description
#' Deletes the specified HSM client certificate.
#'
#' @usage
#' redshift_delete_hsm_client_certificate(HsmClientCertificateIdentifier)
#'
#' @param HsmClientCertificateIdentifier &#91;required&#93; The identifier of the HSM client certificate to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_hsm_client_certificate(
#'   HsmClientCertificateIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_hsm_client_certificate
redshift_delete_hsm_client_certificate <- function(HsmClientCertificateIdentifier) {
  op <- new_operation(
    name = "DeleteHsmClientCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_hsm_client_certificate_input(HsmClientCertificateIdentifier = HsmClientCertificateIdentifier)
  output <- .redshift$delete_hsm_client_certificate_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_hsm_client_certificate <- redshift_delete_hsm_client_certificate

#' Deletes the specified Amazon Redshift HSM configuration
#'
#' @description
#' Deletes the specified Amazon Redshift HSM configuration.
#'
#' @usage
#' redshift_delete_hsm_configuration(HsmConfigurationIdentifier)
#'
#' @param HsmConfigurationIdentifier &#91;required&#93; The identifier of the Amazon Redshift HSM configuration to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_hsm_configuration(
#'   HsmConfigurationIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_hsm_configuration
redshift_delete_hsm_configuration <- function(HsmConfigurationIdentifier) {
  op <- new_operation(
    name = "DeleteHsmConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_hsm_configuration_input(HsmConfigurationIdentifier = HsmConfigurationIdentifier)
  output <- .redshift$delete_hsm_configuration_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_hsm_configuration <- redshift_delete_hsm_configuration

#' Deletes a scheduled action
#'
#' @description
#' Deletes a scheduled action.
#'
#' @usage
#' redshift_delete_scheduled_action(ScheduledActionName)
#'
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scheduled_action(
#'   ScheduledActionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_scheduled_action
redshift_delete_scheduled_action <- function(ScheduledActionName) {
  op <- new_operation(
    name = "DeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_scheduled_action_input(ScheduledActionName = ScheduledActionName)
  output <- .redshift$delete_scheduled_action_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_scheduled_action <- redshift_delete_scheduled_action

#' Deletes the specified snapshot copy grant
#'
#' @description
#' Deletes the specified snapshot copy grant.
#'
#' @usage
#' redshift_delete_snapshot_copy_grant(SnapshotCopyGrantName)
#'
#' @param SnapshotCopyGrantName &#91;required&#93; The name of the snapshot copy grant to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot_copy_grant(
#'   SnapshotCopyGrantName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_snapshot_copy_grant
redshift_delete_snapshot_copy_grant <- function(SnapshotCopyGrantName) {
  op <- new_operation(
    name = "DeleteSnapshotCopyGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_snapshot_copy_grant_input(SnapshotCopyGrantName = SnapshotCopyGrantName)
  output <- .redshift$delete_snapshot_copy_grant_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_snapshot_copy_grant <- redshift_delete_snapshot_copy_grant

#' Deletes a snapshot schedule
#'
#' @description
#' Deletes a snapshot schedule.
#'
#' @usage
#' redshift_delete_snapshot_schedule(ScheduleIdentifier)
#'
#' @param ScheduleIdentifier &#91;required&#93; A unique identifier of the snapshot schedule to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot_schedule(
#'   ScheduleIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_snapshot_schedule
redshift_delete_snapshot_schedule <- function(ScheduleIdentifier) {
  op <- new_operation(
    name = "DeleteSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_snapshot_schedule_input(ScheduleIdentifier = ScheduleIdentifier)
  output <- .redshift$delete_snapshot_schedule_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_snapshot_schedule <- redshift_delete_snapshot_schedule

#' Deletes tags from a resource
#'
#' @description
#' Deletes tags from a resource. You must provide the ARN of the resource
#' from which you want to delete the tag or tags.
#'
#' @usage
#' redshift_delete_tags(ResourceName, TagKeys)
#'
#' @param ResourceName &#91;required&#93; The Amazon Resource Name (ARN) from which you want to remove the tag or
#' tags. For example, `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
#' @param TagKeys &#91;required&#93; The tag key that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   ResourceName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_tags
redshift_delete_tags <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_tags_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .redshift$delete_tags_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_tags <- redshift_delete_tags

#' Deletes a usage limit from a cluster
#'
#' @description
#' Deletes a usage limit from a cluster.
#'
#' @usage
#' redshift_delete_usage_limit(UsageLimitId)
#'
#' @param UsageLimitId &#91;required&#93; The identifier of the usage limit to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_usage_limit(
#'   UsageLimitId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_delete_usage_limit
redshift_delete_usage_limit <- function(UsageLimitId) {
  op <- new_operation(
    name = "DeleteUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$delete_usage_limit_input(UsageLimitId = UsageLimitId)
  output <- .redshift$delete_usage_limit_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$delete_usage_limit <- redshift_delete_usage_limit

#' Returns a list of attributes attached to an account
#'
#' @description
#' Returns a list of attributes attached to an account
#'
#' @usage
#' redshift_describe_account_attributes(AttributeNames)
#'
#' @param AttributeNames A list of attribute names.
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_attributes(
#'   AttributeNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_account_attributes
redshift_describe_account_attributes <- function(AttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_account_attributes_input(AttributeNames = AttributeNames)
  output <- .redshift$describe_account_attributes_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_account_attributes <- redshift_describe_account_attributes

#' Returns an array of ClusterDbRevision objects
#'
#' @description
#' Returns an array of `ClusterDbRevision` objects.
#'
#' @usage
#' redshift_describe_cluster_db_revisions(ClusterIdentifier, MaxRecords,
#'   Marker)
#'
#' @param ClusterIdentifier A unique identifier for a cluster whose `ClusterDbRevisions` you are
#' requesting. This parameter is case sensitive. All clusters defined for
#' an account are returned by default.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified MaxRecords
#' value, a value is returned in the `marker` field of the response. You
#' can retrieve the next set of response records by providing the returned
#' `marker` value in the `marker` parameter and retrying the request.
#' 
#' Default: 100
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point for returning a
#' set of response records. When the results of a
#' `DescribeClusterDbRevisions` request exceed the value specified in
#' `MaxRecords`, Amazon Redshift returns a value in the `marker` field of
#' the response. You can retrieve the next set of response records by
#' providing the returned `marker` value in the `marker` parameter and
#' retrying the request.
#' 
#' Constraints: You can specify either the `ClusterIdentifier` parameter,
#' or the `marker` parameter, but not both.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_db_revisions(
#'   ClusterIdentifier = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_db_revisions
redshift_describe_cluster_db_revisions <- function(ClusterIdentifier = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeClusterDbRevisions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_db_revisions_input(ClusterIdentifier = ClusterIdentifier, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_cluster_db_revisions_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_db_revisions <- redshift_describe_cluster_db_revisions

#' Returns a list of Amazon Redshift parameter groups, including parameter
#' groups you created and the default parameter group
#'
#' @description
#' Returns a list of Amazon Redshift parameter groups, including parameter
#' groups you created and the default parameter group. For each parameter
#' group, the response includes the parameter group name, description, and
#' parameter group family name. You can optionally specify a name to
#' retrieve the description of a specific parameter group.
#' 
#' For more information about parameters and parameter groups, go to
#' [Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all parameter groups that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' parameter groups that have any combination of those values are returned.
#' 
#' If both tag keys and values are omitted from the request, parameter
#' groups are returned regardless of whether they have tag keys or values
#' associated with them.
#'
#' @usage
#' redshift_describe_cluster_parameter_groups(ParameterGroupName,
#'   MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param ParameterGroupName The name of a specific parameter group for which to return details. By
#' default, details about all parameter groups and the default parameter
#' group are returned.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a
#' DescribeClusterParameterGroups request exceed the value specified in
#' `MaxRecords`, AWS returns a value in the `Marker` field of the response.
#' You can retrieve the next set of response records by providing the
#' returned marker value in the `Marker` parameter and retrying the
#' request.
#' @param TagKeys A tag key or keys for which you want to return all matching cluster
#' parameter groups that are associated with the specified key or keys. For
#' example, suppose that you have parameter groups that are tagged with
#' keys called `owner` and `environment`. If you specify both of these tag
#' keys in the request, Amazon Redshift returns a response with the
#' parameter groups that have either or both of these tag keys associated
#' with them.
#' @param TagValues A tag value or values for which you want to return all matching cluster
#' parameter groups that are associated with the specified tag value or
#' values. For example, suppose that you have parameter groups that are
#' tagged with values called `admin` and `test`. If you specify both of
#' these tag values in the request, Amazon Redshift returns a response with
#' the parameter groups that have either or both of these tag values
#' associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_parameter_groups(
#'   ParameterGroupName = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_parameter_groups
redshift_describe_cluster_parameter_groups <- function(ParameterGroupName = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_parameter_groups_input(ParameterGroupName = ParameterGroupName, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_cluster_parameter_groups_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_parameter_groups <- redshift_describe_cluster_parameter_groups

#' Returns a detailed list of parameters contained within the specified
#' Amazon Redshift parameter group
#'
#' @description
#' Returns a detailed list of parameters contained within the specified
#' Amazon Redshift parameter group. For each parameter the response
#' includes information such as parameter name, description, data type,
#' value, whether the parameter value is modifiable, and so on.
#' 
#' You can specify *source* filter to retrieve parameters of only specific
#' type. For example, to retrieve parameters that were modified by a user
#' action such as from ModifyClusterParameterGroup, you can specify
#' *source* equal to *user*.
#' 
#' For more information about parameters and parameter groups, go to
#' [Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_describe_cluster_parameters(ParameterGroupName, Source,
#'   MaxRecords, Marker)
#'
#' @param ParameterGroupName &#91;required&#93; The name of a cluster parameter group for which to return details.
#' @param Source The parameter types to return. Specify `user` to show parameters that
#' are different form the default. Similarly, specify `engine-default` to
#' show parameters that are the same as the default parameter group.
#' 
#' Default: All parameter types returned.
#' 
#' Valid Values: `user` | `engine-default`
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeClusterParameters
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_parameters(
#'   ParameterGroupName = "string",
#'   Source = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_parameters
redshift_describe_cluster_parameters <- function(ParameterGroupName, Source = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_parameters_input(ParameterGroupName = ParameterGroupName, Source = Source, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_cluster_parameters_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_parameters <- redshift_describe_cluster_parameters

#' Returns information about Amazon Redshift security groups
#'
#' @description
#' Returns information about Amazon Redshift security groups. If the name
#' of a security group is specified, the response will contain only
#' information about only that security group.
#' 
#' For information about managing security groups, go to [Amazon Redshift
#' Cluster Security
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all security groups that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' security groups that have any combination of those values are returned.
#' 
#' If both tag keys and values are omitted from the request, security
#' groups are returned regardless of whether they have tag keys or values
#' associated with them.
#'
#' @usage
#' redshift_describe_cluster_security_groups(ClusterSecurityGroupName,
#'   MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param ClusterSecurityGroupName The name of a cluster security group for which you are requesting
#' details. You can specify either the **Marker** parameter or a
#' **ClusterSecurityGroupName** parameter, but not both.
#' 
#' Example: `securitygroup1`
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeClusterSecurityGroups
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' 
#' Constraints: You can specify either the **ClusterSecurityGroupName**
#' parameter or the **Marker** parameter, but not both.
#' @param TagKeys A tag key or keys for which you want to return all matching cluster
#' security groups that are associated with the specified key or keys. For
#' example, suppose that you have security groups that are tagged with keys
#' called `owner` and `environment`. If you specify both of these tag keys
#' in the request, Amazon Redshift returns a response with the security
#' groups that have either or both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching cluster
#' security groups that are associated with the specified tag value or
#' values. For example, suppose that you have security groups that are
#' tagged with values called `admin` and `test`. If you specify both of
#' these tag values in the request, Amazon Redshift returns a response with
#' the security groups that have either or both of these tag values
#' associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_security_groups(
#'   ClusterSecurityGroupName = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_security_groups
redshift_describe_cluster_security_groups <- function(ClusterSecurityGroupName = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeClusterSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_security_groups_input(ClusterSecurityGroupName = ClusterSecurityGroupName, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_cluster_security_groups_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_security_groups <- redshift_describe_cluster_security_groups

#' Returns one or more snapshot objects, which contain metadata about your
#' cluster snapshots
#'
#' @description
#' Returns one or more snapshot objects, which contain metadata about your
#' cluster snapshots. By default, this operation returns information about
#' all snapshots of all clusters that are owned by you AWS customer
#' account. No information is returned for snapshots owned by inactive AWS
#' customer accounts.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all snapshots that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' snapshots that have any combination of those values are returned. Only
#' snapshots that you own are returned in the response; shared snapshots
#' are not returned with the tag key and tag value request parameters.
#' 
#' If both tag keys and values are omitted from the request, snapshots are
#' returned regardless of whether they have tag keys or values associated
#' with them.
#'
#' @usage
#' redshift_describe_cluster_snapshots(ClusterIdentifier,
#'   SnapshotIdentifier, SnapshotType, StartTime, EndTime, MaxRecords,
#'   Marker, OwnerAccount, TagKeys, TagValues, ClusterExists,
#'   SortingEntities)
#'
#' @param ClusterIdentifier The identifier of the cluster which generated the requested snapshots.
#' @param SnapshotIdentifier The snapshot identifier of the snapshot about which to return
#' information.
#' @param SnapshotType The type of snapshots for which you are requesting information. By
#' default, snapshots of all types are returned.
#' 
#' Valid Values: `automated` | `manual`
#' @param StartTime A value that requests only snapshots created at or after the specified
#' time. The time value is specified in ISO 8601 format. For more
#' information about ISO 8601, go to the [ISO8601 Wikipedia
#' page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: `2012-07-16T18:00:00Z`
#' @param EndTime A time value that requests only snapshots created at or before the
#' specified time. The time value is specified in ISO 8601 format. For more
#' information about ISO 8601, go to the [ISO8601 Wikipedia
#' page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: `2012-07-16T18:00:00Z`
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeClusterSnapshots
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param OwnerAccount The AWS customer account used to create or copy the snapshot. Use this
#' field to filter the results to snapshots owned by a particular account.
#' To describe snapshots you own, either specify your AWS customer account,
#' or do not specify the parameter.
#' @param TagKeys A tag key or keys for which you want to return all matching cluster
#' snapshots that are associated with the specified key or keys. For
#' example, suppose that you have snapshots that are tagged with keys
#' called `owner` and `environment`. If you specify both of these tag keys
#' in the request, Amazon Redshift returns a response with the snapshots
#' that have either or both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching cluster
#' snapshots that are associated with the specified tag value or values.
#' For example, suppose that you have snapshots that are tagged with values
#' called `admin` and `test`. If you specify both of these tag values in
#' the request, Amazon Redshift returns a response with the snapshots that
#' have either or both of these tag values associated with them.
#' @param ClusterExists A value that indicates whether to return snapshots only for an existing
#' cluster. You can perform table-level restore only by using a snapshot of
#' an existing cluster, that is, a cluster that has not been deleted.
#' Values for this parameter work as follows:
#' 
#' -   If `ClusterExists` is set to `true`, `ClusterIdentifier` is
#'     required.
#' 
#' -   If `ClusterExists` is set to `false` and `ClusterIdentifier` isn't
#'     specified, all snapshots associated with deleted clusters (orphaned
#'     snapshots) are returned.
#' 
#' -   If `ClusterExists` is set to `false` and `ClusterIdentifier` is
#'     specified for a deleted cluster, snapshots associated with that
#'     cluster are returned.
#' 
#' -   If `ClusterExists` is set to `false` and `ClusterIdentifier` is
#'     specified for an existing cluster, no snapshots are returned.
#' @param SortingEntities 
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_snapshots(
#'   ClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   SnapshotType = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   OwnerAccount = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   ),
#'   ClusterExists = TRUE|FALSE,
#'   SortingEntities = list(
#'     list(
#'       Attribute = "SOURCE_TYPE"|"TOTAL_SIZE"|"CREATE_TIME",
#'       SortOrder = "ASC"|"DESC"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_snapshots
redshift_describe_cluster_snapshots <- function(ClusterIdentifier = NULL, SnapshotIdentifier = NULL, SnapshotType = NULL, StartTime = NULL, EndTime = NULL, MaxRecords = NULL, Marker = NULL, OwnerAccount = NULL, TagKeys = NULL, TagValues = NULL, ClusterExists = NULL, SortingEntities = NULL) {
  op <- new_operation(
    name = "DescribeClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_snapshots_input(ClusterIdentifier = ClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, SnapshotType = SnapshotType, StartTime = StartTime, EndTime = EndTime, MaxRecords = MaxRecords, Marker = Marker, OwnerAccount = OwnerAccount, TagKeys = TagKeys, TagValues = TagValues, ClusterExists = ClusterExists, SortingEntities = SortingEntities)
  output <- .redshift$describe_cluster_snapshots_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_snapshots <- redshift_describe_cluster_snapshots

#' Returns one or more cluster subnet group objects, which contain metadata
#' about your cluster subnet groups
#'
#' @description
#' Returns one or more cluster subnet group objects, which contain metadata
#' about your cluster subnet groups. By default, this operation returns
#' information about all cluster subnet groups that are defined in you AWS
#' account.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all subnet groups that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' subnet groups that have any combination of those values are returned.
#' 
#' If both tag keys and values are omitted from the request, subnet groups
#' are returned regardless of whether they have tag keys or values
#' associated with them.
#'
#' @usage
#' redshift_describe_cluster_subnet_groups(ClusterSubnetGroupName,
#'   MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param ClusterSubnetGroupName The name of the cluster subnet group for which information is requested.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeClusterSubnetGroups
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param TagKeys A tag key or keys for which you want to return all matching cluster
#' subnet groups that are associated with the specified key or keys. For
#' example, suppose that you have subnet groups that are tagged with keys
#' called `owner` and `environment`. If you specify both of these tag keys
#' in the request, Amazon Redshift returns a response with the subnet
#' groups that have either or both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching cluster
#' subnet groups that are associated with the specified tag value or
#' values. For example, suppose that you have subnet groups that are tagged
#' with values called `admin` and `test`. If you specify both of these tag
#' values in the request, Amazon Redshift returns a response with the
#' subnet groups that have either or both of these tag values associated
#' with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_subnet_groups(
#'   ClusterSubnetGroupName = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_subnet_groups
redshift_describe_cluster_subnet_groups <- function(ClusterSubnetGroupName = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeClusterSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_subnet_groups_input(ClusterSubnetGroupName = ClusterSubnetGroupName, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_cluster_subnet_groups_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_subnet_groups <- redshift_describe_cluster_subnet_groups

#' Returns a list of all the available maintenance tracks
#'
#' @description
#' Returns a list of all the available maintenance tracks.
#'
#' @usage
#' redshift_describe_cluster_tracks(MaintenanceTrackName, MaxRecords,
#'   Marker)
#'
#' @param MaintenanceTrackName The name of the maintenance track.
#' @param MaxRecords An integer value for the maximum number of maintenance tracks to return.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a `DescribeClusterTracks`
#' request exceed the value specified in `MaxRecords`, Amazon Redshift
#' returns a value in the `Marker` field of the response. You can retrieve
#' the next set of response records by providing the returned marker value
#' in the `Marker` parameter and retrying the request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_tracks(
#'   MaintenanceTrackName = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_tracks
redshift_describe_cluster_tracks <- function(MaintenanceTrackName = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeClusterTracks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_tracks_input(MaintenanceTrackName = MaintenanceTrackName, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_cluster_tracks_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_tracks <- redshift_describe_cluster_tracks

#' Returns descriptions of the available Amazon Redshift cluster versions
#'
#' @description
#' Returns descriptions of the available Amazon Redshift cluster versions.
#' You can call this operation even before creating any clusters to learn
#' more about the Amazon Redshift versions. For more information about
#' managing clusters, go to [Amazon Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_describe_cluster_versions(ClusterVersion,
#'   ClusterParameterGroupFamily, MaxRecords, Marker)
#'
#' @param ClusterVersion The specific cluster version to return.
#' 
#' Example: `1.0`
#' @param ClusterParameterGroupFamily The name of a specific cluster parameter group family to return details
#' for.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeClusterVersions
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster_versions(
#'   ClusterVersion = "string",
#'   ClusterParameterGroupFamily = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_cluster_versions
redshift_describe_cluster_versions <- function(ClusterVersion = NULL, ClusterParameterGroupFamily = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeClusterVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_cluster_versions_input(ClusterVersion = ClusterVersion, ClusterParameterGroupFamily = ClusterParameterGroupFamily, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_cluster_versions_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_cluster_versions <- redshift_describe_cluster_versions

#' Returns properties of provisioned clusters including general cluster
#' properties, cluster database properties, maintenance and backup
#' properties, and security and access properties
#'
#' @description
#' Returns properties of provisioned clusters including general cluster
#' properties, cluster database properties, maintenance and backup
#' properties, and security and access properties. This operation supports
#' pagination. For more information about managing clusters, go to [Amazon
#' Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all clusters that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' clusters that have any combination of those values are returned.
#' 
#' If both tag keys and values are omitted from the request, clusters are
#' returned regardless of whether they have tag keys or values associated
#' with them.
#'
#' @usage
#' redshift_describe_clusters(ClusterIdentifier, MaxRecords, Marker,
#'   TagKeys, TagValues)
#'
#' @param ClusterIdentifier The unique identifier of a cluster whose properties you are requesting.
#' This parameter is case sensitive.
#' 
#' The default is that all clusters defined for an account are returned.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeClusters request
#' exceed the value specified in `MaxRecords`, AWS returns a value in the
#' `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' 
#' Constraints: You can specify either the **ClusterIdentifier** parameter
#' or the **Marker** parameter, but not both.
#' @param TagKeys A tag key or keys for which you want to return all matching clusters
#' that are associated with the specified key or keys. For example, suppose
#' that you have clusters that are tagged with keys called `owner` and
#' `environment`. If you specify both of these tag keys in the request,
#' Amazon Redshift returns a response with the clusters that have either or
#' both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching clusters
#' that are associated with the specified tag value or values. For example,
#' suppose that you have clusters that are tagged with values called
#' `admin` and `test`. If you specify both of these tag values in the
#' request, Amazon Redshift returns a response with the clusters that have
#' either or both of these tag values associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_clusters(
#'   ClusterIdentifier = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_clusters
redshift_describe_clusters <- function(ClusterIdentifier = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_clusters_input(ClusterIdentifier = ClusterIdentifier, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_clusters_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_clusters <- redshift_describe_clusters

#' Returns a list of parameter settings for the specified parameter group
#' family
#'
#' @description
#' Returns a list of parameter settings for the specified parameter group
#' family.
#' 
#' For more information about parameters and parameter groups, go to
#' [Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_describe_default_cluster_parameters(ParameterGroupFamily,
#'   MaxRecords, Marker)
#'
#' @param ParameterGroupFamily &#91;required&#93; The name of the cluster parameter group family.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a
#' DescribeDefaultClusterParameters request exceed the value specified in
#' `MaxRecords`, AWS returns a value in the `Marker` field of the response.
#' You can retrieve the next set of response records by providing the
#' returned marker value in the `Marker` parameter and retrying the
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_default_cluster_parameters(
#'   ParameterGroupFamily = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_default_cluster_parameters
redshift_describe_default_cluster_parameters <- function(ParameterGroupFamily, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_default_cluster_parameters_input(ParameterGroupFamily = ParameterGroupFamily, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_default_cluster_parameters_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_default_cluster_parameters <- redshift_describe_default_cluster_parameters

#' Displays a list of event categories for all event source types, or for a
#' specified source type
#'
#' @description
#' Displays a list of event categories for all event source types, or for a
#' specified source type. For a list of the event categories and source
#' types, go to [Amazon Redshift Event
#' Notifications](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-event-notifications.html).
#'
#' @usage
#' redshift_describe_event_categories(SourceType)
#'
#' @param SourceType The source type, such as cluster or parameter group, to which the
#' described event categories apply.
#' 
#' Valid values: cluster, cluster-snapshot, cluster-parameter-group,
#' cluster-security-group, and scheduled-action.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_categories(
#'   SourceType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_event_categories
redshift_describe_event_categories <- function(SourceType = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_event_categories_input(SourceType = SourceType)
  output <- .redshift$describe_event_categories_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_event_categories <- redshift_describe_event_categories

#' Lists descriptions of all the Amazon Redshift event notification
#' subscriptions for a customer account
#'
#' @description
#' Lists descriptions of all the Amazon Redshift event notification
#' subscriptions for a customer account. If you specify a subscription
#' name, lists the description for that subscription.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all event notification subscriptions that match any
#' combination of the specified keys and values. For example, if you have
#' `owner` and `environment` for tag keys, and `admin` and `test` for tag
#' values, all subscriptions that have any combination of those values are
#' returned.
#' 
#' If both tag keys and values are omitted from the request, subscriptions
#' are returned regardless of whether they have tag keys or values
#' associated with them.
#'
#' @usage
#' redshift_describe_event_subscriptions(SubscriptionName, MaxRecords,
#'   Marker, TagKeys, TagValues)
#'
#' @param SubscriptionName The name of the Amazon Redshift event notification subscription to be
#' described.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeEventSubscriptions
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param TagKeys A tag key or keys for which you want to return all matching event
#' notification subscriptions that are associated with the specified key or
#' keys. For example, suppose that you have subscriptions that are tagged
#' with keys called `owner` and `environment`. If you specify both of these
#' tag keys in the request, Amazon Redshift returns a response with the
#' subscriptions that have either or both of these tag keys associated with
#' them.
#' @param TagValues A tag value or values for which you want to return all matching event
#' notification subscriptions that are associated with the specified tag
#' value or values. For example, suppose that you have subscriptions that
#' are tagged with values called `admin` and `test`. If you specify both of
#' these tag values in the request, Amazon Redshift returns a response with
#' the subscriptions that have either or both of these tag values
#' associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_subscriptions(
#'   SubscriptionName = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_event_subscriptions
redshift_describe_event_subscriptions <- function(SubscriptionName = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_event_subscriptions_input(SubscriptionName = SubscriptionName, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_event_subscriptions_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_event_subscriptions <- redshift_describe_event_subscriptions

#' Returns events related to clusters, security groups, snapshots, and
#' parameter groups for the past 14 days
#'
#' @description
#' Returns events related to clusters, security groups, snapshots, and
#' parameter groups for the past 14 days. Events specific to a particular
#' cluster, security group, snapshot or parameter group can be obtained by
#' providing the name as a parameter. By default, the past hour of events
#' are returned.
#'
#' @usage
#' redshift_describe_events(SourceIdentifier, SourceType, StartTime,
#'   EndTime, Duration, MaxRecords, Marker)
#'
#' @param SourceIdentifier The identifier of the event source for which events will be returned. If
#' this parameter is not specified, then all sources are included in the
#' response.
#' 
#' Constraints:
#' 
#' If *SourceIdentifier* is supplied, *SourceType* must also be provided.
#' 
#' -   Specify a cluster identifier when *SourceType* is `cluster`.
#' 
#' -   Specify a cluster security group name when *SourceType* is
#'     `cluster-security-group`.
#' 
#' -   Specify a cluster parameter group name when *SourceType* is
#'     `cluster-parameter-group`.
#' 
#' -   Specify a cluster snapshot identifier when *SourceType* is
#'     `cluster-snapshot`.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' 
#' Constraints:
#' 
#' If *SourceType* is supplied, *SourceIdentifier* must also be provided.
#' 
#' -   Specify `cluster` when *SourceIdentifier* is a cluster identifier.
#' 
#' -   Specify `cluster-security-group` when *SourceIdentifier* is a
#'     cluster security group name.
#' 
#' -   Specify `cluster-parameter-group` when *SourceIdentifier* is a
#'     cluster parameter group name.
#' 
#' -   Specify `cluster-snapshot` when *SourceIdentifier* is a cluster
#'     snapshot identifier.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: `2009-07-08T18:00Z`
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](https://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: `2009-07-08T18:00Z`
#' @param Duration The number of minutes prior to the time of the request for which to
#' retrieve events. For example, if the request is sent at 18:00 and you
#' specify a duration of 60, then only events which have occurred after
#' 17:00 will be returned.
#' 
#' Default: `60`
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeEvents request exceed
#' the value specified in `MaxRecords`, AWS returns a value in the `Marker`
#' field of the response. You can retrieve the next set of response records
#' by providing the returned marker value in the `Marker` parameter and
#' retrying the request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   SourceIdentifier = "string",
#'   SourceType = "cluster"|"cluster-parameter-group"|"cluster-security-group"|"cluster-snapshot"|"scheduled-action",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Duration = 123,
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_events
redshift_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_events_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_events <- redshift_describe_events

#' Returns information about the specified HSM client certificate
#'
#' @description
#' Returns information about the specified HSM client certificate. If no
#' certificate ID is specified, returns information about all the HSM
#' certificates owned by your AWS customer account.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all HSM client certificates that match any combination
#' of the specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' HSM client certificates that have any combination of those values are
#' returned.
#' 
#' If both tag keys and values are omitted from the request, HSM client
#' certificates are returned regardless of whether they have tag keys or
#' values associated with them.
#'
#' @usage
#' redshift_describe_hsm_client_certificates(
#'   HsmClientCertificateIdentifier, MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param HsmClientCertificateIdentifier The identifier of a specific HSM client certificate for which you want
#' information. If no identifier is specified, information is returned for
#' all HSM client certificates owned by your AWS customer account.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeHsmClientCertificates
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param TagKeys A tag key or keys for which you want to return all matching HSM client
#' certificates that are associated with the specified key or keys. For
#' example, suppose that you have HSM client certificates that are tagged
#' with keys called `owner` and `environment`. If you specify both of these
#' tag keys in the request, Amazon Redshift returns a response with the HSM
#' client certificates that have either or both of these tag keys
#' associated with them.
#' @param TagValues A tag value or values for which you want to return all matching HSM
#' client certificates that are associated with the specified tag value or
#' values. For example, suppose that you have HSM client certificates that
#' are tagged with values called `admin` and `test`. If you specify both of
#' these tag values in the request, Amazon Redshift returns a response with
#' the HSM client certificates that have either or both of these tag values
#' associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hsm_client_certificates(
#'   HsmClientCertificateIdentifier = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_hsm_client_certificates
redshift_describe_hsm_client_certificates <- function(HsmClientCertificateIdentifier = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeHsmClientCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_hsm_client_certificates_input(HsmClientCertificateIdentifier = HsmClientCertificateIdentifier, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_hsm_client_certificates_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_hsm_client_certificates <- redshift_describe_hsm_client_certificates

#' Returns information about the specified Amazon Redshift HSM
#' configuration
#'
#' @description
#' Returns information about the specified Amazon Redshift HSM
#' configuration. If no configuration ID is specified, returns information
#' about all the HSM configurations owned by your AWS customer account.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all HSM connections that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' HSM connections that have any combination of those values are returned.
#' 
#' If both tag keys and values are omitted from the request, HSM
#' connections are returned regardless of whether they have tag keys or
#' values associated with them.
#'
#' @usage
#' redshift_describe_hsm_configurations(HsmConfigurationIdentifier,
#'   MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param HsmConfigurationIdentifier The identifier of a specific Amazon Redshift HSM configuration to be
#' described. If no identifier is specified, information is returned for
#' all HSM configurations owned by your AWS customer account.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeHsmConfigurations
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param TagKeys A tag key or keys for which you want to return all matching HSM
#' configurations that are associated with the specified key or keys. For
#' example, suppose that you have HSM configurations that are tagged with
#' keys called `owner` and `environment`. If you specify both of these tag
#' keys in the request, Amazon Redshift returns a response with the HSM
#' configurations that have either or both of these tag keys associated
#' with them.
#' @param TagValues A tag value or values for which you want to return all matching HSM
#' configurations that are associated with the specified tag value or
#' values. For example, suppose that you have HSM configurations that are
#' tagged with values called `admin` and `test`. If you specify both of
#' these tag values in the request, Amazon Redshift returns a response with
#' the HSM configurations that have either or both of these tag values
#' associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hsm_configurations(
#'   HsmConfigurationIdentifier = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_hsm_configurations
redshift_describe_hsm_configurations <- function(HsmConfigurationIdentifier = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeHsmConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_hsm_configurations_input(HsmConfigurationIdentifier = HsmConfigurationIdentifier, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_hsm_configurations_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_hsm_configurations <- redshift_describe_hsm_configurations

#' Describes whether information, such as queries and connection attempts,
#' is being logged for the specified Amazon Redshift cluster
#'
#' @description
#' Describes whether information, such as queries and connection attempts,
#' is being logged for the specified Amazon Redshift cluster.
#'
#' @usage
#' redshift_describe_logging_status(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster from which to get the logging status.
#' 
#' Example: `examplecluster`
#'
#' @section Request syntax:
#' ```
#' svc$describe_logging_status(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_logging_status
redshift_describe_logging_status <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "DescribeLoggingStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_logging_status_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$describe_logging_status_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_logging_status <- redshift_describe_logging_status

#' Returns properties of possible node configurations such as node type,
#' number of nodes, and disk usage for the specified action type
#'
#' @description
#' Returns properties of possible node configurations such as node type,
#' number of nodes, and disk usage for the specified action type.
#'
#' @usage
#' redshift_describe_node_configuration_options(ActionType,
#'   ClusterIdentifier, SnapshotIdentifier, OwnerAccount, Filters, Marker,
#'   MaxRecords)
#'
#' @param ActionType &#91;required&#93; The action type to evaluate for possible node configurations. Specify
#' "restore-cluster" to get configuration combinations based on an existing
#' snapshot. Specify "recommend-node-config" to get configuration
#' recommendations based on an existing cluster or snapshot. Specify
#' "resize-cluster" to get configuration combinations for elastic resize
#' based on an existing cluster.
#' @param ClusterIdentifier The identifier of the cluster to evaluate for possible node
#' configurations.
#' @param SnapshotIdentifier The identifier of the snapshot to evaluate for possible node
#' configurations.
#' @param OwnerAccount The AWS customer account used to create or copy the snapshot. Required
#' if you are restoring a snapshot you do not own, optional if you own the
#' snapshot.
#' @param Filters A set of name, operator, and value items to filter the results.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a
#' DescribeNodeConfigurationOptions request exceed the value specified in
#' `MaxRecords`, AWS returns a value in the `Marker` field of the response.
#' You can retrieve the next set of response records by providing the
#' returned marker value in the `Marker` parameter and retrying the
#' request.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `500`
#' 
#' Constraints: minimum 100, maximum 500.
#'
#' @section Request syntax:
#' ```
#' svc$describe_node_configuration_options(
#'   ActionType = "restore-cluster"|"recommend-node-config"|"resize-cluster",
#'   ClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   OwnerAccount = "string",
#'   Filters = list(
#'     list(
#'       Name = "NodeType"|"NumberOfNodes"|"EstimatedDiskUtilizationPercent"|"Mode",
#'       Operator = "eq"|"lt"|"gt"|"le"|"ge"|"in"|"between",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_node_configuration_options
redshift_describe_node_configuration_options <- function(ActionType, ClusterIdentifier = NULL, SnapshotIdentifier = NULL, OwnerAccount = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeNodeConfigurationOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_node_configuration_options_input(ActionType = ActionType, ClusterIdentifier = ClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, OwnerAccount = OwnerAccount, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .redshift$describe_node_configuration_options_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_node_configuration_options <- redshift_describe_node_configuration_options

#' Returns a list of orderable cluster options
#'
#' @description
#' Returns a list of orderable cluster options. Before you create a new
#' cluster you can use this operation to find what options are available,
#' such as the EC2 Availability Zones (AZ) in the specific AWS Region that
#' you can specify, and the node types you can request. The node types
#' differ by available storage, memory, CPU and price. With the cost
#' involved you might want to obtain a list of cluster options in the
#' specific region and specify values when creating a cluster. For more
#' information about managing clusters, go to [Amazon Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_describe_orderable_cluster_options(ClusterVersion, NodeType,
#'   MaxRecords, Marker)
#'
#' @param ClusterVersion The version filter value. Specify this parameter to show only the
#' available offerings matching the specified version.
#' 
#' Default: All versions.
#' 
#' Constraints: Must be one of the version returned from
#' DescribeClusterVersions.
#' @param NodeType The node type filter value. Specify this parameter to show only the
#' available offerings matching the specified node type.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a
#' DescribeOrderableClusterOptions request exceed the value specified in
#' `MaxRecords`, AWS returns a value in the `Marker` field of the response.
#' You can retrieve the next set of response records by providing the
#' returned marker value in the `Marker` parameter and retrying the
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_orderable_cluster_options(
#'   ClusterVersion = "string",
#'   NodeType = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_orderable_cluster_options
redshift_describe_orderable_cluster_options <- function(ClusterVersion = NULL, NodeType = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableClusterOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_orderable_cluster_options_input(ClusterVersion = ClusterVersion, NodeType = NodeType, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_orderable_cluster_options_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_orderable_cluster_options <- redshift_describe_orderable_cluster_options

#' Returns a list of the available reserved node offerings by Amazon
#' Redshift with their descriptions including the node type, the fixed and
#' recurring costs of reserving the node and duration the node will be
#' reserved for you
#'
#' @description
#' Returns a list of the available reserved node offerings by Amazon
#' Redshift with their descriptions including the node type, the fixed and
#' recurring costs of reserving the node and duration the node will be
#' reserved for you. These descriptions help you determine which reserve
#' node offering you want to purchase. You then use the unique offering ID
#' in you call to PurchaseReservedNodeOffering to reserve one or more nodes
#' for your Amazon Redshift cluster.
#' 
#' For more information about reserved node offerings, go to [Purchasing
#' Reserved
#' Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_describe_reserved_node_offerings(ReservedNodeOfferingId,
#'   MaxRecords, Marker)
#'
#' @param ReservedNodeOfferingId The unique identifier for the offering.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeReservedNodeOfferings
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_node_offerings(
#'   ReservedNodeOfferingId = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_reserved_node_offerings
redshift_describe_reserved_node_offerings <- function(ReservedNodeOfferingId = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedNodeOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_reserved_node_offerings_input(ReservedNodeOfferingId = ReservedNodeOfferingId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_reserved_node_offerings_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_reserved_node_offerings <- redshift_describe_reserved_node_offerings

#' Returns the descriptions of the reserved nodes
#'
#' @description
#' Returns the descriptions of the reserved nodes.
#'
#' @usage
#' redshift_describe_reserved_nodes(ReservedNodeId, MaxRecords, Marker)
#'
#' @param ReservedNodeId Identifier for the node reservation.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeReservedNodes request
#' exceed the value specified in `MaxRecords`, AWS returns a value in the
#' `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_nodes(
#'   ReservedNodeId = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_reserved_nodes
redshift_describe_reserved_nodes <- function(ReservedNodeId = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedNodes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_reserved_nodes_input(ReservedNodeId = ReservedNodeId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_reserved_nodes_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_reserved_nodes <- redshift_describe_reserved_nodes

#' Returns information about the last resize operation for the specified
#' cluster
#'
#' @description
#' Returns information about the last resize operation for the specified
#' cluster. If no resize operation has ever been initiated for the
#' specified cluster, a `HTTP 404` error is returned. If a resize operation
#' was initiated and completed, the status of the resize remains as
#' `SUCCEEDED` until the next resize.
#' 
#' A resize operation can be requested using ModifyCluster and specifying a
#' different number or type of nodes for the cluster.
#'
#' @usage
#' redshift_describe_resize(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of a cluster whose resize progress you are
#' requesting. This parameter is case-sensitive.
#' 
#' By default, resize operations for all clusters defined for an AWS
#' account are returned.
#'
#' @section Request syntax:
#' ```
#' svc$describe_resize(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_resize
redshift_describe_resize <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "DescribeResize",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_resize_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$describe_resize_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_resize <- redshift_describe_resize

#' Describes properties of scheduled actions
#'
#' @description
#' Describes properties of scheduled actions.
#'
#' @usage
#' redshift_describe_scheduled_actions(ScheduledActionName,
#'   TargetActionType, StartTime, EndTime, Active, Filters, Marker,
#'   MaxRecords)
#'
#' @param ScheduledActionName The name of the scheduled action to retrieve.
#' @param TargetActionType The type of the scheduled actions to retrieve.
#' @param StartTime The start time in UTC of the scheduled actions to retrieve. Only active
#' scheduled actions that have invocations after this time are retrieved.
#' @param EndTime The end time in UTC of the scheduled action to retrieve. Only active
#' scheduled actions that have invocations before this time are retrieved.
#' @param Active If true, retrieve only active scheduled actions. If false, retrieve only
#' disabled scheduled actions.
#' @param Filters List of scheduled action filters.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeScheduledActions
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scheduled_actions(
#'   ScheduledActionName = "string",
#'   TargetActionType = "ResizeCluster"|"PauseCluster"|"ResumeCluster",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Active = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "cluster-identifier"|"iam-role",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_scheduled_actions
redshift_describe_scheduled_actions <- function(ScheduledActionName = NULL, TargetActionType = NULL, StartTime = NULL, EndTime = NULL, Active = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeScheduledActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_scheduled_actions_input(ScheduledActionName = ScheduledActionName, TargetActionType = TargetActionType, StartTime = StartTime, EndTime = EndTime, Active = Active, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .redshift$describe_scheduled_actions_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_scheduled_actions <- redshift_describe_scheduled_actions

#' Returns a list of snapshot copy grants owned by the AWS account in the
#' destination region
#'
#' @description
#' Returns a list of snapshot copy grants owned by the AWS account in the
#' destination region.
#' 
#' For more information about managing snapshot copy grants, go to [Amazon
#' Redshift Database
#' Encryption](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-db-encryption.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_describe_snapshot_copy_grants(SnapshotCopyGrantName,
#'   MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param SnapshotCopyGrantName The name of the snapshot copy grant.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a `DescribeSnapshotCopyGrant`
#' request exceed the value specified in `MaxRecords`, AWS returns a value
#' in the `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' 
#' Constraints: You can specify either the **SnapshotCopyGrantName**
#' parameter or the **Marker** parameter, but not both.
#' @param TagKeys A tag key or keys for which you want to return all matching resources
#' that are associated with the specified key or keys. For example, suppose
#' that you have resources tagged with keys called `owner` and
#' `environment`. If you specify both of these tag keys in the request,
#' Amazon Redshift returns a response with all resources that have either
#' or both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching
#' resources that are associated with the specified value or values. For
#' example, suppose that you have resources tagged with values called
#' `admin` and `test`. If you specify both of these tag values in the
#' request, Amazon Redshift returns a response with all resources that have
#' either or both of these tag values associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshot_copy_grants(
#'   SnapshotCopyGrantName = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_snapshot_copy_grants
redshift_describe_snapshot_copy_grants <- function(SnapshotCopyGrantName = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeSnapshotCopyGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_snapshot_copy_grants_input(SnapshotCopyGrantName = SnapshotCopyGrantName, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_snapshot_copy_grants_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_snapshot_copy_grants <- redshift_describe_snapshot_copy_grants

#' Returns a list of snapshot schedules
#'
#' @description
#' Returns a list of snapshot schedules.
#'
#' @usage
#' redshift_describe_snapshot_schedules(ClusterIdentifier,
#'   ScheduleIdentifier, TagKeys, TagValues, Marker, MaxRecords)
#'
#' @param ClusterIdentifier The unique identifier for the cluster whose snapshot schedules you want
#' to view.
#' @param ScheduleIdentifier A unique identifier for a snapshot schedule.
#' @param TagKeys The key value for a snapshot schedule tag.
#' @param TagValues The value corresponding to the key of the snapshot schedule tag.
#' @param Marker A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' marker value in the `marker` parameter and retrying the command. If the
#' `marker` field is empty, all response records have been retrieved for
#' the request.
#' @param MaxRecords The maximum number or response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned `marker` value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshot_schedules(
#'   ClusterIdentifier = "string",
#'   ScheduleIdentifier = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_snapshot_schedules
redshift_describe_snapshot_schedules <- function(ClusterIdentifier = NULL, ScheduleIdentifier = NULL, TagKeys = NULL, TagValues = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeSnapshotSchedules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_snapshot_schedules_input(ClusterIdentifier = ClusterIdentifier, ScheduleIdentifier = ScheduleIdentifier, TagKeys = TagKeys, TagValues = TagValues, Marker = Marker, MaxRecords = MaxRecords)
  output <- .redshift$describe_snapshot_schedules_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_snapshot_schedules <- redshift_describe_snapshot_schedules

#' Returns account level backups storage size and provisional storage
#'
#' @description
#' Returns account level backups storage size and provisional storage.
#'
#' @usage
#' redshift_describe_storage()
#'

#'

#'
#' @keywords internal
#'
#' @rdname redshift_describe_storage
redshift_describe_storage <- function() {
  op <- new_operation(
    name = "DescribeStorage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_storage_input()
  output <- .redshift$describe_storage_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_storage <- redshift_describe_storage

#' Lists the status of one or more table restore requests made using the
#' RestoreTableFromClusterSnapshot API action
#'
#' @description
#' Lists the status of one or more table restore requests made using the
#' RestoreTableFromClusterSnapshot API action. If you don't specify a value
#' for the `TableRestoreRequestId` parameter, then
#' `DescribeTableRestoreStatus` returns the status of all table restore
#' requests ordered by the date and time of the request in ascending order.
#' Otherwise `DescribeTableRestoreStatus` returns the status of the table
#' specified by `TableRestoreRequestId`.
#'
#' @usage
#' redshift_describe_table_restore_status(ClusterIdentifier,
#'   TableRestoreRequestId, MaxRecords, Marker)
#'
#' @param ClusterIdentifier The Amazon Redshift cluster that the table is being restored to.
#' @param TableRestoreRequestId The identifier of the table restore request to return status for. If you
#' don't specify a `TableRestoreRequestId` value, then
#' `DescribeTableRestoreStatus` returns the status of all in-progress table
#' restore requests.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeTableRestoreStatus` request. If this parameter is specified,
#' the response includes only records beyond the marker, up to the value
#' specified by the `MaxRecords` parameter.
#'
#' @section Request syntax:
#' ```
#' svc$describe_table_restore_status(
#'   ClusterIdentifier = "string",
#'   TableRestoreRequestId = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_table_restore_status
redshift_describe_table_restore_status <- function(ClusterIdentifier = NULL, TableRestoreRequestId = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeTableRestoreStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_table_restore_status_input(ClusterIdentifier = ClusterIdentifier, TableRestoreRequestId = TableRestoreRequestId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$describe_table_restore_status_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_table_restore_status <- redshift_describe_table_restore_status

#' Returns a list of tags
#'
#' @description
#' Returns a list of tags. You can return tags from a specific resource by
#' specifying an ARN, or you can return all tags for a given type of
#' resource, such as clusters, snapshots, and so on.
#' 
#' The following are limitations for `DescribeTags`:
#' 
#' -   You cannot specify an ARN and a resource-type value together in the
#'     same request.
#' 
#' -   You cannot use the `MaxRecords` and `Marker` parameters together
#'     with the ARN parameter.
#' 
#' -   The `MaxRecords` parameter can be a range from 10 to 50 results to
#'     return in a request.
#' 
#' If you specify both tag keys and tag values in the same request, Amazon
#' Redshift returns all resources that match any combination of the
#' specified keys and values. For example, if you have `owner` and
#' `environment` for tag keys, and `admin` and `test` for tag values, all
#' resources that have any combination of those values are returned.
#' 
#' If both tag keys and values are omitted from the request, resources are
#' returned regardless of whether they have tag keys or values associated
#' with them.
#'
#' @usage
#' redshift_describe_tags(ResourceName, ResourceType, MaxRecords, Marker,
#'   TagKeys, TagValues)
#'
#' @param ResourceName The Amazon Resource Name (ARN) for which you want to describe the tag or
#' tags. For example, `arn:aws:redshift:us-east-2:123456789:cluster:t1`.
#' @param ResourceType The type of resource with which you want to view tags. Valid resource
#' types are:
#' 
#' -   Cluster
#' 
#' -   CIDR/IP
#' 
#' -   EC2 security group
#' 
#' -   Snapshot
#' 
#' -   Cluster security group
#' 
#' -   Subnet group
#' 
#' -   HSM connection
#' 
#' -   HSM certificate
#' 
#' -   Parameter group
#' 
#' -   Snapshot copy grant
#' 
#' For more information about Amazon Redshift resource types and
#' constructing ARNs, go to [Specifying Policy Elements: Actions, Effects,
#' Resources, and
#' Principals](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions)
#' in the Amazon Redshift Cluster Management Guide.
#' @param MaxRecords The maximum number or response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned `marker` value.
#' @param Marker A value that indicates the starting point for the next set of response
#' records in a subsequent request. If a value is returned in a response,
#' you can retrieve the next set of records by providing this returned
#' marker value in the `marker` parameter and retrying the command. If the
#' `marker` field is empty, all response records have been retrieved for
#' the request.
#' @param TagKeys A tag key or keys for which you want to return all matching resources
#' that are associated with the specified key or keys. For example, suppose
#' that you have resources tagged with keys called `owner` and
#' `environment`. If you specify both of these tag keys in the request,
#' Amazon Redshift returns a response with all resources that have either
#' or both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching
#' resources that are associated with the specified value or values. For
#' example, suppose that you have resources tagged with values called
#' `admin` and `test`. If you specify both of these tag values in the
#' request, Amazon Redshift returns a response with all resources that have
#' either or both of these tag values associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   ResourceName = "string",
#'   ResourceType = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_tags
redshift_describe_tags <- function(ResourceName = NULL, ResourceType = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_tags_input(ResourceName = ResourceName, ResourceType = ResourceType, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_tags_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_tags <- redshift_describe_tags

#' Shows usage limits on a cluster
#'
#' @description
#' Shows usage limits on a cluster. Results are filtered based on the
#' combination of input usage limit identifier, cluster identifier, and
#' feature type parameters:
#' 
#' -   If usage limit identifier, cluster identifier, and feature type are
#'     not provided, then all usage limit objects for the current account
#'     in the current region are returned.
#' 
#' -   If usage limit identifier is provided, then the corresponding usage
#'     limit object is returned.
#' 
#' -   If cluster identifier is provided, then all usage limit objects for
#'     the specified cluster are returned.
#' 
#' -   If cluster identifier and feature type are provided, then all usage
#'     limit objects for the combination of cluster and feature are
#'     returned.
#'
#' @usage
#' redshift_describe_usage_limits(UsageLimitId, ClusterIdentifier,
#'   FeatureType, MaxRecords, Marker, TagKeys, TagValues)
#'
#' @param UsageLimitId The identifier of the usage limit to describe.
#' @param ClusterIdentifier The identifier of the cluster for which you want to describe usage
#' limits.
#' @param FeatureType The feature type for which you want to describe usage limits.
#' @param MaxRecords The maximum number of response records to return in each call. If the
#' number of remaining response records exceeds the specified `MaxRecords`
#' value, a value is returned in a `marker` field of the response. You can
#' retrieve the next set of records by retrying the command with the
#' returned marker value.
#' 
#' Default: `100`
#' 
#' Constraints: minimum 20, maximum 100.
#' @param Marker An optional parameter that specifies the starting point to return a set
#' of response records. When the results of a DescribeUsageLimits request
#' exceed the value specified in `MaxRecords`, AWS returns a value in the
#' `Marker` field of the response. You can retrieve the next set of
#' response records by providing the returned marker value in the `Marker`
#' parameter and retrying the request.
#' @param TagKeys A tag key or keys for which you want to return all matching usage limit
#' objects that are associated with the specified key or keys. For example,
#' suppose that you have parameter groups that are tagged with keys called
#' `owner` and `environment`. If you specify both of these tag keys in the
#' request, Amazon Redshift returns a response with the usage limit objects
#' have either or both of these tag keys associated with them.
#' @param TagValues A tag value or values for which you want to return all matching usage
#' limit objects that are associated with the specified tag value or
#' values. For example, suppose that you have parameter groups that are
#' tagged with values called `admin` and `test`. If you specify both of
#' these tag values in the request, Amazon Redshift returns a response with
#' the usage limit objects that have either or both of these tag values
#' associated with them.
#'
#' @section Request syntax:
#' ```
#' svc$describe_usage_limits(
#'   UsageLimitId = "string",
#'   ClusterIdentifier = "string",
#'   FeatureType = "spectrum"|"concurrency-scaling",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   TagKeys = list(
#'     "string"
#'   ),
#'   TagValues = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_describe_usage_limits
redshift_describe_usage_limits <- function(UsageLimitId = NULL, ClusterIdentifier = NULL, FeatureType = NULL, MaxRecords = NULL, Marker = NULL, TagKeys = NULL, TagValues = NULL) {
  op <- new_operation(
    name = "DescribeUsageLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$describe_usage_limits_input(UsageLimitId = UsageLimitId, ClusterIdentifier = ClusterIdentifier, FeatureType = FeatureType, MaxRecords = MaxRecords, Marker = Marker, TagKeys = TagKeys, TagValues = TagValues)
  output <- .redshift$describe_usage_limits_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$describe_usage_limits <- redshift_describe_usage_limits

#' Stops logging information, such as queries and connection attempts, for
#' the specified Amazon Redshift cluster
#'
#' @description
#' Stops logging information, such as queries and connection attempts, for
#' the specified Amazon Redshift cluster.
#'
#' @usage
#' redshift_disable_logging(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster on which logging is to be stopped.
#' 
#' Example: `examplecluster`
#'
#' @section Request syntax:
#' ```
#' svc$disable_logging(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_disable_logging
redshift_disable_logging <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "DisableLogging",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$disable_logging_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$disable_logging_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$disable_logging <- redshift_disable_logging

#' Disables the automatic copying of snapshots from one region to another
#' region for a specified cluster
#'
#' @description
#' Disables the automatic copying of snapshots from one region to another
#' region for a specified cluster.
#' 
#' If your cluster and its snapshots are encrypted using a customer master
#' key (CMK) from AWS KMS, use DeleteSnapshotCopyGrant to delete the grant
#' that grants Amazon Redshift permission to the CMK in the destination
#' region.
#'
#' @usage
#' redshift_disable_snapshot_copy(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the source cluster that you want to disable
#' copying of snapshots to a destination region.
#' 
#' Constraints: Must be the valid name of an existing cluster that has
#' cross-region snapshot copy enabled.
#'
#' @section Request syntax:
#' ```
#' svc$disable_snapshot_copy(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_disable_snapshot_copy
redshift_disable_snapshot_copy <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "DisableSnapshotCopy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$disable_snapshot_copy_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$disable_snapshot_copy_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$disable_snapshot_copy <- redshift_disable_snapshot_copy

#' Starts logging information, such as queries and connection attempts, for
#' the specified Amazon Redshift cluster
#'
#' @description
#' Starts logging information, such as queries and connection attempts, for
#' the specified Amazon Redshift cluster.
#'
#' @usage
#' redshift_enable_logging(ClusterIdentifier, BucketName, S3KeyPrefix)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster on which logging is to be started.
#' 
#' Example: `examplecluster`
#' @param BucketName &#91;required&#93; The name of an existing S3 bucket where the log files are to be stored.
#' 
#' Constraints:
#' 
#' -   Must be in the same region as the cluster
#' 
#' -   The cluster must have read bucket and put object permissions
#' @param S3KeyPrefix The prefix applied to the log file names.
#' 
#' Constraints:
#' 
#' -   Cannot exceed 512 characters
#' 
#' -   Cannot contain spaces( ), double quotes ("), single quotes ('), a
#'     backslash (\\), or control characters. The hexadecimal codes for
#'     invalid characters are:
#' 
#'     -   x00 to x20
#' 
#'     -   x22
#' 
#'     -   x27
#' 
#'     -   x5c
#' 
#'     -   x7f or larger
#'
#' @section Request syntax:
#' ```
#' svc$enable_logging(
#'   ClusterIdentifier = "string",
#'   BucketName = "string",
#'   S3KeyPrefix = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_enable_logging
redshift_enable_logging <- function(ClusterIdentifier, BucketName, S3KeyPrefix = NULL) {
  op <- new_operation(
    name = "EnableLogging",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$enable_logging_input(ClusterIdentifier = ClusterIdentifier, BucketName = BucketName, S3KeyPrefix = S3KeyPrefix)
  output <- .redshift$enable_logging_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$enable_logging <- redshift_enable_logging

#' Enables the automatic copy of snapshots from one region to another
#' region for a specified cluster
#'
#' @description
#' Enables the automatic copy of snapshots from one region to another
#' region for a specified cluster.
#'
#' @usage
#' redshift_enable_snapshot_copy(ClusterIdentifier, DestinationRegion,
#'   RetentionPeriod, SnapshotCopyGrantName, ManualSnapshotRetentionPeriod)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the source cluster to copy snapshots from.
#' 
#' Constraints: Must be the valid name of an existing cluster that does not
#' already have cross-region snapshot copy enabled.
#' @param DestinationRegion &#91;required&#93; The destination AWS Region that you want to copy snapshots to.
#' 
#' Constraints: Must be the name of a valid AWS Region. For more
#' information, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#redshift_region)
#' in the Amazon Web Services General Reference.
#' @param RetentionPeriod The number of days to retain automated snapshots in the destination
#' region after they are copied from the source region.
#' 
#' Default: 7.
#' 
#' Constraints: Must be at least 1 and no more than 35.
#' @param SnapshotCopyGrantName The name of the snapshot copy grant to use when snapshots of an AWS
#' KMS-encrypted cluster are copied to the destination region.
#' @param ManualSnapshotRetentionPeriod The number of days to retain newly copied snapshots in the destination
#' AWS Region after they are copied from the source AWS Region. If the
#' value is -1, the manual snapshot is retained indefinitely.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#'
#' @section Request syntax:
#' ```
#' svc$enable_snapshot_copy(
#'   ClusterIdentifier = "string",
#'   DestinationRegion = "string",
#'   RetentionPeriod = 123,
#'   SnapshotCopyGrantName = "string",
#'   ManualSnapshotRetentionPeriod = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_enable_snapshot_copy
redshift_enable_snapshot_copy <- function(ClusterIdentifier, DestinationRegion, RetentionPeriod = NULL, SnapshotCopyGrantName = NULL, ManualSnapshotRetentionPeriod = NULL) {
  op <- new_operation(
    name = "EnableSnapshotCopy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$enable_snapshot_copy_input(ClusterIdentifier = ClusterIdentifier, DestinationRegion = DestinationRegion, RetentionPeriod = RetentionPeriod, SnapshotCopyGrantName = SnapshotCopyGrantName, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod)
  output <- .redshift$enable_snapshot_copy_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$enable_snapshot_copy <- redshift_enable_snapshot_copy

#' Returns a database user name and temporary password with temporary
#' authorization to log on to an Amazon Redshift database
#'
#' @description
#' Returns a database user name and temporary password with temporary
#' authorization to log on to an Amazon Redshift database. The action
#' returns the database user name prefixed with `IAM:` if `AutoCreate` is
#' `False` or `IAMA:` if `AutoCreate` is `True`. You can optionally specify
#' one or more database user groups that the user will join at log on. By
#' default, the temporary credentials expire in 900 seconds. You can
#' optionally specify a duration between 900 seconds (15 minutes) and 3600
#' seconds (60 minutes). For more information, see [Using IAM
#' Authentication to Generate Database User
#' Credentials](https://docs.aws.amazon.com/redshift/latest/mgmt/generating-user-credentials.html)
#' in the Amazon Redshift Cluster Management Guide.
#' 
#' The AWS Identity and Access Management (IAM)user or role that executes
#' GetClusterCredentials must have an IAM policy attached that allows
#' access to all necessary actions and resources. For more information
#' about permissions, see [Resource Policies for
#' GetClusterCredentials](https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html#redshift-policy-resources.getclustercredentials-resources)
#' in the Amazon Redshift Cluster Management Guide.
#' 
#' If the `DbGroups` parameter is specified, the IAM policy must allow the
#' `redshift:JoinGroup` action with access to the listed `dbgroups`.
#' 
#' In addition, if the `AutoCreate` parameter is set to `True`, then the
#' policy must include the `redshift:CreateClusterUser` privilege.
#' 
#' If the `DbName` parameter is specified, the IAM policy must allow access
#' to the resource `dbname` for the specified database name.
#'
#' @usage
#' redshift_get_cluster_credentials(DbUser, DbName, ClusterIdentifier,
#'   DurationSeconds, AutoCreate, DbGroups)
#'
#' @param DbUser &#91;required&#93; The name of a database user. If a user name matching `DbUser` exists in
#' the database, the temporary user credentials have the same permissions
#' as the existing user. If `DbUser` doesn't exist in the database and
#' `Autocreate` is `True`, a new user is created using the value for
#' `DbUser` with PUBLIC permissions. If a database user matching the value
#' for `DbUser` doesn't exist and `Autocreate` is `False`, then the command
#' succeeds but the connection attempt will fail because the user doesn't
#' exist in the database.
#' 
#' For more information, see [CREATE
#' USER](https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html)
#' in the Amazon Redshift Database Developer Guide.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 64 alphanumeric characters or hyphens. The user name
#'     can't be `PUBLIC`.
#' 
#' -   Must contain only lowercase letters, numbers, underscore, plus sign,
#'     period (dot), at symbol (@@), or hyphen.
#' 
#' -   First character must be a letter.
#' 
#' -   Must not contain a colon ( : ) or slash ( / ).
#' 
#' -   Cannot be a reserved word. A list of reserved words can be found in
#'     [Reserved
#'     Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
#'     in the Amazon Redshift Database Developer Guide.
#' @param DbName The name of a database that `DbUser` is authorized to log on to. If
#' `DbName` is not specified, `DbUser` can log on to any existing database.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 64 alphanumeric characters or hyphens
#' 
#' -   Must contain only lowercase letters, numbers, underscore, plus sign,
#'     period (dot), at symbol (@@), or hyphen.
#' 
#' -   First character must be a letter.
#' 
#' -   Must not contain a colon ( : ) or slash ( / ).
#' 
#' -   Cannot be a reserved word. A list of reserved words can be found in
#'     [Reserved
#'     Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
#'     in the Amazon Redshift Database Developer Guide.
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the cluster that contains the database for
#' which your are requesting credentials. This parameter is case sensitive.
#' @param DurationSeconds The number of seconds until the returned temporary password expires.
#' 
#' Constraint: minimum 900, maximum 3600.
#' 
#' Default: 900
#' @param AutoCreate Create a database user with the name specified for the user named in
#' `DbUser` if one does not exist.
#' @param DbGroups A list of the names of existing database groups that the user named in
#' `DbUser` will join for the current session, in addition to any group
#' memberships for an existing user. If not specified, a new user is added
#' only to PUBLIC.
#' 
#' Database group name constraints
#' 
#' -   Must be 1 to 64 alphanumeric characters or hyphens
#' 
#' -   Must contain only lowercase letters, numbers, underscore, plus sign,
#'     period (dot), at symbol (@@), or hyphen.
#' 
#' -   First character must be a letter.
#' 
#' -   Must not contain a colon ( : ) or slash ( / ).
#' 
#' -   Cannot be a reserved word. A list of reserved words can be found in
#'     [Reserved
#'     Words](https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
#'     in the Amazon Redshift Database Developer Guide.
#'
#' @section Request syntax:
#' ```
#' svc$get_cluster_credentials(
#'   DbUser = "string",
#'   DbName = "string",
#'   ClusterIdentifier = "string",
#'   DurationSeconds = 123,
#'   AutoCreate = TRUE|FALSE,
#'   DbGroups = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_get_cluster_credentials
redshift_get_cluster_credentials <- function(DbUser, DbName = NULL, ClusterIdentifier, DurationSeconds = NULL, AutoCreate = NULL, DbGroups = NULL) {
  op <- new_operation(
    name = "GetClusterCredentials",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$get_cluster_credentials_input(DbUser = DbUser, DbName = DbName, ClusterIdentifier = ClusterIdentifier, DurationSeconds = DurationSeconds, AutoCreate = AutoCreate, DbGroups = DbGroups)
  output <- .redshift$get_cluster_credentials_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$get_cluster_credentials <- redshift_get_cluster_credentials

#' Returns an array of DC2 ReservedNodeOfferings that matches the payment
#' type, term, and usage price of the given DC1 reserved node
#'
#' @description
#' Returns an array of DC2 ReservedNodeOfferings that matches the payment
#' type, term, and usage price of the given DC1 reserved node.
#'
#' @usage
#' redshift_get_reserved_node_exchange_offerings(ReservedNodeId,
#'   MaxRecords, Marker)
#'
#' @param ReservedNodeId &#91;required&#93; A string representing the node identifier for the DC1 Reserved Node to
#' be exchanged.
#' @param MaxRecords An integer setting the maximum number of ReservedNodeOfferings to
#' retrieve.
#' @param Marker A value that indicates the starting point for the next set of
#' ReservedNodeOfferings.
#'
#' @section Request syntax:
#' ```
#' svc$get_reserved_node_exchange_offerings(
#'   ReservedNodeId = "string",
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_get_reserved_node_exchange_offerings
redshift_get_reserved_node_exchange_offerings <- function(ReservedNodeId, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetReservedNodeExchangeOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$get_reserved_node_exchange_offerings_input(ReservedNodeId = ReservedNodeId, MaxRecords = MaxRecords, Marker = Marker)
  output <- .redshift$get_reserved_node_exchange_offerings_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$get_reserved_node_exchange_offerings <- redshift_get_reserved_node_exchange_offerings

#' Modifies the settings for a cluster
#'
#' @description
#' Modifies the settings for a cluster.
#' 
#' You can also change node type and the number of nodes to scale up or
#' down the cluster. When resizing a cluster, you must specify both the
#' number of nodes and the node type even if one of the parameters does not
#' change.
#' 
#' You can add another security or parameter group, or change the master
#' user password. Resetting a cluster password or modifying the security
#' groups associated with a cluster do not need a reboot. However,
#' modifying a parameter group requires a reboot for parameters to take
#' effect. For more information about managing clusters, go to [Amazon
#' Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_modify_cluster(ClusterIdentifier, ClusterType, NodeType,
#'   NumberOfNodes, ClusterSecurityGroups, VpcSecurityGroupIds,
#'   MasterUserPassword, ClusterParameterGroupName,
#'   AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod,
#'   PreferredMaintenanceWindow, ClusterVersion, AllowVersionUpgrade,
#'   HsmClientCertificateIdentifier, HsmConfigurationIdentifier,
#'   NewClusterIdentifier, PubliclyAccessible, ElasticIp, EnhancedVpcRouting,
#'   MaintenanceTrackName, Encrypted, KmsKeyId, AvailabilityZoneRelocation,
#'   AvailabilityZone, Port)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the cluster to be modified.
#' 
#' Example: `examplecluster`
#' @param ClusterType The new cluster type.
#' 
#' When you submit your cluster resize request, your existing cluster goes
#' into a read-only mode. After Amazon Redshift provisions a new cluster
#' based on your resize requirements, there will be outage for a period
#' while the old cluster is deleted and your connection is switched to the
#' new cluster. You can use DescribeResize to track the progress of the
#' resize request.
#' 
#' Valid Values: ` multi-node | single-node `
#' @param NodeType The new node type of the cluster. If you specify a new node type, you
#' must also specify the number of nodes parameter.
#' 
#' For more information about resizing clusters, go to [Resizing Clusters
#' in Amazon
#' Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-operations.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' Valid Values: `ds2.xlarge` | `ds2.8xlarge` | `dc1.large` | `dc1.8xlarge`
#' | `dc2.large` | `dc2.8xlarge` | `ra3.xlplus` | `ra3.4xlarge` |
#' `ra3.16xlarge`
#' @param NumberOfNodes The new number of nodes of the cluster. If you specify a new number of
#' nodes, you must also specify the node type parameter.
#' 
#' For more information about resizing clusters, go to [Resizing Clusters
#' in Amazon
#' Redshift](https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-operations.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' Valid Values: Integer greater than `0`.
#' @param ClusterSecurityGroups A list of cluster security groups to be authorized on this cluster. This
#' change is asynchronously applied as soon as possible.
#' 
#' Security groups currently associated with the cluster, and not in the
#' list of groups to apply, will be revoked from the cluster.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens
#' @param VpcSecurityGroupIds A list of virtual private cloud (VPC) security groups to be associated
#' with the cluster. This change is asynchronously applied as soon as
#' possible.
#' @param MasterUserPassword The new password for the cluster master user. This change is
#' asynchronously applied as soon as possible. Between the time of the
#' request and the completion of the request, the `MasterUserPassword`
#' element exists in the `PendingModifiedValues` element of the operation
#' response.
#' 
#' Operations never return the password, so this operation provides a way
#' to regain access to the master user account for a cluster if the
#' password is lost.
#' 
#' Default: Uses existing setting.
#' 
#' Constraints:
#' 
#' -   Must be between 8 and 64 characters in length.
#' 
#' -   Must contain at least one uppercase letter.
#' 
#' -   Must contain at least one lowercase letter.
#' 
#' -   Must contain one number.
#' 
#' -   Can be any printable ASCII character (ASCII code 33 to 126) except '
#'     (single quote), " (double quote), \\, /, @@, or space.
#' @param ClusterParameterGroupName The name of the cluster parameter group to apply to this cluster. This
#' change is applied only after the cluster is rebooted. To reboot a
#' cluster use RebootCluster.
#' 
#' Default: Uses existing setting.
#' 
#' Constraints: The cluster parameter group must be in the same parameter
#' group family that matches the cluster version.
#' @param AutomatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. If the value
#' is 0, automated snapshots are disabled. Even if automated snapshots are
#' disabled, you can still create manual snapshots when you want with
#' CreateClusterSnapshot.
#' 
#' If you decrease the automated snapshot retention period from its current
#' value, existing automated snapshots that fall outside of the new
#' retention period will be immediately deleted.
#' 
#' Default: Uses existing setting.
#' 
#' Constraints: Must be a value from 0 to 35.
#' @param ManualSnapshotRetentionPeriod The default for number of days that a newly created manual snapshot is
#' retained. If the value is -1, the manual snapshot is retained
#' indefinitely. This value doesn't retroactively change the retention
#' periods of existing manual snapshots.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' 
#' The default value is -1.
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can
#' occur, if necessary. If system maintenance is necessary during the
#' window, it may result in an outage.
#' 
#' This maintenance window change is made immediately. If the new
#' maintenance window indicates the current time, there must be at least
#' 120 minutes between the current time and end of the window in order to
#' ensure that pending changes are applied.
#' 
#' Default: Uses existing setting.
#' 
#' Format: ddd:hh24:mi-ddd:hh24:mi, for example `wed:07:30-wed:08:00`.
#' 
#' Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
#' 
#' Constraints: Must be at least 30 minutes.
#' @param ClusterVersion The new version number of the Amazon Redshift engine to upgrade to.
#' 
#' For major version upgrades, if a non-default cluster parameter group is
#' currently in use, a new cluster parameter group in the cluster parameter
#' group family for the new version must be specified. The new cluster
#' parameter group can be the default for that cluster parameter group
#' family. For more information about parameters and parameter groups, go
#' to [Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#' 
#' Example: `1.0`
#' @param AllowVersionUpgrade If `true`, major version upgrades will be applied automatically to the
#' cluster during the maintenance window.
#' 
#' Default: `false`
#' @param HsmClientCertificateIdentifier Specifies the name of the HSM client certificate the Amazon Redshift
#' cluster uses to retrieve the data encryption keys stored in an HSM.
#' @param HsmConfigurationIdentifier Specifies the name of the HSM configuration that contains the
#' information the Amazon Redshift cluster can use to retrieve and store
#' keys in an HSM.
#' @param NewClusterIdentifier The new identifier for the cluster.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   Alphabetic characters must be lowercase.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Must be unique for all clusters within an AWS account.
#' 
#' Example: `examplecluster`
#' @param PubliclyAccessible If `true`, the cluster can be accessed from a public network. Only
#' clusters in VPCs can be set to be publicly available.
#' @param ElasticIp The Elastic IP (EIP) address for the cluster.
#' 
#' Constraints: The cluster must be provisioned in EC2-VPC and
#' publicly-accessible through an Internet gateway. For more information
#' about provisioning clusters in EC2-VPC, go to [Supported Platforms to
#' Launch Your
#' Cluster](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms)
#' in the Amazon Redshift Cluster Management Guide.
#' @param EnhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC
#' routing enabled. To create a cluster that uses enhanced VPC routing, the
#' cluster must be in a VPC. For more information, see [Enhanced VPC
#' Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
#' in the Amazon Redshift Cluster Management Guide.
#' 
#' If this option is `true`, enhanced VPC routing is enabled.
#' 
#' Default: false
#' @param MaintenanceTrackName The name for the maintenance track that you want to assign for the
#' cluster. This name change is asynchronous. The new track name stays in
#' the `PendingModifiedValues` for the cluster until the next maintenance
#' window. When the maintenance track changes, the cluster is switched to
#' the latest cluster release available for the maintenance track. At this
#' point, the maintenance track name is applied.
#' @param Encrypted Indicates whether the cluster is encrypted. If the value is encrypted
#' (true) and you provide a value for the `KmsKeyId` parameter, we encrypt
#' the cluster with the provided `KmsKeyId`. If you don't provide a
#' `KmsKeyId`, we encrypt with the default key.
#' 
#' If the value is not encrypted (false), then the cluster is decrypted.
#' @param KmsKeyId The AWS Key Management Service (KMS) key ID of the encryption key that
#' you want to use to encrypt data in the cluster.
#' @param AvailabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between
#' Availability Zones after the cluster modification is complete.
#' @param AvailabilityZone The option to initiate relocation for an Amazon Redshift cluster to the
#' target Availability Zone.
#' @param Port The option to change the port of an Amazon Redshift cluster.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster(
#'   ClusterIdentifier = "string",
#'   ClusterType = "string",
#'   NodeType = "string",
#'   NumberOfNodes = 123,
#'   ClusterSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   MasterUserPassword = "string",
#'   ClusterParameterGroupName = "string",
#'   AutomatedSnapshotRetentionPeriod = 123,
#'   ManualSnapshotRetentionPeriod = 123,
#'   PreferredMaintenanceWindow = "string",
#'   ClusterVersion = "string",
#'   AllowVersionUpgrade = TRUE|FALSE,
#'   HsmClientCertificateIdentifier = "string",
#'   HsmConfigurationIdentifier = "string",
#'   NewClusterIdentifier = "string",
#'   PubliclyAccessible = TRUE|FALSE,
#'   ElasticIp = "string",
#'   EnhancedVpcRouting = TRUE|FALSE,
#'   MaintenanceTrackName = "string",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   AvailabilityZoneRelocation = TRUE|FALSE,
#'   AvailabilityZone = "string",
#'   Port = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster
redshift_modify_cluster <- function(ClusterIdentifier, ClusterType = NULL, NodeType = NULL, NumberOfNodes = NULL, ClusterSecurityGroups = NULL, VpcSecurityGroupIds = NULL, MasterUserPassword = NULL, ClusterParameterGroupName = NULL, AutomatedSnapshotRetentionPeriod = NULL, ManualSnapshotRetentionPeriod = NULL, PreferredMaintenanceWindow = NULL, ClusterVersion = NULL, AllowVersionUpgrade = NULL, HsmClientCertificateIdentifier = NULL, HsmConfigurationIdentifier = NULL, NewClusterIdentifier = NULL, PubliclyAccessible = NULL, ElasticIp = NULL, EnhancedVpcRouting = NULL, MaintenanceTrackName = NULL, Encrypted = NULL, KmsKeyId = NULL, AvailabilityZoneRelocation = NULL, AvailabilityZone = NULL, Port = NULL) {
  op <- new_operation(
    name = "ModifyCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_input(ClusterIdentifier = ClusterIdentifier, ClusterType = ClusterType, NodeType = NodeType, NumberOfNodes = NumberOfNodes, ClusterSecurityGroups = ClusterSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, MasterUserPassword = MasterUserPassword, ClusterParameterGroupName = ClusterParameterGroupName, AutomatedSnapshotRetentionPeriod = AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod, PreferredMaintenanceWindow = PreferredMaintenanceWindow, ClusterVersion = ClusterVersion, AllowVersionUpgrade = AllowVersionUpgrade, HsmClientCertificateIdentifier = HsmClientCertificateIdentifier, HsmConfigurationIdentifier = HsmConfigurationIdentifier, NewClusterIdentifier = NewClusterIdentifier, PubliclyAccessible = PubliclyAccessible, ElasticIp = ElasticIp, EnhancedVpcRouting = EnhancedVpcRouting, MaintenanceTrackName = MaintenanceTrackName, Encrypted = Encrypted, KmsKeyId = KmsKeyId, AvailabilityZoneRelocation = AvailabilityZoneRelocation, AvailabilityZone = AvailabilityZone, Port = Port)
  output <- .redshift$modify_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster <- redshift_modify_cluster

#' Modifies the database revision of a cluster
#'
#' @description
#' Modifies the database revision of a cluster. The database revision is a
#' unique revision of the database running in a cluster.
#'
#' @usage
#' redshift_modify_cluster_db_revision(ClusterIdentifier, RevisionTarget)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of a cluster whose database revision you want to
#' modify.
#' 
#' Example: `examplecluster`
#' @param RevisionTarget &#91;required&#93; The identifier of the database revision. You can retrieve this value
#' from the response to the DescribeClusterDbRevisions request.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_db_revision(
#'   ClusterIdentifier = "string",
#'   RevisionTarget = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_db_revision
redshift_modify_cluster_db_revision <- function(ClusterIdentifier, RevisionTarget) {
  op <- new_operation(
    name = "ModifyClusterDbRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_db_revision_input(ClusterIdentifier = ClusterIdentifier, RevisionTarget = RevisionTarget)
  output <- .redshift$modify_cluster_db_revision_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_db_revision <- redshift_modify_cluster_db_revision

#' Modifies the list of AWS Identity and Access Management (IAM) roles that
#' can be used by the cluster to access other AWS services
#'
#' @description
#' Modifies the list of AWS Identity and Access Management (IAM) roles that
#' can be used by the cluster to access other AWS services.
#' 
#' A cluster can have up to 10 IAM roles associated at any time.
#'
#' @usage
#' redshift_modify_cluster_iam_roles(ClusterIdentifier, AddIamRoles,
#'   RemoveIamRoles)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the cluster for which you want to associate or
#' disassociate IAM roles.
#' @param AddIamRoles Zero or more IAM roles to associate with the cluster. The roles must be
#' in their Amazon Resource Name (ARN) format. You can associate up to 10
#' IAM roles with a single cluster in a single request.
#' @param RemoveIamRoles Zero or more IAM roles in ARN format to disassociate from the cluster.
#' You can disassociate up to 10 IAM roles from a single cluster in a
#' single request.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_iam_roles(
#'   ClusterIdentifier = "string",
#'   AddIamRoles = list(
#'     "string"
#'   ),
#'   RemoveIamRoles = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_iam_roles
redshift_modify_cluster_iam_roles <- function(ClusterIdentifier, AddIamRoles = NULL, RemoveIamRoles = NULL) {
  op <- new_operation(
    name = "ModifyClusterIamRoles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_iam_roles_input(ClusterIdentifier = ClusterIdentifier, AddIamRoles = AddIamRoles, RemoveIamRoles = RemoveIamRoles)
  output <- .redshift$modify_cluster_iam_roles_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_iam_roles <- redshift_modify_cluster_iam_roles

#' Modifies the maintenance settings of a cluster
#'
#' @description
#' Modifies the maintenance settings of a cluster.
#'
#' @usage
#' redshift_modify_cluster_maintenance(ClusterIdentifier, DeferMaintenance,
#'   DeferMaintenanceIdentifier, DeferMaintenanceStartTime,
#'   DeferMaintenanceEndTime, DeferMaintenanceDuration)
#'
#' @param ClusterIdentifier &#91;required&#93; A unique identifier for the cluster.
#' @param DeferMaintenance A boolean indicating whether to enable the deferred maintenance window.
#' @param DeferMaintenanceIdentifier A unique identifier for the deferred maintenance window.
#' @param DeferMaintenanceStartTime A timestamp indicating the start time for the deferred maintenance
#' window.
#' @param DeferMaintenanceEndTime A timestamp indicating end time for the deferred maintenance window. If
#' you specify an end time, you can't specify a duration.
#' @param DeferMaintenanceDuration An integer indicating the duration of the maintenance window in days. If
#' you specify a duration, you can't specify an end time. The duration must
#' be 45 days or less.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_maintenance(
#'   ClusterIdentifier = "string",
#'   DeferMaintenance = TRUE|FALSE,
#'   DeferMaintenanceIdentifier = "string",
#'   DeferMaintenanceStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DeferMaintenanceEndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DeferMaintenanceDuration = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_maintenance
redshift_modify_cluster_maintenance <- function(ClusterIdentifier, DeferMaintenance = NULL, DeferMaintenanceIdentifier = NULL, DeferMaintenanceStartTime = NULL, DeferMaintenanceEndTime = NULL, DeferMaintenanceDuration = NULL) {
  op <- new_operation(
    name = "ModifyClusterMaintenance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_maintenance_input(ClusterIdentifier = ClusterIdentifier, DeferMaintenance = DeferMaintenance, DeferMaintenanceIdentifier = DeferMaintenanceIdentifier, DeferMaintenanceStartTime = DeferMaintenanceStartTime, DeferMaintenanceEndTime = DeferMaintenanceEndTime, DeferMaintenanceDuration = DeferMaintenanceDuration)
  output <- .redshift$modify_cluster_maintenance_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_maintenance <- redshift_modify_cluster_maintenance

#' Modifies the parameters of a parameter group
#'
#' @description
#' Modifies the parameters of a parameter group.
#' 
#' For more information about parameters and parameter groups, go to
#' [Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_modify_cluster_parameter_group(ParameterGroupName, Parameters)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the parameter group to be modified.
#' @param Parameters &#91;required&#93; An array of parameters to be modified. A maximum of 20 parameters can be
#' modified in a single request.
#' 
#' For each parameter to be modified, you must supply at least the
#' parameter name and parameter value; other name-value pairs of the
#' parameter are optional.
#' 
#' For the workload management (WLM) configuration, you must supply all the
#' name-value pairs in the wlm\\_json\\_configuration parameter.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_parameter_group(
#'   ParameterGroupName = "string",
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       ApplyType = "static"|"dynamic",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_parameter_group
redshift_modify_cluster_parameter_group <- function(ParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_parameter_group_input(ParameterGroupName = ParameterGroupName, Parameters = Parameters)
  output <- .redshift$modify_cluster_parameter_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_parameter_group <- redshift_modify_cluster_parameter_group

#' Modifies the settings for a snapshot
#'
#' @description
#' Modifies the settings for a snapshot.
#' 
#' This exanmple modifies the manual retention period setting for a cluster
#' snapshot.
#'
#' @usage
#' redshift_modify_cluster_snapshot(SnapshotIdentifier,
#'   ManualSnapshotRetentionPeriod, Force)
#'
#' @param SnapshotIdentifier &#91;required&#93; The identifier of the snapshot whose setting you want to modify.
#' @param ManualSnapshotRetentionPeriod The number of days that a manual snapshot is retained. If the value is
#' -1, the manual snapshot is retained indefinitely.
#' 
#' If the manual snapshot falls outside of the new retention period, you
#' can specify the force option to immediately delete the snapshot.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' @param Force A Boolean option to override an exception if the retention period has
#' already passed.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_snapshot(
#'   SnapshotIdentifier = "string",
#'   ManualSnapshotRetentionPeriod = 123,
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_snapshot
redshift_modify_cluster_snapshot <- function(SnapshotIdentifier, ManualSnapshotRetentionPeriod = NULL, Force = NULL) {
  op <- new_operation(
    name = "ModifyClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_snapshot_input(SnapshotIdentifier = SnapshotIdentifier, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod, Force = Force)
  output <- .redshift$modify_cluster_snapshot_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_snapshot <- redshift_modify_cluster_snapshot

#' Modifies a snapshot schedule for a cluster
#'
#' @description
#' Modifies a snapshot schedule for a cluster.
#'
#' @usage
#' redshift_modify_cluster_snapshot_schedule(ClusterIdentifier,
#'   ScheduleIdentifier, DisassociateSchedule)
#'
#' @param ClusterIdentifier &#91;required&#93; A unique identifier for the cluster whose snapshot schedule you want to
#' modify.
#' @param ScheduleIdentifier A unique alphanumeric identifier for the schedule that you want to
#' associate with the cluster.
#' @param DisassociateSchedule A boolean to indicate whether to remove the assoiciation between the
#' cluster and the schedule.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_snapshot_schedule(
#'   ClusterIdentifier = "string",
#'   ScheduleIdentifier = "string",
#'   DisassociateSchedule = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_snapshot_schedule
redshift_modify_cluster_snapshot_schedule <- function(ClusterIdentifier, ScheduleIdentifier = NULL, DisassociateSchedule = NULL) {
  op <- new_operation(
    name = "ModifyClusterSnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_snapshot_schedule_input(ClusterIdentifier = ClusterIdentifier, ScheduleIdentifier = ScheduleIdentifier, DisassociateSchedule = DisassociateSchedule)
  output <- .redshift$modify_cluster_snapshot_schedule_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_snapshot_schedule <- redshift_modify_cluster_snapshot_schedule

#' Modifies a cluster subnet group to include the specified list of VPC
#' subnets
#'
#' @description
#' Modifies a cluster subnet group to include the specified list of VPC
#' subnets. The operation replaces the existing list of subnets with the
#' new list of subnets.
#'
#' @usage
#' redshift_modify_cluster_subnet_group(ClusterSubnetGroupName,
#'   Description, SubnetIds)
#'
#' @param ClusterSubnetGroupName &#91;required&#93; The name of the subnet group to be modified.
#' @param Description A text description of the subnet group to be modified.
#' @param SubnetIds &#91;required&#93; An array of VPC subnet IDs. A maximum of 20 subnets can be modified in a
#' single request.
#'
#' @section Request syntax:
#' ```
#' svc$modify_cluster_subnet_group(
#'   ClusterSubnetGroupName = "string",
#'   Description = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_cluster_subnet_group
redshift_modify_cluster_subnet_group <- function(ClusterSubnetGroupName, Description = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyClusterSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_cluster_subnet_group_input(ClusterSubnetGroupName = ClusterSubnetGroupName, Description = Description, SubnetIds = SubnetIds)
  output <- .redshift$modify_cluster_subnet_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_cluster_subnet_group <- redshift_modify_cluster_subnet_group

#' Modifies an existing Amazon Redshift event notification subscription
#'
#' @description
#' Modifies an existing Amazon Redshift event notification subscription.
#'
#' @usage
#' redshift_modify_event_subscription(SubscriptionName, SnsTopicArn,
#'   SourceType, SourceIds, EventCategories, Severity, Enabled)
#'
#' @param SubscriptionName &#91;required&#93; The name of the modified Amazon Redshift event notification
#' subscription.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the SNS topic to be used by the event
#' notification subscription.
#' @param SourceType The type of source that will be generating the events. For example, if
#' you want to be notified of events generated by a cluster, you would set
#' this parameter to cluster. If this value is not specified, events are
#' returned for all Amazon Redshift objects in your AWS account. You must
#' specify a source type in order to specify source IDs.
#' 
#' Valid values: cluster, cluster-parameter-group, cluster-security-group,
#' cluster-snapshot, and scheduled-action.
#' @param SourceIds A list of one or more identifiers of Amazon Redshift source objects. All
#' of the objects must be of the same type as was specified in the source
#' type parameter. The event subscription will return only events generated
#' by the specified objects. If not specified, then events are returned for
#' all objects within the source type specified.
#' 
#' Example: my-cluster-1, my-cluster-2
#' 
#' Example: my-snapshot-20131010
#' @param EventCategories Specifies the Amazon Redshift event categories to be published by the
#' event notification subscription.
#' 
#' Values: configuration, management, monitoring, security
#' @param Severity Specifies the Amazon Redshift event severity to be published by the
#' event notification subscription.
#' 
#' Values: ERROR, INFO
#' @param Enabled A Boolean value indicating if the subscription is enabled. `true`
#' indicates the subscription is enabled
#'
#' @section Request syntax:
#' ```
#' svc$modify_event_subscription(
#'   SubscriptionName = "string",
#'   SnsTopicArn = "string",
#'   SourceType = "string",
#'   SourceIds = list(
#'     "string"
#'   ),
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Severity = "string",
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_event_subscription
redshift_modify_event_subscription <- function(SubscriptionName, SnsTopicArn = NULL, SourceType = NULL, SourceIds = NULL, EventCategories = NULL, Severity = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "ModifyEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, SourceIds = SourceIds, EventCategories = EventCategories, Severity = Severity, Enabled = Enabled)
  output <- .redshift$modify_event_subscription_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_event_subscription <- redshift_modify_event_subscription

#' Modifies a scheduled action
#'
#' @description
#' Modifies a scheduled action.
#'
#' @usage
#' redshift_modify_scheduled_action(ScheduledActionName, TargetAction,
#'   Schedule, IamRole, ScheduledActionDescription, StartTime, EndTime,
#'   Enable)
#'
#' @param ScheduledActionName &#91;required&#93; The name of the scheduled action to modify.
#' @param TargetAction A modified JSON format of the scheduled action. For more information
#' about this parameter, see ScheduledAction.
#' @param Schedule A modified schedule in either `at( )` or `cron( )` format. For more
#' information about this parameter, see ScheduledAction.
#' @param IamRole A different IAM role to assume to run the target action. For more
#' information about this parameter, see ScheduledAction.
#' @param ScheduledActionDescription A modified description of the scheduled action.
#' @param StartTime A modified start time of the scheduled action. For more information
#' about this parameter, see ScheduledAction.
#' @param EndTime A modified end time of the scheduled action. For more information about
#' this parameter, see ScheduledAction.
#' @param Enable A modified enable flag of the scheduled action. If true, the scheduled
#' action is active. If false, the scheduled action is disabled.
#'
#' @section Request syntax:
#' ```
#' svc$modify_scheduled_action(
#'   ScheduledActionName = "string",
#'   TargetAction = list(
#'     ResizeCluster = list(
#'       ClusterIdentifier = "string",
#'       ClusterType = "string",
#'       NodeType = "string",
#'       NumberOfNodes = 123,
#'       Classic = TRUE|FALSE
#'     ),
#'     PauseCluster = list(
#'       ClusterIdentifier = "string"
#'     ),
#'     ResumeCluster = list(
#'       ClusterIdentifier = "string"
#'     )
#'   ),
#'   Schedule = "string",
#'   IamRole = "string",
#'   ScheduledActionDescription = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Enable = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_scheduled_action
redshift_modify_scheduled_action <- function(ScheduledActionName, TargetAction = NULL, Schedule = NULL, IamRole = NULL, ScheduledActionDescription = NULL, StartTime = NULL, EndTime = NULL, Enable = NULL) {
  op <- new_operation(
    name = "ModifyScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_scheduled_action_input(ScheduledActionName = ScheduledActionName, TargetAction = TargetAction, Schedule = Schedule, IamRole = IamRole, ScheduledActionDescription = ScheduledActionDescription, StartTime = StartTime, EndTime = EndTime, Enable = Enable)
  output <- .redshift$modify_scheduled_action_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_scheduled_action <- redshift_modify_scheduled_action

#' Modifies the number of days to retain snapshots in the destination AWS
#' Region after they are copied from the source AWS Region
#'
#' @description
#' Modifies the number of days to retain snapshots in the destination AWS
#' Region after they are copied from the source AWS Region. By default,
#' this operation only changes the retention period of copied automated
#' snapshots. The retention periods for both new and existing copied
#' automated snapshots are updated with the new retention period. You can
#' set the manual option to change only the retention periods of copied
#' manual snapshots. If you set this option, only newly copied manual
#' snapshots have the new retention period.
#'
#' @usage
#' redshift_modify_snapshot_copy_retention_period(ClusterIdentifier,
#'   RetentionPeriod, Manual)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the cluster for which you want to change the
#' retention period for either automated or manual snapshots that are
#' copied to a destination AWS Region.
#' 
#' Constraints: Must be the valid name of an existing cluster that has
#' cross-region snapshot copy enabled.
#' @param RetentionPeriod &#91;required&#93; The number of days to retain automated snapshots in the destination AWS
#' Region after they are copied from the source AWS Region.
#' 
#' By default, this only changes the retention period of copied automated
#' snapshots.
#' 
#' If you decrease the retention period for automated snapshots that are
#' copied to a destination AWS Region, Amazon Redshift deletes any existing
#' automated snapshots that were copied to the destination AWS Region and
#' that fall outside of the new retention period.
#' 
#' Constraints: Must be at least 1 and no more than 35 for automated
#' snapshots.
#' 
#' If you specify the `manual` option, only newly copied manual snapshots
#' will have the new retention period.
#' 
#' If you specify the value of -1 newly copied manual snapshots are
#' retained indefinitely.
#' 
#' Constraints: The number of days must be either -1 or an integer between
#' 1 and 3,653 for manual snapshots.
#' @param Manual Indicates whether to apply the snapshot retention period to newly copied
#' manual snapshots instead of automated snapshots.
#'
#' @section Request syntax:
#' ```
#' svc$modify_snapshot_copy_retention_period(
#'   ClusterIdentifier = "string",
#'   RetentionPeriod = 123,
#'   Manual = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_snapshot_copy_retention_period
redshift_modify_snapshot_copy_retention_period <- function(ClusterIdentifier, RetentionPeriod, Manual = NULL) {
  op <- new_operation(
    name = "ModifySnapshotCopyRetentionPeriod",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_snapshot_copy_retention_period_input(ClusterIdentifier = ClusterIdentifier, RetentionPeriod = RetentionPeriod, Manual = Manual)
  output <- .redshift$modify_snapshot_copy_retention_period_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_snapshot_copy_retention_period <- redshift_modify_snapshot_copy_retention_period

#' Modifies a snapshot schedule
#'
#' @description
#' Modifies a snapshot schedule. Any schedule associated with a cluster is
#' modified asynchronously.
#'
#' @usage
#' redshift_modify_snapshot_schedule(ScheduleIdentifier,
#'   ScheduleDefinitions)
#'
#' @param ScheduleIdentifier &#91;required&#93; A unique alphanumeric identifier of the schedule to modify.
#' @param ScheduleDefinitions &#91;required&#93; An updated list of schedule definitions. A schedule definition is made
#' up of schedule expressions, for example, "cron(30 12 *)" or "rate(12
#' hours)".
#'
#' @section Request syntax:
#' ```
#' svc$modify_snapshot_schedule(
#'   ScheduleIdentifier = "string",
#'   ScheduleDefinitions = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_snapshot_schedule
redshift_modify_snapshot_schedule <- function(ScheduleIdentifier, ScheduleDefinitions) {
  op <- new_operation(
    name = "ModifySnapshotSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_snapshot_schedule_input(ScheduleIdentifier = ScheduleIdentifier, ScheduleDefinitions = ScheduleDefinitions)
  output <- .redshift$modify_snapshot_schedule_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_snapshot_schedule <- redshift_modify_snapshot_schedule

#' Modifies a usage limit in a cluster
#'
#' @description
#' Modifies a usage limit in a cluster. You can't modify the feature type
#' or period of a usage limit.
#'
#' @usage
#' redshift_modify_usage_limit(UsageLimitId, Amount, BreachAction)
#'
#' @param UsageLimitId &#91;required&#93; The identifier of the usage limit to modify.
#' @param Amount The new limit amount. For more information about this parameter, see
#' UsageLimit.
#' @param BreachAction The new action that Amazon Redshift takes when the limit is reached. For
#' more information about this parameter, see UsageLimit.
#'
#' @section Request syntax:
#' ```
#' svc$modify_usage_limit(
#'   UsageLimitId = "string",
#'   Amount = 123,
#'   BreachAction = "log"|"emit-metric"|"disable"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_modify_usage_limit
redshift_modify_usage_limit <- function(UsageLimitId, Amount = NULL, BreachAction = NULL) {
  op <- new_operation(
    name = "ModifyUsageLimit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$modify_usage_limit_input(UsageLimitId = UsageLimitId, Amount = Amount, BreachAction = BreachAction)
  output <- .redshift$modify_usage_limit_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$modify_usage_limit <- redshift_modify_usage_limit

#' Pauses a cluster
#'
#' @description
#' Pauses a cluster.
#'
#' @usage
#' redshift_pause_cluster(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster to be paused.
#'
#' @section Request syntax:
#' ```
#' svc$pause_cluster(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_pause_cluster
redshift_pause_cluster <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "PauseCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$pause_cluster_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$pause_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$pause_cluster <- redshift_pause_cluster

#' Allows you to purchase reserved nodes
#'
#' @description
#' Allows you to purchase reserved nodes. Amazon Redshift offers a
#' predefined set of reserved node offerings. You can purchase one or more
#' of the offerings. You can call the DescribeReservedNodeOfferings API to
#' obtain the available reserved node offerings. You can call this API by
#' providing a specific reserved node offering and the number of nodes you
#' want to reserve.
#' 
#' For more information about reserved node offerings, go to [Purchasing
#' Reserved
#' Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/purchase-reserved-node-instance.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_purchase_reserved_node_offering(ReservedNodeOfferingId,
#'   NodeCount)
#'
#' @param ReservedNodeOfferingId &#91;required&#93; The unique identifier of the reserved node offering you want to
#' purchase.
#' @param NodeCount The number of reserved nodes that you want to purchase.
#' 
#' Default: `1`
#'
#' @section Request syntax:
#' ```
#' svc$purchase_reserved_node_offering(
#'   ReservedNodeOfferingId = "string",
#'   NodeCount = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_purchase_reserved_node_offering
redshift_purchase_reserved_node_offering <- function(ReservedNodeOfferingId, NodeCount = NULL) {
  op <- new_operation(
    name = "PurchaseReservedNodeOffering",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$purchase_reserved_node_offering_input(ReservedNodeOfferingId = ReservedNodeOfferingId, NodeCount = NodeCount)
  output <- .redshift$purchase_reserved_node_offering_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$purchase_reserved_node_offering <- redshift_purchase_reserved_node_offering

#' Reboots a cluster
#'
#' @description
#' Reboots a cluster. This action is taken as soon as possible. It results
#' in a momentary outage to the cluster, during which the cluster status is
#' set to `rebooting`. A cluster event is created when the reboot is
#' completed. Any pending cluster modifications (see ModifyCluster) are
#' applied at this reboot. For more information about managing clusters, go
#' to [Amazon Redshift
#' Clusters](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_reboot_cluster(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The cluster identifier.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_cluster(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_reboot_cluster
redshift_reboot_cluster <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "RebootCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$reboot_cluster_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$reboot_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$reboot_cluster <- redshift_reboot_cluster

#' Sets one or more parameters of the specified parameter group to their
#' default values and sets the source values of the parameters to
#' "engine-default"
#'
#' @description
#' Sets one or more parameters of the specified parameter group to their
#' default values and sets the source values of the parameters to
#' "engine-default". To reset the entire parameter group specify the
#' *ResetAllParameters* parameter. For parameter changes to take effect you
#' must reboot any associated clusters.
#'
#' @usage
#' redshift_reset_cluster_parameter_group(ParameterGroupName,
#'   ResetAllParameters, Parameters)
#'
#' @param ParameterGroupName &#91;required&#93; The name of the cluster parameter group to be reset.
#' @param ResetAllParameters If `true`, all parameters in the specified parameter group will be reset
#' to their default values.
#' 
#' Default: `true`
#' @param Parameters An array of names of parameters to be reset. If *ResetAllParameters*
#' option is not used, then at least one parameter name must be supplied.
#' 
#' Constraints: A maximum of 20 parameters can be reset in a single
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$reset_cluster_parameter_group(
#'   ParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       ApplyType = "static"|"dynamic",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_reset_cluster_parameter_group
redshift_reset_cluster_parameter_group <- function(ParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$reset_cluster_parameter_group_input(ParameterGroupName = ParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .redshift$reset_cluster_parameter_group_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$reset_cluster_parameter_group <- redshift_reset_cluster_parameter_group

#' Changes the size of the cluster
#'
#' @description
#' Changes the size of the cluster. You can change the cluster's type, or
#' change the number or type of nodes. The default behavior is to use the
#' elastic resize method. With an elastic resize, your cluster is available
#' for read and write operations more quickly than with the classic resize
#' method.
#' 
#' Elastic resize operations have the following restrictions:
#' 
#' -   You can only resize clusters of the following types:
#' 
#'     -   dc1.large (if your cluster is in a VPC)
#' 
#'     -   dc1.8xlarge (if your cluster is in a VPC)
#' 
#'     -   dc2.large
#' 
#'     -   dc2.8xlarge
#' 
#'     -   ds2.xlarge
#' 
#'     -   ds2.8xlarge
#' 
#'     -   ra3.xlplus
#' 
#'     -   ra3.4xlarge
#' 
#'     -   ra3.16xlarge
#' 
#' -   The type of nodes that you add must match the node type for the
#'     cluster.
#'
#' @usage
#' redshift_resize_cluster(ClusterIdentifier, ClusterType, NodeType,
#'   NumberOfNodes, Classic)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier for the cluster to resize.
#' @param ClusterType The new cluster type for the specified cluster.
#' @param NodeType The new node type for the nodes you are adding. If not specified, the
#' cluster's current node type is used.
#' @param NumberOfNodes The new number of nodes for the cluster. If not specified, the cluster's
#' current number of nodes is used.
#' @param Classic A boolean value indicating whether the resize operation is using the
#' classic resize process. If you don't provide this parameter or set the
#' value to `false`, the resize type is elastic.
#'
#' @section Request syntax:
#' ```
#' svc$resize_cluster(
#'   ClusterIdentifier = "string",
#'   ClusterType = "string",
#'   NodeType = "string",
#'   NumberOfNodes = 123,
#'   Classic = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_resize_cluster
redshift_resize_cluster <- function(ClusterIdentifier, ClusterType = NULL, NodeType = NULL, NumberOfNodes = NULL, Classic = NULL) {
  op <- new_operation(
    name = "ResizeCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$resize_cluster_input(ClusterIdentifier = ClusterIdentifier, ClusterType = ClusterType, NodeType = NodeType, NumberOfNodes = NumberOfNodes, Classic = Classic)
  output <- .redshift$resize_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$resize_cluster <- redshift_resize_cluster

#' Creates a new cluster from a snapshot
#'
#' @description
#' Creates a new cluster from a snapshot. By default, Amazon Redshift
#' creates the resulting cluster with the same configuration as the
#' original cluster from which the snapshot was created, except that the
#' new cluster is created with the default cluster security and parameter
#' groups. After Amazon Redshift creates the cluster, you can use the
#' ModifyCluster API to associate a different security group and different
#' parameter group with the restored cluster. If you are using a DS node
#' type, you can also choose to change to another DS node type of the same
#' size during restore.
#' 
#' If you restore a cluster into a VPC, you must provide a cluster subnet
#' group where you want the cluster restored.
#' 
#' For more information about working with snapshots, go to [Amazon
#' Redshift
#' Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_restore_from_cluster_snapshot(ClusterIdentifier,
#'   SnapshotIdentifier, SnapshotClusterIdentifier, Port, AvailabilityZone,
#'   AllowVersionUpgrade, ClusterSubnetGroupName, PubliclyAccessible,
#'   OwnerAccount, HsmClientCertificateIdentifier,
#'   HsmConfigurationIdentifier, ElasticIp, ClusterParameterGroupName,
#'   ClusterSecurityGroups, VpcSecurityGroupIds, PreferredMaintenanceWindow,
#'   AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod,
#'   KmsKeyId, NodeType, EnhancedVpcRouting, AdditionalInfo, IamRoles,
#'   MaintenanceTrackName, SnapshotScheduleIdentifier, NumberOfNodes,
#'   AvailabilityZoneRelocation)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster that will be created from restoring the
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   Alphabetic characters must be lowercase.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Must be unique for all clusters within an AWS account.
#' @param SnapshotIdentifier &#91;required&#93; The name of the snapshot from which to create the new cluster. This
#' parameter isn't case sensitive.
#' 
#' Example: `my-snapshot-id`
#' @param SnapshotClusterIdentifier The name of the cluster the source snapshot was created from. This
#' parameter is required if your IAM user has a policy containing a
#' snapshot resource element that specifies anything other than * for the
#' cluster name.
#' @param Port The port number on which the cluster accepts connections.
#' 
#' Default: The same port as the original cluster.
#' 
#' Constraints: Must be between `1115` and `65535`.
#' @param AvailabilityZone The Amazon EC2 Availability Zone in which to restore the cluster.
#' 
#' Default: A random, system-chosen Availability Zone.
#' 
#' Example: `us-east-2a`
#' @param AllowVersionUpgrade If `true`, major version upgrades can be applied during the maintenance
#' window to the Amazon Redshift engine that is running on the cluster.
#' 
#' Default: `true`
#' @param ClusterSubnetGroupName The name of the subnet group where you want to cluster restored.
#' 
#' A snapshot of cluster in VPC can be restored only in VPC. Therefore, you
#' must provide subnet group name where you want the cluster restored.
#' @param PubliclyAccessible If `true`, the cluster can be accessed from a public network.
#' @param OwnerAccount The AWS customer account used to create or copy the snapshot. Required
#' if you are restoring a snapshot you do not own, optional if you own the
#' snapshot.
#' @param HsmClientCertificateIdentifier Specifies the name of the HSM client certificate the Amazon Redshift
#' cluster uses to retrieve the data encryption keys stored in an HSM.
#' @param HsmConfigurationIdentifier Specifies the name of the HSM configuration that contains the
#' information the Amazon Redshift cluster can use to retrieve and store
#' keys in an HSM.
#' @param ElasticIp The elastic IP (EIP) address for the cluster.
#' @param ClusterParameterGroupName The name of the parameter group to be associated with this cluster.
#' 
#' Default: The default Amazon Redshift cluster parameter group. For
#' information about the default parameter group, go to [Working with
#' Amazon Redshift Parameter
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html).
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Cannot end with a hyphen or contain two consecutive hyphens.
#' @param ClusterSecurityGroups A list of security groups to be associated with this cluster.
#' 
#' Default: The default cluster security group for Amazon Redshift.
#' 
#' Cluster security groups only apply to clusters outside of VPCs.
#' @param VpcSecurityGroupIds A list of Virtual Private Cloud (VPC) security groups to be associated
#' with the cluster.
#' 
#' Default: The default VPC security group is associated with the cluster.
#' 
#' VPC security groups only apply to clusters in VPCs.
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which automated cluster
#' maintenance can occur.
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' Default: The value selected for the cluster from which the snapshot was
#' taken. For more information about the time blocks for each region, see
#' [Maintenance
#' Windows](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-maintenance-windows)
#' in Amazon Redshift Cluster Management Guide.
#' 
#' Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
#' 
#' Constraints: Minimum 30-minute window.
#' @param AutomatedSnapshotRetentionPeriod The number of days that automated snapshots are retained. If the value
#' is 0, automated snapshots are disabled. Even if automated snapshots are
#' disabled, you can still create manual snapshots when you want with
#' CreateClusterSnapshot.
#' 
#' Default: The value selected for the cluster from which the snapshot was
#' taken.
#' 
#' Constraints: Must be a value from 0 to 35.
#' @param ManualSnapshotRetentionPeriod The default number of days to retain a manual snapshot. If the value is
#' -1, the snapshot is retained indefinitely. This setting doesn't change
#' the retention period of existing snapshots.
#' 
#' The value must be either -1 or an integer between 1 and 3,653.
#' @param KmsKeyId The AWS Key Management Service (KMS) key ID of the encryption key that
#' you want to use to encrypt data in the cluster that you restore from a
#' shared snapshot.
#' @param NodeType The node type that the restored cluster will be provisioned with.
#' 
#' Default: The node type of the cluster from which the snapshot was taken.
#' You can modify this if you are using any DS node type. In that case, you
#' can choose to restore into another DS node type of the same size. For
#' example, you can restore ds1.8xlarge into ds2.8xlarge, or ds1.xlarge
#' into ds2.xlarge. If you have a DC instance type, you must restore into
#' that same instance type and size. In other words, you can only restore a
#' dc1.large instance type into another dc1.large instance type or
#' dc2.large instance type. You can't restore dc1.8xlarge to dc2.8xlarge.
#' First restore to a dc1.8xlarge cluster, then resize to a dc2.8large
#' cluster. For more information about node types, see [About Clusters and
#' Nodes](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#rs-about-clusters-and-nodes)
#' in the *Amazon Redshift Cluster Management Guide*.
#' @param EnhancedVpcRouting An option that specifies whether to create the cluster with enhanced VPC
#' routing enabled. To create a cluster that uses enhanced VPC routing, the
#' cluster must be in a VPC. For more information, see [Enhanced VPC
#' Routing](https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html)
#' in the Amazon Redshift Cluster Management Guide.
#' 
#' If this option is `true`, enhanced VPC routing is enabled.
#' 
#' Default: false
#' @param AdditionalInfo Reserved.
#' @param IamRoles A list of AWS Identity and Access Management (IAM) roles that can be
#' used by the cluster to access other AWS services. You must supply the
#' IAM roles in their Amazon Resource Name (ARN) format. You can supply up
#' to 10 IAM roles in a single request.
#' 
#' A cluster can have up to 10 IAM roles associated at any time.
#' @param MaintenanceTrackName The name of the maintenance track for the restored cluster. When you
#' take a snapshot, the snapshot inherits the `MaintenanceTrack` value from
#' the cluster. The snapshot might be on a different track than the cluster
#' that was the source for the snapshot. For example, suppose that you take
#' a snapshot of a cluster that is on the current track and then change the
#' cluster to be on the trailing track. In this case, the snapshot and the
#' source cluster are on different tracks.
#' @param SnapshotScheduleIdentifier A unique identifier for the snapshot schedule.
#' @param NumberOfNodes The number of nodes specified when provisioning the restored cluster.
#' @param AvailabilityZoneRelocation The option to enable relocation for an Amazon Redshift cluster between
#' Availability Zones after the cluster is restored.
#'
#' @section Request syntax:
#' ```
#' svc$restore_from_cluster_snapshot(
#'   ClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   SnapshotClusterIdentifier = "string",
#'   Port = 123,
#'   AvailabilityZone = "string",
#'   AllowVersionUpgrade = TRUE|FALSE,
#'   ClusterSubnetGroupName = "string",
#'   PubliclyAccessible = TRUE|FALSE,
#'   OwnerAccount = "string",
#'   HsmClientCertificateIdentifier = "string",
#'   HsmConfigurationIdentifier = "string",
#'   ElasticIp = "string",
#'   ClusterParameterGroupName = "string",
#'   ClusterSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   PreferredMaintenanceWindow = "string",
#'   AutomatedSnapshotRetentionPeriod = 123,
#'   ManualSnapshotRetentionPeriod = 123,
#'   KmsKeyId = "string",
#'   NodeType = "string",
#'   EnhancedVpcRouting = TRUE|FALSE,
#'   AdditionalInfo = "string",
#'   IamRoles = list(
#'     "string"
#'   ),
#'   MaintenanceTrackName = "string",
#'   SnapshotScheduleIdentifier = "string",
#'   NumberOfNodes = 123,
#'   AvailabilityZoneRelocation = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_restore_from_cluster_snapshot
redshift_restore_from_cluster_snapshot <- function(ClusterIdentifier, SnapshotIdentifier, SnapshotClusterIdentifier = NULL, Port = NULL, AvailabilityZone = NULL, AllowVersionUpgrade = NULL, ClusterSubnetGroupName = NULL, PubliclyAccessible = NULL, OwnerAccount = NULL, HsmClientCertificateIdentifier = NULL, HsmConfigurationIdentifier = NULL, ElasticIp = NULL, ClusterParameterGroupName = NULL, ClusterSecurityGroups = NULL, VpcSecurityGroupIds = NULL, PreferredMaintenanceWindow = NULL, AutomatedSnapshotRetentionPeriod = NULL, ManualSnapshotRetentionPeriod = NULL, KmsKeyId = NULL, NodeType = NULL, EnhancedVpcRouting = NULL, AdditionalInfo = NULL, IamRoles = NULL, MaintenanceTrackName = NULL, SnapshotScheduleIdentifier = NULL, NumberOfNodes = NULL, AvailabilityZoneRelocation = NULL) {
  op <- new_operation(
    name = "RestoreFromClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$restore_from_cluster_snapshot_input(ClusterIdentifier = ClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, SnapshotClusterIdentifier = SnapshotClusterIdentifier, Port = Port, AvailabilityZone = AvailabilityZone, AllowVersionUpgrade = AllowVersionUpgrade, ClusterSubnetGroupName = ClusterSubnetGroupName, PubliclyAccessible = PubliclyAccessible, OwnerAccount = OwnerAccount, HsmClientCertificateIdentifier = HsmClientCertificateIdentifier, HsmConfigurationIdentifier = HsmConfigurationIdentifier, ElasticIp = ElasticIp, ClusterParameterGroupName = ClusterParameterGroupName, ClusterSecurityGroups = ClusterSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, PreferredMaintenanceWindow = PreferredMaintenanceWindow, AutomatedSnapshotRetentionPeriod = AutomatedSnapshotRetentionPeriod, ManualSnapshotRetentionPeriod = ManualSnapshotRetentionPeriod, KmsKeyId = KmsKeyId, NodeType = NodeType, EnhancedVpcRouting = EnhancedVpcRouting, AdditionalInfo = AdditionalInfo, IamRoles = IamRoles, MaintenanceTrackName = MaintenanceTrackName, SnapshotScheduleIdentifier = SnapshotScheduleIdentifier, NumberOfNodes = NumberOfNodes, AvailabilityZoneRelocation = AvailabilityZoneRelocation)
  output <- .redshift$restore_from_cluster_snapshot_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$restore_from_cluster_snapshot <- redshift_restore_from_cluster_snapshot

#' Creates a new table from a table in an Amazon Redshift cluster snapshot
#'
#' @description
#' Creates a new table from a table in an Amazon Redshift cluster snapshot.
#' You must create the new table within the Amazon Redshift cluster that
#' the snapshot was taken from.
#' 
#' You cannot use `RestoreTableFromClusterSnapshot` to restore a table with
#' the same name as an existing table in an Amazon Redshift cluster. That
#' is, you cannot overwrite an existing table in a cluster with a restored
#' table. If you want to replace your original table with a new, restored
#' table, then rename or drop your original table before you call
#' `RestoreTableFromClusterSnapshot`. When you have renamed your original
#' table, then you can pass the original name of the table as the
#' `NewTableName` parameter value in the call to
#' `RestoreTableFromClusterSnapshot`. This way, you can replace the
#' original table with the table created from the snapshot.
#'
#' @usage
#' redshift_restore_table_from_cluster_snapshot(ClusterIdentifier,
#'   SnapshotIdentifier, SourceDatabaseName, SourceSchemaName,
#'   SourceTableName, TargetDatabaseName, TargetSchemaName, NewTableName)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the Amazon Redshift cluster to restore the table to.
#' @param SnapshotIdentifier &#91;required&#93; The identifier of the snapshot to restore the table from. This snapshot
#' must have been created from the Amazon Redshift cluster specified by the
#' `ClusterIdentifier` parameter.
#' @param SourceDatabaseName &#91;required&#93; The name of the source database that contains the table to restore from.
#' @param SourceSchemaName The name of the source schema that contains the table to restore from.
#' If you do not specify a `SourceSchemaName` value, the default is
#' `public`.
#' @param SourceTableName &#91;required&#93; The name of the source table to restore from.
#' @param TargetDatabaseName The name of the database to restore the table to.
#' @param TargetSchemaName The name of the schema to restore the table to.
#' @param NewTableName &#91;required&#93; The name of the table to create as a result of the current request.
#'
#' @section Request syntax:
#' ```
#' svc$restore_table_from_cluster_snapshot(
#'   ClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   SourceDatabaseName = "string",
#'   SourceSchemaName = "string",
#'   SourceTableName = "string",
#'   TargetDatabaseName = "string",
#'   TargetSchemaName = "string",
#'   NewTableName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_restore_table_from_cluster_snapshot
redshift_restore_table_from_cluster_snapshot <- function(ClusterIdentifier, SnapshotIdentifier, SourceDatabaseName, SourceSchemaName = NULL, SourceTableName, TargetDatabaseName = NULL, TargetSchemaName = NULL, NewTableName) {
  op <- new_operation(
    name = "RestoreTableFromClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$restore_table_from_cluster_snapshot_input(ClusterIdentifier = ClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, SourceDatabaseName = SourceDatabaseName, SourceSchemaName = SourceSchemaName, SourceTableName = SourceTableName, TargetDatabaseName = TargetDatabaseName, TargetSchemaName = TargetSchemaName, NewTableName = NewTableName)
  output <- .redshift$restore_table_from_cluster_snapshot_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$restore_table_from_cluster_snapshot <- redshift_restore_table_from_cluster_snapshot

#' Resumes a paused cluster
#'
#' @description
#' Resumes a paused cluster.
#'
#' @usage
#' redshift_resume_cluster(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The identifier of the cluster to be resumed.
#'
#' @section Request syntax:
#' ```
#' svc$resume_cluster(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_resume_cluster
redshift_resume_cluster <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "ResumeCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$resume_cluster_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$resume_cluster_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$resume_cluster <- redshift_resume_cluster

#' Revokes an ingress rule in an Amazon Redshift security group for a
#' previously authorized IP range or Amazon EC2 security group
#'
#' @description
#' Revokes an ingress rule in an Amazon Redshift security group for a
#' previously authorized IP range or Amazon EC2 security group. To add an
#' ingress rule, see AuthorizeClusterSecurityGroupIngress. For information
#' about managing security groups, go to [Amazon Redshift Cluster Security
#' Groups](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-security-groups.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_revoke_cluster_security_group_ingress(ClusterSecurityGroupName,
#'   CIDRIP, EC2SecurityGroupName, EC2SecurityGroupOwnerId)
#'
#' @param ClusterSecurityGroupName &#91;required&#93; The name of the security Group from which to revoke the ingress rule.
#' @param CIDRIP The IP range for which to revoke access. This range must be a valid
#' Classless Inter-Domain Routing (CIDR) block of IP addresses. If `CIDRIP`
#' is specified, `EC2SecurityGroupName` and `EC2SecurityGroupOwnerId`
#' cannot be provided.
#' @param EC2SecurityGroupName The name of the EC2 Security Group whose access is to be revoked. If
#' `EC2SecurityGroupName` is specified, `EC2SecurityGroupOwnerId` must also
#' be provided and `CIDRIP` cannot be provided.
#' @param EC2SecurityGroupOwnerId The AWS account number of the owner of the security group specified in
#' the `EC2SecurityGroupName` parameter. The AWS access key ID is not an
#' acceptable value. If `EC2SecurityGroupOwnerId` is specified,
#' `EC2SecurityGroupName` must also be provided. and `CIDRIP` cannot be
#' provided.
#' 
#' Example: `111122223333`
#'
#' @section Request syntax:
#' ```
#' svc$revoke_cluster_security_group_ingress(
#'   ClusterSecurityGroupName = "string",
#'   CIDRIP = "string",
#'   EC2SecurityGroupName = "string",
#'   EC2SecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_revoke_cluster_security_group_ingress
redshift_revoke_cluster_security_group_ingress <- function(ClusterSecurityGroupName, CIDRIP = NULL, EC2SecurityGroupName = NULL, EC2SecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "RevokeClusterSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$revoke_cluster_security_group_ingress_input(ClusterSecurityGroupName = ClusterSecurityGroupName, CIDRIP = CIDRIP, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .redshift$revoke_cluster_security_group_ingress_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$revoke_cluster_security_group_ingress <- redshift_revoke_cluster_security_group_ingress

#' Removes the ability of the specified AWS customer account to restore the
#' specified snapshot
#'
#' @description
#' Removes the ability of the specified AWS customer account to restore the
#' specified snapshot. If the account is currently restoring the snapshot,
#' the restore will run to completion.
#' 
#' For more information about working with snapshots, go to [Amazon
#' Redshift
#' Snapshots](https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
#' in the *Amazon Redshift Cluster Management Guide*.
#'
#' @usage
#' redshift_revoke_snapshot_access(SnapshotIdentifier,
#'   SnapshotClusterIdentifier, AccountWithRestoreAccess)
#'
#' @param SnapshotIdentifier &#91;required&#93; The identifier of the snapshot that the account can no longer access.
#' @param SnapshotClusterIdentifier The identifier of the cluster the snapshot was created from. This
#' parameter is required if your IAM user has a policy containing a
#' snapshot resource element that specifies anything other than * for the
#' cluster name.
#' @param AccountWithRestoreAccess &#91;required&#93; The identifier of the AWS customer account that can no longer restore
#' the specified snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_snapshot_access(
#'   SnapshotIdentifier = "string",
#'   SnapshotClusterIdentifier = "string",
#'   AccountWithRestoreAccess = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_revoke_snapshot_access
redshift_revoke_snapshot_access <- function(SnapshotIdentifier, SnapshotClusterIdentifier = NULL, AccountWithRestoreAccess) {
  op <- new_operation(
    name = "RevokeSnapshotAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$revoke_snapshot_access_input(SnapshotIdentifier = SnapshotIdentifier, SnapshotClusterIdentifier = SnapshotClusterIdentifier, AccountWithRestoreAccess = AccountWithRestoreAccess)
  output <- .redshift$revoke_snapshot_access_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$revoke_snapshot_access <- redshift_revoke_snapshot_access

#' Rotates the encryption keys for a cluster
#'
#' @description
#' Rotates the encryption keys for a cluster.
#'
#' @usage
#' redshift_rotate_encryption_key(ClusterIdentifier)
#'
#' @param ClusterIdentifier &#91;required&#93; The unique identifier of the cluster that you want to rotate the
#' encryption keys for.
#' 
#' Constraints: Must be the name of valid cluster that has encryption
#' enabled.
#'
#' @section Request syntax:
#' ```
#' svc$rotate_encryption_key(
#'   ClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname redshift_rotate_encryption_key
redshift_rotate_encryption_key <- function(ClusterIdentifier) {
  op <- new_operation(
    name = "RotateEncryptionKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .redshift$rotate_encryption_key_input(ClusterIdentifier = ClusterIdentifier)
  output <- .redshift$rotate_encryption_key_output()
  config <- get_config()
  svc <- .redshift$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.redshift$operations$rotate_encryption_key <- redshift_rotate_encryption_key
