% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_db_cluster}
\alias{rds_create_db_cluster}
\title{Creates a new Amazon Aurora DB cluster}
\usage{
rds_create_db_cluster(AvailabilityZones, BackupRetentionPeriod,
  CharacterSetName, DatabaseName, DBClusterIdentifier,
  DBClusterParameterGroupName, VpcSecurityGroupIds, DBSubnetGroupName,
  Engine, EngineVersion, Port, MasterUsername, MasterUserPassword,
  OptionGroupName, PreferredBackupWindow, PreferredMaintenanceWindow,
  ReplicationSourceIdentifier, Tags, StorageEncrypted, KmsKeyId,
  PreSignedUrl, EnableIAMDatabaseAuthentication, BacktrackWindow,
  EnableCloudwatchLogsExports, EngineMode, ScalingConfiguration,
  DeletionProtection, GlobalClusterIdentifier, CopyTagsToSnapshot,
  SourceRegion)
}
\arguments{
\item{AvailabilityZones}{A list of EC2 Availability Zones that instances in the DB cluster can be
created in. For information on AWS Regions and Availability Zones, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html}{Choosing the Regions and Availability Zones}
in the \emph{Amazon Aurora User Guide}.}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. You must
specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{CharacterSetName}{A value that indicates that the DB cluster should be associated with the
specified CharacterSet.}

\item{DatabaseName}{The name for your database of up to 64 alpha-numeric characters. If you
do not provide a name, Amazon RDS will not create a database in the DB
cluster you are creating.}

\item{DBClusterIdentifier}{[required] The DB cluster identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, \code{default.aurora5.6} is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB cluster parameter
group.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB cluster.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB cluster.

Constraints: Must match the name of an existing DBSubnetGroup. Must not
be default.

Example: \code{mySubnetgroup}}

\item{Engine}{[required] The name of the database engine to be used for this DB cluster.

Valid Values: \code{aurora} (for MySQL 5.6-compatible Aurora), \code{aurora-mysql}
(for MySQL 5.7-compatible Aurora), and \code{aurora-postgresql}}

\item{EngineVersion}{The version number of the database engine to use.

\strong{Aurora MySQL}

Example: \code{5.6.10a}, \code{5.7.12}

\strong{Aurora PostgreSQL}

Example: \code{9.6.3}}

\item{Port}{The port number on which the instances in the DB cluster accept
connections.

Default: \code{3306} if engine is set as aurora or \code{5432} if set to
aurora-postgresql.}

\item{MasterUsername}{The name of the master user for the DB cluster.

Constraints:
\itemize{
\item Must be 1 to 16 letters or numbers.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{The password for the master database user. This password can contain any
printable ASCII character except "/", """, or "@".

Constraints: Must contain from 8 to 41 characters.}

\item{OptionGroupName}{A value that indicates that the DB cluster should be associated with the
specified option group.

Permanent options can't be removed from an option group. The option
group can't be removed from a DB cluster once it is associated with a
DB cluster.}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region. To see the time blocks available, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred DB Cluster Maintenance Window}
in the \emph{Amazon Aurora User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora}{Adjusting the Preferred DB Cluster Maintenance Window}
in the \emph{Amazon Aurora User Guide.}

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{ReplicationSourceIdentifier}{The Amazon Resource Name (ARN) of the source DB instance or DB cluster
if this DB cluster is created as a Read Replica.}

\item{Tags}{}

\item{StorageEncrypted}{Specifies whether the DB cluster is encrypted.}

\item{KmsKeyId}{The AWS KMS key identifier for an encrypted DB cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a DB cluster with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

If an encryption key is not specified in \code{KmsKeyId}:
\itemize{
\item If \code{ReplicationSourceIdentifier} identifies an encrypted source,
then Amazon RDS will use the encryption key used to encrypt the
source. Otherwise, Amazon RDS will use your default encryption key.
\item If the \code{StorageEncrypted} parameter is true and
\code{ReplicationSourceIdentifier} is not specified, then Amazon RDS will
use your default encryption key.
}

AWS KMS creates the default encryption key for your AWS account. Your
AWS account has a different default encryption key for each AWS Region.

If you create a Read Replica of an encrypted DB cluster in another AWS
Region, you must set \code{KmsKeyId} to a KMS key ID that is valid in the
destination AWS Region. This key is used to encrypt the Read Replica in
that AWS Region.}

\item{PreSignedUrl}{A URL that contains a Signature Version 4 signed request for the
\code{CreateDBCluster} action to be called in the source AWS Region where the
DB cluster is replicated from. You only need to specify \code{PreSignedUrl}
when you are performing cross-region replication from an encrypted DB
cluster.

The pre-signed URL must be a valid request for the \code{CreateDBCluster} API
action that can be executed in the source AWS Region that contains the
encrypted DB cluster to be copied.

The pre-signed URL request must contain the following parameter values:
\itemize{
\item \code{KmsKeyId} - The AWS KMS key identifier for the key to use to
encrypt the copy of the DB cluster in the destination AWS Region.
This should refer to the same KMS key for both the \code{CreateDBCluster}
action that is called in the destination AWS Region, and the action
contained in the pre-signed URL.
\item \code{DestinationRegion} - The name of the AWS Region that Aurora Read
Replica will be created in.
\item \code{ReplicationSourceIdentifier} - The DB cluster identifier for the
encrypted DB cluster to be copied. This identifier must be in the
Amazon Resource Name (ARN) format for the source AWS Region. For
example, if you are copying an encrypted DB cluster from the
us-west-2 AWS Region, then your \code{ReplicationSourceIdentifier} would
look like Example:
\code{arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1}.
}

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (AWS Signature Version 4)}
and \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4 Signing Process}.

If you supply a value for this operation's \code{SourceRegion} parameter, a
pre-signed URL will be calculated on your behalf.}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

Default: \code{false}}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{EnableCloudwatchLogsExports}{The list of log types that need to be enabled for exporting to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineMode}{The DB engine mode of the DB cluster, either \code{provisioned},
\code{serverless}, \code{parallelquery}, or \code{global}.}

\item{ScalingConfiguration}{For DB clusters in \code{serverless} DB engine mode, the scaling properties
of the DB cluster.}

\item{DeletionProtection}{Indicates if the DB cluster should have deletion protection enabled. The
database can't be deleted when this value is set to true. The default
is false.}

\item{GlobalClusterIdentifier}{The global cluster ID of an Aurora cluster that becomes the primary
cluster in the new global database cluster.}

\item{CopyTagsToSnapshot}{True to copy all tags from the DB cluster to snapshots of the DB
cluster, and otherwise false. The default is false.}

\item{SourceRegion}{The ID of the region that contains the source for the read replica.}
}
\description{
Creates a new Amazon Aurora DB cluster.
}
\details{
You can use the \code{ReplicationSourceIdentifier} parameter to create the DB
cluster as a Read Replica of another DB cluster or Amazon RDS MySQL DB
instance. For cross-region replication where the DB cluster identified
by \code{ReplicationSourceIdentifier} is encrypted, you must also specify the
\code{PreSignedUrl} parameter.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster(
  AvailabilityZones = list(
    "string"
  ),
  BackupRetentionPeriod = 123,
  CharacterSetName = "string",
  DatabaseName = "string",
  DBClusterIdentifier = "string",
  DBClusterParameterGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  DBSubnetGroupName = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  MasterUsername = "string",
  MasterUserPassword = "string",
  OptionGroupName = "string",
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  ReplicationSourceIdentifier = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageEncrypted = TRUE|FALSE,
  KmsKeyId = "string",
  PreSignedUrl = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  BacktrackWindow = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  EngineMode = "string",
  ScalingConfiguration = list(
    MinCapacity = 123,
    MaxCapacity = 123,
    AutoPause = TRUE|FALSE,
    SecondsUntilAutoPause = 123
  ),
  DeletionProtection = TRUE|FALSE,
  GlobalClusterIdentifier = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  SourceRegion = "string"
)
}
}

\keyword{internal}
