% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_user}
\alias{connect_create_user}
\title{Creates a new user account in your Amazon Connect instance}
\usage{
connect_create_user(Username, Password, IdentityInfo, PhoneConfig,
  DirectoryUserId, SecurityProfileIds, RoutingProfileId, HierarchyGroupId,
  InstanceId)
}
\arguments{
\item{Username}{[required] The user name in Amazon Connect for the account to create. If you are
using SAML for identity management in your Amazon Connect, the value for
\code{Username} can include up to 64 characters from [a-zA-Z0-9\_-.\@]+.}

\item{Password}{The password for the user account to create. This is required if you are
using Amazon Connect for identity management. If you are using SAML for
identity management and include this parameter, an
\code{InvalidRequestException} is returned.}

\item{IdentityInfo}{Information about the user, including email address, first name, and
last name.}

\item{PhoneConfig}{[required] Specifies the phone settings for the user, including
\code{AfterContactWorkTimeLimit}, \code{AutoAccept}, \code{DeskPhoneNumber}, and
\code{PhoneType}.}

\item{DirectoryUserId}{The unique identifier for the user account in the directory service
directory used for identity management. If Amazon Connect is unable to
access the existing directory, you can use the \code{DirectoryUserId} to
authenticate users. If you include the parameter, it is assumed that
Amazon Connect cannot access the directory. If the parameter is not
included, the \code{UserIdentityInfo} is used to authenticate users from your
existing directory.

This parameter is required if you are using an existing directory for
identity management in Amazon Connect when Amazon Connect cannot access
your directory to authenticate users. If you are using SAML for identity
management and include this parameter, an \code{InvalidRequestException} is
returned.}

\item{SecurityProfileIds}{[required] The unique identifier of the security profile to assign to the user
created.}

\item{RoutingProfileId}{[required] The unique identifier for the routing profile to assign to the user
created.}

\item{HierarchyGroupId}{The unique identifier for the hierarchy group to assign to the user
created.}

\item{InstanceId}{[required] The identifier for your Amazon Connect instance. To find the ID of your
instance, open the AWS console and select Amazon Connect. Select the
alias of the instance in the Instance alias column. The instance ID is
displayed in the Overview section of your instance settings. For
example, the instance ID is the set of characters at the end of the
instance ARN, after instance/, such as
10a4c4eb-f57e-4d4c-b602-bf39176ced07.}
}
\description{
Creates a new user account in your Amazon Connect instance.
}
\section{Request syntax}{
\preformatted{svc$create_user(
  Username = "string",
  Password = "string",
  IdentityInfo = list(
    FirstName = "string",
    LastName = "string",
    Email = "string"
  ),
  PhoneConfig = list(
    PhoneType = "SOFT_PHONE"|"DESK_PHONE",
    AutoAccept = TRUE|FALSE,
    AfterContactWorkTimeLimit = 123,
    DeskPhoneNumber = "string"
  ),
  DirectoryUserId = "string",
  SecurityProfileIds = list(
    "string"
  ),
  RoutingProfileId = "string",
  HierarchyGroupId = "string",
  InstanceId = "string"
)
}
}

\keyword{internal}
