% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_verify_domain_dkim}
\alias{ses_verify_domain_dkim}
\title{Returns a set of DKIM tokens for a domain}
\usage{
ses_verify_domain_dkim(Domain)
}
\arguments{
\item{Domain}{[required] The name of the domain to be verified for Easy DKIM signing.}
}
\description{
Returns a set of DKIM tokens for a domain. DKIM \emph{tokens} are character
strings that represent your domain's identity. Using these tokens, you
will need to create DNS CNAME records that point to DKIM public keys
hosted by Amazon SES. Amazon Web Services will eventually detect that
you have updated your DNS records; this detection process may take up to
72 hours. Upon successful detection, Amazon SES will be able to
DKIM-sign email originating from that domain.
}
\details{
You can execute this operation no more than once per second.

To enable or disable Easy DKIM signing for a domain, use the
\code{SetIdentityDkimEnabled} operation.

For more information about creating DNS records using DKIM tokens, go to
the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$verify_domain_dkim(
  Domain = "string"
)
}
}

\examples{
# The following example generates DKIM tokens for a domain that has been
# verified with Amazon SES:
\donttest{svc$verify_domain_dkim(
  Domain = "example.com"
)}

}
\keyword{internal}
