% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_create_configuration_set_event_destination}
\alias{ses_create_configuration_set_event_destination}
\title{Creates a configuration set event destination}
\usage{
ses_create_configuration_set_event_destination(ConfigurationSetName,
  EventDestination)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set that the event destination should be
associated with.}

\item{EventDestination}{[required] An object that describes the AWS service that email sending event
information will be published to.}
}
\description{
Creates a configuration set event destination.
}
\details{
When you create or update an event destination, you must provide one,
and only one, destination. The destination can be CloudWatch, Amazon
Kinesis Firehose, or Amazon Simple Notification Service (Amazon SNS).

An event destination is the AWS service to which Amazon SES publishes
the email sending events associated with a configuration set. For
information about using configuration sets, see the \href{http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$create_configuration_set_event_destination(
  ConfigurationSetName = "string",
  EventDestination = list(
    Name = "string",
    Enabled = TRUE|FALSE,
    MatchingEventTypes = list(
      "send"|"reject"|"bounce"|"complaint"|"delivery"|"open"|"click"|"renderingFailure"
    ),
    KinesisFirehoseDestination = list(
      IAMRoleARN = "string",
      DeliveryStreamARN = "string"
    ),
    CloudWatchDestination = list(
      DimensionConfigurations = list(
        list(
          DimensionName = "string",
          DimensionValueSource = "messageTag"|"emailHeader"|"linkTag",
          DefaultDimensionValue = "string"
        )
      )
    ),
    SNSDestination = list(
      TopicARN = "string"
    )
  )
)
}
}

\keyword{internal}
