% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_network_insights_paths}
\alias{ec2_describe_network_insights_paths}
\title{Describes one or more of your paths}
\usage{
ec2_describe_network_insights_paths(
  NetworkInsightsPathIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  DryRun = NULL,
  NextToken = NULL
)
}
\arguments{
\item{NetworkInsightsPathIds}{The IDs of the paths.}

\item{Filters}{The filters. The following are the possible values:
\itemize{
\item destination - The ID of the resource.
\item filter-at-source.source-address - The source IPv4 address at the
source.
\item filter-at-source.source-port-range - The source port range at the
source.
\item filter-at-source.destination-address - The destination IPv4 address
at the source.
\item filter-at-source.destination-port-range - The destination port range
at the source.
\item filter-at-destination.source-address - The source IPv4 address at
the destination.
\item filter-at-destination.source-port-range - The source port range at
the destination.
\item filter-at-destination.destination-address - The destination IPv4
address at the destination.
\item filter-at-destination.destination-port-range - The destination port
range at the destination.
\item protocol - The protocol.
\item source - The ID of the resource.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more of your paths.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_network_insights_paths/} for full documentation.
}
\keyword{internal}
