% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_aliases}
\alias{lambda_list_aliases}
\title{Returns a list of aliases for a Lambda function}
\usage{
lambda_list_aliases(
  FunctionName,
  FunctionVersion = NULL,
  Marker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name or ARN of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{FunctionVersion}{Specify a function version to only list aliases that invoke that
version.}

\item{Marker}{Specify the pagination token that's returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{Limit the number of aliases returned.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-aliases.html}{aliases} for a Lambda function.

See \url{https://www.paws-r-sdk.com/docs/lambda_list_aliases/} for full documentation.
}
\keyword{internal}
