% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_reserved_instances_listing}
\alias{ec2_create_reserved_instances_listing}
\title{Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
in the Reserved Instance Marketplace}
\usage{
ec2_create_reserved_instances_listing(
  ClientToken,
  InstanceCount,
  PriceSchedules,
  ReservedInstancesId
)
}
\arguments{
\item{ClientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
your listings. This helps avoid duplicate listings. For more
information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring Idempotency}.}

\item{InstanceCount}{[required] The number of instances that are a part of a Reserved Instance account
to be listed in the Reserved Instance Marketplace. This number should be
less than or equal to the instance count associated with the Reserved
Instance ID specified in this call.}

\item{PriceSchedules}{[required] A list specifying the price of the Standard Reserved Instance for each
month remaining in the Reserved Instance term.}

\item{ReservedInstancesId}{[required] The ID of the active Standard Reserved Instance.}
}
\description{
Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To get a list of your Standard Reserved Instances, you can use the \code{\link[=ec2_describe_reserved_instances]{describe_reserved_instances}} operation.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_reserved_instances_listing/} for full documentation.
}
\keyword{internal}
