% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_instance_metadata_options}
\alias{lightsail_update_instance_metadata_options}
\title{Modifies the Amazon Lightsail instance metadata parameters on a running
or stopped instance}
\usage{
lightsail_update_instance_metadata_options(
  instanceName,
  httpTokens = NULL,
  httpEndpoint = NULL,
  httpPutResponseHopLimit = NULL,
  httpProtocolIpv6 = NULL
)
}
\arguments{
\item{instanceName}{[required] The name of the instance for which to update metadata parameters.}

\item{httpTokens}{The state of token usage for your instance metadata requests. If the
parameter is not specified in the request, the default state is
\code{optional}.

If the state is \code{optional}, you can choose whether to retrieve instance
metadata with a signed token header on your request. If you retrieve the
IAM role credentials without a token, the version 1.0 role credentials
are returned. If you retrieve the IAM role credentials by using a valid
signed token, the version 2.0 role credentials are returned.

If the state is \code{required}, you must send a signed token header with all
instance metadata retrieval requests. In this state, retrieving the IAM
role credential always returns the version 2.0 credentials. The version
1.0 credentials are not available.}

\item{httpEndpoint}{Enables or disables the HTTP metadata endpoint on your instances. If
this parameter is not specified, the existing state is maintained.

If you specify a value of \code{disabled}, you cannot access your instance
metadata.}

\item{httpPutResponseHopLimit}{The desired HTTP PUT response hop limit for instance metadata requests.
A larger number means that the instance metadata requests can travel
farther. If no parameter is specified, the existing state is maintained.}

\item{httpProtocolIpv6}{Enables or disables the IPv6 endpoint for the instance metadata service.
This setting applies only when the HTTP metadata endpoint is enabled.

This parameter is available only for instances in the Europe (Stockholm)
Amazon Web Services Region (\code{eu-north-1}).}
}
\description{
Modifies the Amazon Lightsail instance metadata parameters on a running or stopped instance. When you modify the parameters on a running instance, the \code{\link[=lightsail_get_instance]{get_instance}} or \code{\link[=lightsail_get_instances]{get_instances}} API operation initially responds with a state of \code{pending}. After the parameter modifications are successfully applied, the state changes to \code{applied} in subsequent \code{\link[=lightsail_get_instance]{get_instance}} or \code{\link[=lightsail_get_instances]{get_instances}} API calls. For more information, see \href{https://docs.aws.amazon.com/en_us/lightsail/latest/userguide/amazon-lightsail-configuring-instance-metadata-service.html}{Use IMDSv2 with an Amazon Lightsail instance} in the \emph{Amazon Lightsail Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/lightsail_update_instance_metadata_options/} for full documentation.
}
\keyword{internal}
