% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_snapshot}
\alias{ec2_create_snapshot}
\title{Creates a snapshot of an EBS volume and stores it in Amazon S3}
\usage{
ec2_create_snapshot(
  Description = NULL,
  OutpostArn = NULL,
  VolumeId,
  TagSpecifications = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Description}{A description for the snapshot.}

\item{OutpostArn}{The Amazon Resource Name (ARN) of the Outpost on which to create a local
snapshot.
\itemize{
\item To create a snapshot of a volume in a Region, omit this parameter.
The snapshot is created in the same Region as the volume.
\item To create a snapshot of a volume on an Outpost and store the
snapshot in the Region, omit this parameter. The snapshot is created
in the Region for the Outpost.
\item To create a snapshot of a volume on an Outpost and store the
snapshot on an Outpost, specify the ARN of the destination Outpost.
The snapshot must be created on the same Outpost as the volume.
}

For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot}{Create local snapshots from volumes on an Outpost}
in the \emph{Amazon EBS User Guide}.}

\item{VolumeId}{[required] The ID of the Amazon EBS volume.}

\item{TagSpecifications}{The tags to apply to the snapshot during creation.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for backups, to make copies of EBS volumes, and to save data before shutting down an instance.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_snapshot/} for full documentation.
}
\keyword{internal}
