% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_put_provisioned_concurrency_config}
\alias{lambda_put_provisioned_concurrency_config}
\title{Adds a provisioned concurrency configuration to a function's alias or
version}
\usage{
lambda_put_provisioned_concurrency_config(
  FunctionName,
  Qualifier,
  ProvisionedConcurrentExecutions
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function}.
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{Qualifier}{[required] The version number or alias name.}

\item{ProvisionedConcurrentExecutions}{[required] The amount of provisioned concurrency to allocate for the version or
alias.}
}
\description{
Adds a provisioned concurrency configuration to a function's alias or version.

See \url{https://www.paws-r-sdk.com/docs/lambda_put_provisioned_concurrency_config/} for full documentation.
}
\keyword{internal}
