% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_policy}
\alias{lambda_get_policy}
\title{Returns the resource-based IAM policy for a function, version, or alias}
\usage{
lambda_get_policy(FunctionName, Qualifier = NULL)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} – \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} –
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} – \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{Specify a version or alias to get the policy for that resource.}
}
\description{
Returns the \href{https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html}{resource-based IAM policy} for a function, version, or alias.

See \url{https://www.paws-r-sdk.com/docs/lambda_get_policy/} for full documentation.
}
\keyword{internal}
