% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_service_instance}
\alias{proton_create_service_instance}
\title{Create a service instance}
\usage{
proton_create_service_instance(
  clientToken = NULL,
  name,
  serviceName,
  spec,
  tags = NULL,
  templateMajorVersion = NULL,
  templateMinorVersion = NULL
)
}
\arguments{
\item{clientToken}{The client token of the service instance to create.}

\item{name}{[required] The name of the service instance to create.}

\item{serviceName}{[required] The name of the service the service instance is added to.}

\item{spec}{[required] The spec for the service instance you want to create.}

\item{tags}{An optional list of metadata items that you can associate with the
Proton service instance. A tag is a key-value pair.

For more information, see \href{https://docs.aws.amazon.com/proton/latest/userguide/resources.html}{Proton resources and tagging}
in the \emph{Proton User Guide}.}

\item{templateMajorVersion}{To create a new major and minor version of the service template,
\emph{exclude} \verb{major Version}.}

\item{templateMinorVersion}{To create a new minor version of the service template, include a
\verb{major Version}.}
}
\description{
Create a service instance.

See \url{https://www.paws-r-sdk.com/docs/proton_create_service_instance/} for full documentation.
}
\keyword{internal}
