% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_metadata_options}
\alias{ec2_modify_instance_metadata_options}
\title{Modify the instance metadata parameters on a running or stopped instance}
\usage{
ec2_modify_instance_metadata_options(
  InstanceId,
  HttpTokens = NULL,
  HttpPutResponseHopLimit = NULL,
  HttpEndpoint = NULL,
  DryRun = NULL,
  HttpProtocolIpv6 = NULL,
  InstanceMetadataTags = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{HttpTokens}{IMDSv2 uses token-backed sessions. Set the use of HTTP tokens to
\code{optional} (in other words, set the use of IMDSv2 to \code{optional}) or
\code{required} (in other words, set the use of IMDSv2 to \code{required}).
\itemize{
\item \code{optional} - When IMDSv2 is optional, you can choose to retrieve
instance metadata with or without a session token in your request.
If you retrieve the IAM role credentials without a token, the IMDSv1
role credentials are returned. If you retrieve the IAM role
credentials using a valid session token, the IMDSv2 role credentials
are returned.
\item \code{required} - When IMDSv2 is required, you must send a session token
with any instance metadata retrieval requests. In this state,
retrieving the IAM role credentials always returns IMDSv2
credentials; IMDSv1 credentials are not available.
}

Default: \code{optional}}

\item{HttpPutResponseHopLimit}{The desired HTTP PUT response hop limit for instance metadata requests.
The larger the number, the further instance metadata requests can
travel. If no parameter is specified, the existing state is maintained.

Possible values: Integers from 1 to 64}

\item{HttpEndpoint}{Enables or disables the HTTP metadata endpoint on your instances. If
this parameter is not specified, the existing state is maintained.

If you specify a value of \code{disabled}, you cannot access your instance
metadata.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{HttpProtocolIpv6}{Enables or disables the IPv6 endpoint for the instance metadata service.
This setting applies only if you have enabled the HTTP metadata
endpoint.}

\item{InstanceMetadataTags}{Set to \code{enabled} to allow access to instance tags from the instance
metadata. Set to \code{disabled} to turn off access to instance tags from the
instance metadata. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS}{Work with instance tags using the instance metadata}.

Default: \code{disabled}}
}
\description{
Modify the instance metadata parameters on a running or stopped instance. When you modify the parameters on a stopped instance, they are applied when the instance is started. When you modify the parameters on a running instance, the API responds with a state of “pending”. After the parameter modifications are successfully applied to the instance, the state of the modifications changes from “pending” to “applied” in subsequent describe-instances API calls. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance metadata and user data} in the \emph{Amazon EC2 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_metadata_options/} for full documentation.
}
\keyword{internal}
