% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc}
\alias{ec2_create_vpc}
\title{Creates a VPC with the specified CIDR blocks}
\usage{
ec2_create_vpc(
  CidrBlock = NULL,
  AmazonProvidedIpv6CidrBlock = NULL,
  Ipv6Pool = NULL,
  Ipv6CidrBlock = NULL,
  Ipv4IpamPoolId = NULL,
  Ipv4NetmaskLength = NULL,
  Ipv6IpamPoolId = NULL,
  Ipv6NetmaskLength = NULL,
  DryRun = NULL,
  InstanceTenancy = NULL,
  Ipv6CidrBlockNetworkBorderGroup = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{CidrBlock}{The IPv4 network range for the VPC, in CIDR notation. For example,
\verb{10.0.0.0/16}. We modify the specified CIDR block to its canonical form;
for example, if you specify \verb{100.68.0.18/18}, we modify it to
\verb{100.68.0.0/18}.}

\item{AmazonProvidedIpv6CidrBlock}{Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
the VPC. You cannot specify the range of IP addresses, or the size of
the CIDR block.}

\item{Ipv6Pool}{The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
block.}

\item{Ipv6CidrBlock}{The IPv6 CIDR block from the IPv6 address pool. You must also specify
\code{Ipv6Pool} in the request.

To let Amazon choose the IPv6 CIDR block for you, omit this parameter.}

\item{Ipv4IpamPoolId}{The ID of an IPv4 IPAM pool you want to use for allocating this VPC's
CIDR. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?} in the \emph{Amazon VPC
IPAM User Guide}.}

\item{Ipv4NetmaskLength}{The netmask length of the IPv4 CIDR you want to allocate to this VPC
from an Amazon VPC IP Address Manager (IPAM) pool. For more information
about IPAM, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?} in the \emph{Amazon VPC
IPAM User Guide}.}

\item{Ipv6IpamPoolId}{The ID of an IPv6 IPAM pool which will be used to allocate this VPC an
IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP
address management workflows including assigning, tracking,
troubleshooting, and auditing IP addresses across Amazon Web Services
Regions and accounts throughout your Amazon Web Services Organization.
For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?} in the \emph{Amazon VPC
IPAM User Guide}.}

\item{Ipv6NetmaskLength}{The netmask length of the IPv6 CIDR you want to allocate to this VPC
from an Amazon VPC IP Address Manager (IPAM) pool. For more information
about IPAM, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{What is IPAM?} in the \emph{Amazon VPC
IPAM User Guide}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceTenancy}{The tenancy options for instances launched into the VPC. For \code{default},
instances are launched with shared tenancy by default. You can launch
instances with any tenancy into a shared tenancy VPC. For \code{dedicated},
instances are launched as dedicated tenancy instances by default. You
can only launch instances with a tenancy of \code{dedicated} or \code{host} into a
dedicated tenancy VPC.

\strong{Important:} The \code{host} value cannot be used with this parameter. Use
the \code{default} or \code{dedicated} values only.

Default: \code{default}}

\item{Ipv6CidrBlockNetworkBorderGroup}{The name of the location from which we advertise the IPV6 CIDR block.
Use this parameter to limit the address to this location.

You must set \code{AmazonProvidedIpv6CidrBlock} to \code{true} to use this
parameter.}

\item{TagSpecifications}{The tags to assign to the VPC.}
}
\description{
Creates a VPC with the specified CIDR blocks. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/configure-your-vpc.html#vpc-cidr-blocks}{VPC CIDR blocks} in the \emph{Amazon Virtual Private Cloud User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_vpc/} for full documentation.
}
\keyword{internal}
