% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_update_service_pipeline}
\alias{proton_update_service_pipeline}
\title{Update the service pipeline}
\usage{
proton_update_service_pipeline(
  deploymentType,
  serviceName,
  spec,
  templateMajorVersion = NULL,
  templateMinorVersion = NULL
)
}
\arguments{
\item{deploymentType}{[required] The deployment type.

There are four modes for updating a service pipeline. The
\code{deploymentType} field defines the mode.

\code{NONE}

In this mode, a deployment \emph{doesn't} occur. Only the requested metadata
parameters are updated.

\code{CURRENT_VERSION}

In this mode, the service pipeline is deployed and updated with the new
spec that you provide. Only requested parameters are updated. \emph{Don’t}
include major or minor version parameters when you use this
\code{deployment-type}.

\code{MINOR_VERSION}

In this mode, the service pipeline is deployed and updated with the
published, recommended (latest) minor version of the current major
version in use, by default. You can specify a different minor version of
the current major version in use.

\code{MAJOR_VERSION}

In this mode, the service pipeline is deployed and updated with the
published, recommended (latest) major and minor version of the current
template, by default. You can specify a different major version that's
higher than the major version in use and a minor version.}

\item{serviceName}{[required] The name of the service to that the pipeline is associated with.}

\item{spec}{[required] The spec for the service pipeline to update.}

\item{templateMajorVersion}{The major version of the service template that was used to create the
service that the pipeline is associated with.}

\item{templateMinorVersion}{The minor version of the service template that was used to create the
service that the pipeline is associated with.}
}
\description{
Update the service pipeline.

See \url{https://paws-r.github.io/docs/proton/update_service_pipeline.html} for full documentation.
}
\keyword{internal}
