% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_distribution}
\alias{lightsail_update_distribution}
\title{Updates an existing Amazon Lightsail content delivery network (CDN)
distribution}
\usage{
lightsail_update_distribution(
  distributionName,
  origin = NULL,
  defaultCacheBehavior = NULL,
  cacheBehaviorSettings = NULL,
  cacheBehaviors = NULL,
  isEnabled = NULL
)
}
\arguments{
\item{distributionName}{[required] The name of the distribution to update.

Use the \code{\link[=lightsail_get_distributions]{get_distributions}} action to get
a list of distribution names that you can specify.}

\item{origin}{An object that describes the origin resource for the distribution, such
as a Lightsail instance, bucket, or load balancer.

The distribution pulls, caches, and serves content from the origin.}

\item{defaultCacheBehavior}{An object that describes the default cache behavior for the
distribution.}

\item{cacheBehaviorSettings}{An object that describes the cache behavior settings for the
distribution.

The \code{cacheBehaviorSettings} specified in your
\code{UpdateDistributionRequest} will replace your distribution's existing
settings.}

\item{cacheBehaviors}{An array of objects that describe the per-path cache behavior for the
distribution.}

\item{isEnabled}{Indicates whether to enable the distribution.}
}
\description{
Updates an existing Amazon Lightsail content delivery network (CDN) distribution.

See \url{https://paws-r.github.io/docs/lightsail/update_distribution.html} for full documentation.
}
\keyword{internal}
