% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_buckets}
\alias{lightsail_get_buckets}
\title{Returns information about one or more Amazon Lightsail buckets}
\usage{
lightsail_get_buckets(
  bucketName = NULL,
  pageToken = NULL,
  includeConnectedResources = NULL
)
}
\arguments{
\item{bucketName}{The name of the bucket for which to return information.

When omitted, the response includes all of your buckets in the Amazon
Web Services Region where the request is made.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_buckets]{get_buckets}} request. If your results are
paginated, the response will return a next page token that you can
specify as the page token in a subsequent request.}

\item{includeConnectedResources}{A Boolean value that indicates whether to include Lightsail instances
that were given access to the bucket using the
\code{\link[=lightsail_set_resource_access_for_bucket]{set_resource_access_for_bucket}}
action.}
}
\description{
Returns information about one or more Amazon Lightsail buckets. The information returned includes the synchronization status of the Amazon Simple Storage Service (Amazon S3) account-level block public access feature for your Lightsail buckets.

See \url{https://paws-r.github.io/docs/lightsail/get_buckets.html} for full documentation.
}
\keyword{internal}
