% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_update_security_group_rule_descriptions_ingress}
\alias{ec2_update_security_group_rule_descriptions_ingress}
\title{Updates the description of an ingress (inbound) security group rule}
\usage{
ec2_update_security_group_rule_descriptions_ingress(
  DryRun = NULL,
  GroupId = NULL,
  GroupName = NULL,
  IpPermissions = NULL,
  SecurityGroupRuleDescriptions = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You must
specify either the security group ID or the security group name in the
request.}

\item{IpPermissions}{The IP permissions for the security group rule. You must specify either
IP permissions or a description.}

\item{SecurityGroupRuleDescriptions}{[VPC only] The description for the ingress security group rules. You
must specify either a description or IP permissions.}
}
\description{
Updates the description of an ingress (inbound) security group rule. You can replace an existing description, or add a description to a rule that did not have one previously. You can remove a description for a security group rule by omitting the description parameter in the request.

See \url{https://paws-r.github.io/docs/ec2/update_security_group_rule_descriptions_ingress.html} for full documentation.
}
\keyword{internal}
