% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_provision_ipam_pool_cidr}
\alias{ec2_provision_ipam_pool_cidr}
\title{Provision a CIDR to an IPAM pool}
\usage{
ec2_provision_ipam_pool_cidr(
  DryRun = NULL,
  IpamPoolId,
  Cidr = NULL,
  CidrAuthorizationContext = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool to which you want to assign a CIDR.}

\item{Cidr}{The CIDR you want to assign to the IPAM pool.}

\item{CidrAuthorizationContext}{A signed document that proves that you are authorized to bring a
specified IP address range to Amazon using BYOIP. This option applies to
public pools only.}
}
\description{
Provision a CIDR to an IPAM pool. You can use this action to provision new CIDRs to a top-level pool or to transfer a CIDR from a top-level pool to a pool within it.

See \url{https://paws-r.github.io/docs/ec2/provision_ipam_pool_cidr.html} for full documentation.
}
\keyword{internal}
