% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_traffic_mirror_session}
\alias{ec2_modify_traffic_mirror_session}
\title{Modifies a Traffic Mirror session}
\usage{
ec2_modify_traffic_mirror_session(
  TrafficMirrorSessionId,
  TrafficMirrorTargetId = NULL,
  TrafficMirrorFilterId = NULL,
  PacketLength = NULL,
  SessionNumber = NULL,
  VirtualNetworkId = NULL,
  Description = NULL,
  RemoveFields = NULL,
  DryRun = NULL
)
}
\arguments{
\item{TrafficMirrorSessionId}{[required] The ID of the Traffic Mirror session.}

\item{TrafficMirrorTargetId}{The Traffic Mirror target. The target must be in the same VPC as the
source, or have a VPC peering connection with the source.}

\item{TrafficMirrorFilterId}{The ID of the Traffic Mirror filter.}

\item{PacketLength}{The number of bytes in each packet to mirror. These are bytes after the
VXLAN header. To mirror a subset, set this to the length (in bytes) to
mirror. For example, if you set this value to 100, then the first 100
bytes that meet the filter criteria are copied to the target. Do not
specify this parameter when you want to mirror the entire packet.}

\item{SessionNumber}{The session number determines the order in which sessions are evaluated
when an interface is used by multiple sessions. The first session with a
matching filter is the one that mirrors the packets.

Valid values are 1-32766.}

\item{VirtualNetworkId}{The virtual network ID of the Traffic Mirror session.}

\item{Description}{The description to assign to the Traffic Mirror session.}

\item{RemoveFields}{The properties that you want to remove from the Traffic Mirror session.

When you remove a property from a Traffic Mirror session, the property
is set to the default.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies a Traffic Mirror session.

See \url{https://paws-r.github.io/docs/ec2/modify_traffic_mirror_session.html} for full documentation.
}
\keyword{internal}
