% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_ipam_resource_cidrs}
\alias{ec2_get_ipam_resource_cidrs}
\title{Get information about the resources in a scope}
\usage{
ec2_get_ipam_resource_cidrs(
  DryRun = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  IpamScopeId,
  IpamPoolId = NULL,
  ResourceId = NULL,
  ResourceType = NULL,
  ResourceTag = NULL,
  ResourceOwner = NULL
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters for the request. For more information about
filtering, see \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html}{Filtering CLI output}.}

\item{MaxResults}{The maximum number of results to return in the request.}

\item{NextToken}{The token for the next page of results.}

\item{IpamScopeId}{[required] The ID of the scope that the resource is in.}

\item{IpamPoolId}{The ID of the IPAM pool that the resource is in.}

\item{ResourceId}{The ID of the resource.}

\item{ResourceType}{The resource type.}

\item{ResourceTag}{}

\item{ResourceOwner}{The ID of the Amazon Web Services account that owns the resource.}
}
\description{
Get information about the resources in a scope.

See \url{https://paws-r.github.io/docs/ec2/get_ipam_resource_cidrs.html} for full documentation.
}
\keyword{internal}
